/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class vCloudException
extends CloudException {
    public static Data parseException(@Nonnegative int code, @Nonnull Node errorNode) {
        Data data = new Data();
        data.code = code;
        NodeList attributes = errorNode.getChildNodes();
        String message = "Unknown";
        String major = "";
        String minor = "";
        Node n = errorNode.getAttributes().getNamedItem("minorErrorCode");
        if (n != null) {
            minor = n.getNodeValue().trim();
        }
        if ((n = errorNode.getAttributes().getNamedItem("majorErrorCode")) != null) {
            major = n.getNodeValue().trim();
        }
        if ((n = errorNode.getAttributes().getNamedItem("message")) != null) {
            message = n.getNodeValue().trim();
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            if (attr.getNodeName().equalsIgnoreCase("message") && attr.hasChildNodes()) {
                message = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("majorErrorCode") && attr.hasChildNodes()) {
                major = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!attr.getNodeName().equalsIgnoreCase("minorErrorCode") || !attr.hasChildNodes()) continue;
            minor = attr.getFirstChild().getNodeValue().trim();
        }
        data.title = major + ":" + minor;
        data.description = message;
        data.type = code == 403 || code == 401 ? CloudErrorType.AUTHENTICATION : CloudErrorType.GENERAL;
        return data;
    }

    public vCloudException(@Nonnull Data data) {
        super(data.type, data.code, data.title, data.description);
    }

    public vCloudException(@Nonnull Throwable cause) {
        super(cause);
    }

    public vCloudException(@Nonnull CloudErrorType type, @Nonnegative int code, @Nonnull String title, @Nonnull String description) {
        super(type, code, title, description);
    }

    public static class Data {
        public int code;
        public String title;
        public String description;
        public CloudErrorType type;
    }
}

