/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vcloud;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Taggable;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.vcloud.vCloud;
import org.dasein.cloud.vcloud.vCloudException;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class vCloudMethod {
    public static final String[] VERSIONS = new String[]{"5.6", "5.1", "1.5", "1.0", "0.9", "0.8"};
    public static final String CAPTURE_VAPP = "captureVApp";
    public static final String COMPOSE_VAPP = "composeVApp";
    public static final String CREATE_DISK = "createDisk";
    public static final String INSTANTIATE_VAPP = "instantiateVApp";
    private static Logger logger = vCloud.getLogger(vCloudMethod.class);
    private static Logger wire = vCloud.getWireLogger(vCloudMethod.class);
    private vCloud provider;

    public static boolean isSupported(@Nonnull String version) {
        for (String v : VERSIONS) {
            if (!version.equals(v)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(@Nonnull String currentVersion, @Nonnull String minimumVersion, @Nullable String maximumVersion) {
        if (currentVersion.equals(minimumVersion)) {
            return true;
        }
        if (maximumVersion != null && currentVersion.equals(maximumVersion)) {
            return true;
        }
        if (!vCloudMethod.isSupported(currentVersion)) {
            return false;
        }
        boolean hasMaximum = maximumVersion != null;
        boolean hitMaximum = false;
        for (String version : VERSIONS) {
            if (hasMaximum) {
                if (!hitMaximum) {
                    hitMaximum = version.equals(maximumVersion);
                    continue;
                }
                if (minimumVersion.equals(version)) {
                    return false;
                }
                if (!version.equals(currentVersion)) continue;
                return true;
            }
            if (minimumVersion.equals(version)) {
                return false;
            }
            if (!version.equals(currentVersion)) continue;
            return true;
        }
        return false;
    }

    public vCloudMethod(@Nonnull vCloud provider) {
        this.provider = provider;
    }

    public void checkError(@Nonnull Document xmlDocument) throws CloudException {
        String s;
        Node status;
        NodeList tasks;
        try {
            tasks = xmlDocument.getElementsByTagName("Task");
        }
        catch (Throwable ignore) {
            return;
        }
        if (tasks.getLength() < 1) {
            return;
        }
        Node task = tasks.item(0);
        if (task.hasAttributes() && (status = task.getAttributes().getNamedItem("status")) != null && !(s = status.getNodeValue().trim()).equals("error")) {
            NodeList elements = task.getChildNodes();
            for (int i = 0; i < elements.getLength(); ++i) {
                Node element = elements.item(i);
                if (!element.getNodeName().equalsIgnoreCase("Error")) continue;
                this.parseError(element);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOrg(@Nonnull String endpoint, @Nonnull Org org, @Nonnull String orgId) throws CloudException, InternalException {
        String xml;
        block35: {
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [GET (" + new Date() + ")] -> " + endpoint + " >--------------------------------------------------------------------------------------"));
            }
            try {
                String xml2;
                HttpResponse response;
                HttpClient client = this.getClient(false);
                HttpGet get = new HttpGet(endpoint);
                get.addHeader("Accept", "application/*+xml;version=" + org.version.version + ",application/*+xml;version=" + org.version.version);
                this.addAuth((HttpRequestBase)get, org.token);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)get.getRequestLine().toString());
                    for (Header header : get.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
                try {
                    APITrace.trace((CloudProvider)this.provider, (String)"GET org");
                    response = client.execute((HttpUriRequest)get);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                int code = response.getStatusLine().getStatusCode();
                logger.debug((Object)("HTTP STATUS: " + code));
                if (code == 404 || code == 403) {
                    throw new CloudException("Org URL is invalid");
                }
                if (code == 401) {
                    this.authenticate(true);
                    this.loadOrg(endpoint, org, orgId);
                    return;
                }
                if (code == 204) {
                    throw new CloudException("No content from org URL");
                }
                if (code == 200) {
                    try {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            xml = EntityUtils.toString((HttpEntity)entity);
                            if (wire.isDebugEnabled()) {
                                wire.debug((Object)xml);
                                wire.debug((Object)"");
                            }
                        } else {
                            xml = null;
                        }
                        break block35;
                    }
                    catch (IOException e) {
                        logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                        e.printStackTrace();
                        throw new CloudException((Throwable)e);
                    }
                }
                logger.error((Object)("Expected OK for GET request, got " + code));
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        xml2 = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)xml2);
                            wire.debug((Object)"");
                        }
                    } else {
                        xml2 = null;
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                vCloudException.Data data = null;
                if (xml2 != null && !xml2.equals("")) {
                    NodeList errors;
                    Document doc = this.parseXML(xml2);
                    String docElementTagName = doc.getDocumentElement().getTagName();
                    String nsString = "";
                    if (docElementTagName.contains(":")) {
                        nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                    }
                    if ((errors = doc.getElementsByTagName(nsString + "Error")).getLength() > 0) {
                        data = vCloudException.parseException(code, errors.item(0));
                    }
                }
                if (data == null) {
                    throw new vCloudException(CloudErrorType.GENERAL, code, response.getStatusLine().getReasonPhrase(), "No further information");
                }
                logger.error((Object)("[" + code + " : " + data.title + "] " + data.description));
                throw new vCloudException(data);
            }
            finally {
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + endpoint + " <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
            }
        }
        if (xml == null) {
            throw new CloudException("No content from org URL");
        }
        Document doc = this.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        NodeList orgList = doc.getElementsByTagName(nsString + "Org");
        for (int i = 0; i < orgList.getLength(); ++i) {
            Node href;
            Node name;
            Node type;
            Node orgNode = orgList.item(i);
            if (!orgNode.hasAttributes() || (type = orgNode.getAttributes().getNamedItem("type")) == null || !type.getNodeValue().trim().equals(this.getMediaTypeForOrg()) || (name = orgNode.getAttributes().getNamedItem("name")) == null || !name.getNodeValue().trim().equals(orgId) || (href = orgNode.getAttributes().getNamedItem("href")) == null) continue;
            Region region = new Region();
            String url = href.getNodeValue().trim();
            region.setActive(true);
            region.setAvailable(true);
            if (this.provider.isCompat()) {
                region.setProviderRegionId("/org/" + url.substring(url.lastIndexOf(47) + 1));
            } else {
                region.setProviderRegionId(url.substring(url.lastIndexOf(47) + 1));
            }
            region.setJurisdiction("US");
            region.setName(name.getNodeValue().trim());
            org.endpoint = url.substring(0, url.lastIndexOf("/api/org"));
            org.region = region;
            org.url = url;
            return;
        }
        throw new CloudException("Could not find " + orgId + " among listed orgs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public Org authenticate(boolean force) throws CloudException, InternalException {
        Iterator it;
        Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"vCloudOrgs", Org.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)25, (TimePeriodUnit)TimePeriod.MINUTE));
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was defined for this request");
        }
        String accountNumber = ctx.getAccountNumber();
        Iterable orgs = cache.get(ctx);
        Iterator iterator = it = force || orgs == null ? null : orgs.iterator();
        if (it != null) {
            if (it.hasNext()) return (Org)it.next();
        }
        String endpoint = this.getVersion().loginUrl;
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [POST (" + new Date() + ")] -> " + endpoint + " >--------------------------------------------------------------------------------------"));
        }
        try {
            StatusLine status;
            Org org;
            block42: {
                String orgList;
                NodeList orgNodes;
                block41: {
                    String body;
                    HttpEntity entity;
                    HttpResponse response;
                    block46: {
                        int len$;
                        Header[] arr$;
                        block45: {
                            String body2;
                            block43: {
                                block44: {
                                    HttpClient client = this.getClient(true);
                                    HttpPost method = new HttpPost(endpoint);
                                    org = new Org();
                                    org.version = this.getVersion();
                                    method.addHeader("Accept", "application/*+xml;version=" + org.version.version + ",application/*+xml;version=" + org.version.version);
                                    try {
                                        String password = new String(ctx.getAccessPrivate(), "utf-8");
                                        String userName = vCloudMethod.matches(this.getAPIVersion(), "0.8", "0.8") ? new String(ctx.getAccessPublic(), "utf-8") : (this.getAPIVersion().equals("5.6") ? new String(ctx.getAccessPublic(), "utf-8") : new String(ctx.getAccessPublic(), "utf-8") + "@" + ctx.getAccountNumber());
                                        String auth = new String(Base64.encodeBase64((byte[])(userName + ":" + password).getBytes()));
                                        method.addHeader("Authorization", "Basic " + auth);
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        throw new InternalException((Throwable)e);
                                    }
                                    if (wire.isDebugEnabled()) {
                                        wire.debug((Object)method.getRequestLine().toString());
                                        for (Header header : method.getAllHeaders()) {
                                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                                        }
                                        wire.debug((Object)"");
                                    }
                                    try {
                                        APITrace.trace((CloudProvider)this.provider, (String)"POST sessions");
                                        response = client.execute((HttpUriRequest)method);
                                        if (wire.isDebugEnabled()) {
                                            wire.debug((Object)response.getStatusLine().toString());
                                            for (Header header : response.getAllHeaders()) {
                                                wire.debug((Object)(header.getName() + ": " + header.getValue()));
                                            }
                                            wire.debug((Object)"");
                                        }
                                        status = response.getStatusLine();
                                    }
                                    catch (IOException e) {
                                        throw new CloudException((Throwable)e);
                                    }
                                    if (status.getStatusCode() != 200) break block43;
                                    if (!vCloudMethod.matches(this.getAPIVersion(), "0.8", "0.8")) break block44;
                                    arr$ = response.getHeaders("Set-Cookie");
                                    len$ = arr$.length;
                                    break block45;
                                }
                                org.token = response.getFirstHeader("x-vcloud-authorization").getValue();
                                break block46;
                            }
                            entity = response.getEntity();
                            if (entity == null) throw new CloudException(CloudErrorType.AUTHENTICATION, status.getStatusCode(), status.getReasonPhrase(), "Authentication failed");
                            try {
                                body2 = EntityUtils.toString((HttpEntity)entity);
                                if (wire.isDebugEnabled()) {
                                    wire.debug((Object)body2);
                                    wire.debug((Object)"");
                                }
                            }
                            catch (IOException e) {
                                throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                            }
                            vCloudException.Data data = null;
                            if (body2 != null && !body2.equals("")) {
                                NodeList errors;
                                Document doc = this.parseXML(body2);
                                String docElementTagName = doc.getDocumentElement().getTagName();
                                String nsString = "";
                                if (docElementTagName.contains(":")) {
                                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                                }
                                if ((errors = doc.getElementsByTagName(nsString + "Error")).getLength() > 0) {
                                    data = vCloudException.parseException(status.getStatusCode(), errors.item(0));
                                }
                            }
                            if (data == null) {
                                throw new vCloudException(CloudErrorType.GENERAL, status.getStatusCode(), response.getStatusLine().getReasonPhrase(), "No further information");
                            }
                            logger.error((Object)("[" + status.getStatusCode() + " : " + data.title + "] " + data.description));
                            throw new vCloudException(data);
                        }
                        for (int i$ = 0; i$ < len$; ++i$) {
                            Header h = arr$[i$];
                            String value = h.getValue();
                            if (value == null || !(value = value.trim()).startsWith("vcloud-token")) continue;
                            int idx = (value = value.substring("vcloud-token=".length())).indexOf(";");
                            org.token = idx == -1 ? value : value.substring(0, idx);
                        }
                    }
                    if (org.token == null) {
                        throw new CloudException(CloudErrorType.AUTHENTICATION, 200, "Token Empty", "No token was provided");
                    }
                    entity = response.getEntity();
                    try {
                        body = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)body);
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                    }
                    try {
                        ByteArrayInputStream bas = new ByteArrayInputStream(body.getBytes());
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder parser = factory.newDocumentBuilder();
                        Document doc = parser.parse(bas);
                        bas.close();
                        if (vCloudMethod.matches(org.version.version, "1.5", null)) {
                            orgNodes = doc.getElementsByTagName("Link");
                            orgList = null;
                            break block41;
                        }
                        NodeList orgNodes2 = doc.getElementsByTagName("Org");
                        for (int i = 0; i < orgNodes2.getLength(); ++i) {
                            Node orgNode = orgNodes2.item(i);
                            if (!orgNode.hasAttributes()) continue;
                            Node name = orgNode.getAttributes().getNamedItem("name");
                            Node href = orgNode.getAttributes().getNamedItem("href");
                            if (href == null) continue;
                            String url = href.getNodeValue().trim();
                            Region region = new Region();
                            if (!url.endsWith("/org/" + accountNumber)) continue;
                            region.setActive(true);
                            region.setAvailable(true);
                            if (this.provider.isCompat()) {
                                region.setProviderRegionId("/org/" + url.substring(url.lastIndexOf(47) + 1));
                            } else {
                                region.setProviderRegionId(url.substring(url.lastIndexOf(47) + 1));
                            }
                            region.setJurisdiction("US");
                            region.setName(name == null ? accountNumber : name.getNodeValue().trim());
                            org.endpoint = url.substring(0, url.lastIndexOf("/org/"));
                            org.region = region;
                            org.url = url;
                        }
                        break block42;
                    }
                    catch (IOException e) {
                        throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                    }
                    catch (ParserConfigurationException e) {
                        throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                    }
                    catch (SAXException e) {
                        throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                    }
                }
                for (int i = 0; i < orgNodes.getLength(); ++i) {
                    Node href;
                    Node href2;
                    Node name;
                    Node orgNode = orgNodes.item(i);
                    if (!orgNode.hasAttributes()) continue;
                    Node type = orgNode.getAttributes().getNamedItem("type");
                    if (type != null && type.getNodeValue().trim().equals(this.getMediaTypeForOrg()) && (name = orgNode.getAttributes().getNamedItem("name")) != null && name.getNodeValue().trim().equals(accountNumber) && (href2 = orgNode.getAttributes().getNamedItem("href")) != null) {
                        Region region = new Region();
                        String url = href2.getNodeValue().trim();
                        region.setActive(true);
                        region.setAvailable(true);
                        if (this.provider.isCompat()) {
                            region.setProviderRegionId("/org/" + url.substring(url.lastIndexOf(47) + 1));
                        } else {
                            region.setProviderRegionId(url.substring(url.lastIndexOf(47) + 1));
                        }
                        region.setJurisdiction("US");
                        region.setName(name.getNodeValue().trim());
                        org.endpoint = url.substring(0, url.lastIndexOf("/api/org"));
                        org.region = region;
                        org.url = url;
                    }
                    if (type == null || !type.getNodeValue().trim().equals(this.getMediaTypeForOrgList()) || (href = orgNode.getAttributes().getNamedItem("href")) == null) continue;
                    orgList = href.getNodeValue().trim();
                }
                if (org.endpoint == null && orgList != null) {
                    this.loadOrg(orgList, org, accountNumber);
                }
            }
            if (org.endpoint == null) {
                throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), "No Org", "No org was identified for " + ctx.getAccountNumber());
            }
            cache.put(ctx, Collections.singletonList(org));
            this.loadVDCs(org);
            Org org2 = org;
            return org2;
        }
        finally {
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [POST (" + new Date() + ")] -> " + endpoint + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }

    private void addAuth(HttpRequestBase method, @Nonnull String token) throws CloudException, InternalException {
        if (vCloudMethod.matches(this.getAPIVersion(), "0.8", "0.8")) {
            method.addHeader("Cookie", "vcloud-token=" + token);
        } else {
            method.addHeader("x-vcloud-authorization", token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String delete(@Nonnull String resource, @Nonnull String id) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + vCloudMethod.class.getName() + ".delete(" + resource + "," + id + ")"));
        }
        try {
            String string;
            String endpoint;
            block36: {
                int code;
                HttpResponse response;
                HttpClient client;
                block34: {
                    String len$;
                    block35: {
                        Org org = this.authenticate(false);
                        endpoint = this.toURL(resource, id);
                        client = null;
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)"");
                            wire.debug((Object)(">>> [DELETE (" + new Date() + ")] -> " + endpoint + " >--------------------------------------------------------------------------------------"));
                        }
                        try {
                            client = this.getClient(false);
                            HttpDelete delete = new HttpDelete(endpoint);
                            delete.addHeader("Accept", "application/*+xml;version=" + org.version.version + ",application/*+xml;version=" + org.version.version);
                            this.addAuth((HttpRequestBase)delete, org.token);
                            if (wire.isDebugEnabled()) {
                                wire.debug((Object)delete.getRequestLine().toString());
                                for (Header header : delete.getAllHeaders()) {
                                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                                }
                                wire.debug((Object)"");
                            }
                            try {
                                APITrace.trace((CloudProvider)this.provider, (String)("DELETE " + resource));
                                response = client.execute((HttpUriRequest)delete);
                                if (wire.isDebugEnabled()) {
                                    wire.debug((Object)response.getStatusLine().toString());
                                    for (Header header : response.getAllHeaders()) {
                                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                                    }
                                    wire.debug((Object)"");
                                }
                            }
                            catch (IOException e) {
                                logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                                e.printStackTrace();
                                throw new InternalException((Throwable)e);
                            }
                            code = response.getStatusLine().getStatusCode();
                            logger.debug((Object)("HTTP STATUS: " + code));
                            if (code != 401) break block34;
                            this.authenticate(true);
                            len$ = this.delete(resource, id);
                            if (client == null) break block35;
                        }
                        catch (Throwable throwable) {
                            if (client != null) {
                                client.getConnectionManager().shutdown();
                            }
                            if (wire.isDebugEnabled()) {
                                wire.debug((Object)("<<< [DELETE (" + new Date() + ")] -> " + endpoint + " <--------------------------------------------------------------------------------------"));
                                wire.debug((Object)"");
                            }
                            throw throwable;
                        }
                        client.getConnectionManager().shutdown();
                    }
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)("<<< [DELETE (" + new Date() + ")] -> " + endpoint + " <--------------------------------------------------------------------------------------"));
                        wire.debug((Object)"");
                    }
                    return len$;
                }
                if (code != 404 && code != 204 && code != 200 && code != 202) {
                    logger.error((Object)("DELETE request got unexpected " + code));
                    String xml = null;
                    try {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            xml = EntityUtils.toString((HttpEntity)entity);
                            if (wire.isDebugEnabled()) {
                                wire.debug((Object)xml);
                                wire.debug((Object)"");
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                        e.printStackTrace();
                        throw new CloudException((Throwable)e);
                    }
                    vCloudException.Data data = null;
                    if (xml != null && !xml.equals("")) {
                        NodeList errors;
                        Document doc = this.parseXML(xml);
                        String docElementTagName = doc.getDocumentElement().getTagName();
                        String nsString = "";
                        if (docElementTagName.contains(":")) {
                            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                        }
                        if ((errors = doc.getElementsByTagName(nsString + "Error")).getLength() > 0) {
                            data = vCloudException.parseException(code, errors.item(0));
                        }
                    }
                    if (data == null) {
                        throw new vCloudException(CloudErrorType.GENERAL, code, response.getStatusLine().getReasonPhrase(), "No further information");
                    }
                    logger.error((Object)("[" + code + " : " + data.title + "] " + data.description));
                    throw new vCloudException(data);
                }
                String xml = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        xml = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)xml);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                string = xml;
                if (client == null) break block36;
                client.getConnectionManager().shutdown();
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [DELETE (" + new Date() + ")] -> " + endpoint + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + vCloudMethod.class.getName() + ".delete()"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String get(@Nonnull String resource, @Nullable String id) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + vCloudMethod.class.getName() + ".get(" + resource + "," + id + ")"));
        }
        try {
            Org org = this.authenticate(false);
            String endpoint = this.toURL(resource, id);
            HttpClient client = null;
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [GET (" + new Date() + ")] -> " + endpoint + " >--------------------------------------------------------------------------------------"));
            }
            try {
                String xml;
                int code;
                HttpResponse response;
                block43: {
                    client = this.getClient(false);
                    HttpGet get = new HttpGet(endpoint);
                    get.addHeader("Accept", "application/*+xml;version=" + org.version.version + ",application/*+xml;version=" + org.version.version);
                    this.addAuth((HttpRequestBase)get, org.token);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)get.getRequestLine().toString());
                        for (Header header : get.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                    try {
                        APITrace.trace((CloudProvider)this.provider, (String)("GET " + resource));
                        response = client.execute((HttpUriRequest)get);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)response.getStatusLine().toString());
                            for (Header header : response.getAllHeaders()) {
                                wire.debug((Object)(header.getName() + ": " + header.getValue()));
                            }
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                        e.printStackTrace();
                        throw new InternalException((Throwable)e);
                    }
                    code = response.getStatusLine().getStatusCode();
                    logger.debug((Object)("HTTP STATUS: " + code));
                    if (code == 404 || code == 403) {
                        String len$ = null;
                        return len$;
                    }
                    if (code == 401) {
                        if (vCloudMethod.matches(this.getAPIVersion(), "1.0", null)) {
                            this.authenticate(true);
                            String len$ = this.get(resource, id);
                            return len$;
                        }
                        String len$ = null;
                        return len$;
                    }
                    if (code == 204) {
                        String len$ = "";
                        return len$;
                    }
                    if (code == 200) {
                        String xml2;
                        block42: {
                            xml2 = null;
                            try {
                                HttpEntity entity = response.getEntity();
                                if (entity == null) break block42;
                                xml2 = EntityUtils.toString((HttpEntity)entity);
                                if (wire.isDebugEnabled()) {
                                    wire.debug((Object)xml2);
                                    wire.debug((Object)"");
                                }
                            }
                            catch (IOException e) {
                                logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                                e.printStackTrace();
                                throw new CloudException((Throwable)e);
                            }
                        }
                        String e = xml2;
                        return e;
                    }
                    logger.error((Object)("Expected OK for GET request, got " + code));
                    xml = null;
                    try {
                        HttpEntity entity = response.getEntity();
                        if (entity == null) break block43;
                        xml = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)xml);
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                        e.printStackTrace();
                        throw new CloudException((Throwable)e);
                    }
                }
                vCloudException.Data data = null;
                if (xml != null && !xml.equals("")) {
                    NodeList errors;
                    Document doc = this.parseXML(xml);
                    String docElementTagName = doc.getDocumentElement().getTagName();
                    String nsString = "";
                    if (docElementTagName.contains(":")) {
                        nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                    }
                    if ((errors = doc.getElementsByTagName(nsString + "Error")).getLength() > 0) {
                        data = vCloudException.parseException(code, errors.item(0));
                    }
                }
                if (data == null) {
                    throw new vCloudException(CloudErrorType.GENERAL, code, response.getStatusLine().getReasonPhrase(), "No further information");
                }
                logger.error((Object)("[" + code + " : " + data.title + "] " + data.description));
                throw new vCloudException(data);
            }
            finally {
                if (client != null) {
                    client.getConnectionManager().shutdown();
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + endpoint + " <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + vCloudMethod.class.getName() + ".get()"));
            }
        }
    }

    @Nonnull
    public String getAction(@Nonnull String endpoint) {
        String[] parts = endpoint.split("/");
        return parts[parts.length - 1];
    }

    @Nonnull
    public String getAPIVersion() throws CloudException, InternalException {
        return this.getVersion().version;
    }

    @Nonnull
    protected HttpClient getClient(boolean forAuthentication) throws CloudException, InternalException {
        int targetPort;
        URI uri;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was defined for this request");
        }
        String endpoint = ctx.getCloud().getEndpoint();
        if (endpoint == null) {
            throw new CloudException("No cloud endpoint was defined");
        }
        boolean ssl = endpoint.startsWith("https");
        try {
            uri = new URI(endpoint);
            targetPort = uri.getPort();
            if (targetPort < 1) {
                targetPort = ssl ? 443 : 80;
            }
        }
        catch (URISyntaxException e) {
            throw new CloudException((Throwable)e);
        }
        HttpHost targetHost = new HttpHost(uri.getHost(), targetPort, uri.getScheme());
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"");
        params.setParameter("http.connection.timeout", (Object)10000);
        params.setParameter("http.socket.timeout", (Object)300000);
        Properties p = ctx.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPort = p.getProperty("proxyPort");
            if (proxyHost != null) {
                int port = 0;
                if (proxyPort != null && proxyPort.length() > 0) {
                    port = Integer.parseInt(proxyPort);
                }
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port, ssl ? "https" : "http"));
            }
        }
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        if (this.provider.isInsecure()) {
            try {
                client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        return true;
                    }
                }, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER)));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (forAuthentication) {
            try {
                String password = new String(ctx.getAccessPrivate(), "utf-8");
                String userName = vCloudMethod.matches(this.getAPIVersion(), "0.8", "0.8") ? new String(ctx.getAccessPublic(), "utf-8") : new String(ctx.getAccessPublic(), "utf-8") + "@" + ctx.getAccountNumber();
                client.getCredentialsProvider().setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(userName, password));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return client;
    }

    @Nonnull
    public String getMediaTypeForActionAddCatalog() {
        return "application/vnd.vmware.admin.catalog+xml";
    }

    @Nonnull
    public String getMediaTypeForActionAttachVolume() {
        return "application/vnd.vmware.vcloud.diskAttachOrDetachParams+xml";
    }

    @Nonnull
    public String getMediaTypeForActionInstantiateVApp() {
        return "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml";
    }

    @Nonnull
    public String getMediaTypeForActionCaptureVApp() {
        return "application/vnd.vmware.vcloud.captureVAppParams+xml";
    }

    @Nonnull
    public String getMediaTypeForActionComposeVApp() {
        return "application/vnd.vmware.vcloud.composeVAppParams+xml";
    }

    @Nonnull
    public String getMediaTypeForActionCreateDisk() {
        return "application/vnd.vmware.vcloud.diskCreateParams+xml";
    }

    @Nonnull
    public String getMediaTypeForActionDeployVApp() {
        return "application/vnd.vmware.vcloud.deployVAppParams+xml";
    }

    @Nonnull
    public String getMediaTypeForActionUndeployVApp() {
        return "application/vnd.vmware.vcloud.undeployVAppParams+xml";
    }

    @Nonnull
    public String getMediaTypeForCatalog() {
        return "application/vnd.vmware.vcloud.catalog+xml";
    }

    @Nonnull
    public String getMediaTypeForCatalogItem() {
        return "application/vnd.vmware.vcloud.catalogItem+xml";
    }

    @Nonnull
    public String getMediaTypeForDisk() {
        return "application/vnd.vmware.vcloud.disk+xml";
    }

    @Nonnull
    public String getMediaTypeForGuestCustomizationSection() {
        return "application/vnd.vmware.vcloud.guestCustomizationSection+xml";
    }

    @Nonnull
    public String getMediaTypeForMetadata() {
        return "application/vnd.vmware.vcloud.metadata+xml";
    }

    @Nonnull
    public String getMediaTypeForNetworkConnectionSection() {
        return "application/vnd.vmware.vcloud.networkConnectionSection+xml";
    }

    @Nonnull
    public String getMediaTypeForOrg() {
        return "application/vnd.vmware.vcloud.org+xml";
    }

    @Nonnull
    public String getMediaTypeForOrgList() {
        return "application/vnd.vmware.vcloud.orgList+xml";
    }

    @Nonnull
    public String getMediaTypeForRasdItem() {
        return "application/vnd.vmware.vcloud.rasdItem+xml";
    }

    @Nonnull
    public String getMediaTypeForVApp() {
        return "application/vnd.vmware.vcloud.vApp+xml";
    }

    @Nonnull
    public String getMediaTypeForVAppTemplate() {
        return "application/vnd.vmware.vcloud.vAppTemplate+xml";
    }

    @Nonnull
    public String getMediaTypeForVM() {
        return "application/vnd.vmware.vcloud.vm+xml";
    }

    @Nonnull
    public String getMediaTypeForVDC() {
        return "application/vnd.vmware.vcloud.vdc+xml";
    }

    public int getNetworkQuota() throws CloudException, InternalException {
        int quota = -2;
        for (VDC vdc : this.authenticate(false).getVdcs()) {
            int q = vdc.networkQuota;
            if (q <= -1) continue;
            if (quota == -2) {
                quota = q;
                continue;
            }
            quota += q;
        }
        return quota;
    }

    @Nonnull
    public String getOrgName(@Nonnull String href) throws CloudException, InternalException {
        NodeList orgs;
        String id = this.provider.toID(href);
        String xml = this.get("org", id);
        if (xml == null) {
            return id;
        }
        Document doc = this.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        if ((orgs = doc.getElementsByTagName(nsString + "Org")).getLength() < 1) {
            return id;
        }
        Node org = orgs.item(0);
        if (!org.hasAttributes()) {
            return id;
        }
        Node name = org.getAttributes().getNamedItem("name");
        if (name == null) {
            return id;
        }
        return name.getNodeValue().trim();
    }

    @Nonnull
    public Region getRegion() throws CloudException, InternalException {
        return this.authenticate((boolean)false).region;
    }

    @Nonnull
    private Version getVersion() throws CloudException, InternalException {
        StatusLine status;
        HttpResponse response;
        Iterator it;
        Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"vCloudVersions", Version.class, (CacheLevel)CacheLevel.CLOUD, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was defined for this request");
        }
        Iterable versions = cache.get(ctx);
        Iterator iterator = it = versions == null ? null : versions.iterator();
        if (it != null && it.hasNext()) {
            return (Version)it.next();
        }
        if (ctx.getCloud().getEndpoint().startsWith("https://vchs")) {
            Version version = new Version();
            version.loginUrl = ctx.getCloud().getEndpoint() + "/api/vchs/sessions";
            version.version = "5.6";
            cache.put(ctx, Collections.singletonList(version));
            return version;
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)"");
            wire.debug((Object)(">>> [GET (" + new Date() + ")] -> " + ctx.getCloud().getEndpoint() + " >--------------------------------------------------------------------------------------"));
        }
        final String[] preferred = this.provider.getVersionPreference();
        HttpClient client = this.getClient(false);
        HttpGet method = new HttpGet(ctx.getCloud().getEndpoint() + "/api/versions");
        if (wire.isDebugEnabled()) {
            wire.debug((Object)method.getRequestLine().toString());
            for (Header header : method.getAllHeaders()) {
                wire.debug((Object)(header.getName() + ": " + header.getValue()));
            }
            wire.debug((Object)"");
        }
        try {
            APITrace.trace((CloudProvider)this.provider, (String)"GET versions");
            response = client.execute((HttpUriRequest)method);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)response.getStatusLine().toString());
                for (Header header : response.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
            }
            status = response.getStatusLine();
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        if (status.getStatusCode() == 200) {
            String body;
            HttpEntity entity = response.getEntity();
            try {
                body = EntityUtils.toString((HttpEntity)entity);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)body);
                    wire.debug((Object)"");
                }
            }
            catch (IOException e) {
                throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
            }
            try {
                ByteArrayInputStream bas = new ByteArrayInputStream(body.getBytes());
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document doc = parser.parse(bas);
                bas.close();
                NodeList versions2 = doc.getElementsByTagName("VersionInfo");
                TreeSet<Version> set = new TreeSet<Version>(new Comparator<Version>(){

                    @Override
                    public int compare(Version version1, Version version2) {
                        if (version1.equals(version2)) {
                            return 0;
                        }
                        if (preferred != null) {
                            for (String v : preferred) {
                                if (v.equals(version1.version)) {
                                    return -1;
                                }
                                if (!v.equals(version2.version)) continue;
                                return 1;
                            }
                        }
                        for (String v : VERSIONS) {
                            if (v.equals(version1.version)) {
                                return -1;
                            }
                            if (!v.equals(version2.version)) continue;
                            return 1;
                        }
                        return -version1.version.compareTo(version2.version);
                    }
                });
                for (int i = 0; i < versions2.getLength(); ++i) {
                    Node versionInfo = versions2.item(i);
                    NodeList vattrs = versionInfo.getChildNodes();
                    String version = null;
                    String url = null;
                    for (int j = 0; j < vattrs.getLength(); ++j) {
                        Node attr = vattrs.item(j);
                        if (attr.getNodeName().equalsIgnoreCase("Version") && attr.hasChildNodes()) {
                            version = attr.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!attr.getNodeName().equalsIgnoreCase("LoginUrl") || !attr.hasChildNodes()) continue;
                        url = attr.getFirstChild().getNodeValue().trim();
                    }
                    if (version == null || url == null || !vCloudMethod.isSupported(version)) continue;
                    Version v = new Version();
                    v.version = version;
                    v.loginUrl = url;
                    set.add(v);
                }
                if (set.isEmpty()) {
                    throw new CloudException("Unable to identify a supported version");
                }
                Version v = set.iterator().next();
                cache.put(ctx, set);
                Version version = v;
                return version;
            }
            catch (IOException e) {
                throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
            }
            catch (ParserConfigurationException e) {
                throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
            }
            catch (SAXException e) {
                throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
            }
        }
        logger.error((Object)("Expected OK for GET request, got " + status.getStatusCode()));
        String xml = null;
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                xml = EntityUtils.toString((HttpEntity)entity);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)xml);
                    wire.debug((Object)"");
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
            e.printStackTrace();
            throw new CloudException((Throwable)e);
        }
        vCloudException.Data data = null;
        if (xml != null && !xml.equals("")) {
            NodeList errors;
            Document doc = this.parseXML(xml);
            String docElementTagName = doc.getDocumentElement().getTagName();
            String nsString = "";
            if (docElementTagName.contains(":")) {
                nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
            }
            if ((errors = doc.getElementsByTagName(nsString + "Error")).getLength() > 0) {
                data = vCloudException.parseException(status.getStatusCode(), errors.item(0));
            }
        }
        if (data == null) {
            throw new vCloudException(CloudErrorType.GENERAL, status.getStatusCode(), response.getStatusLine().getReasonPhrase(), "No further information");
        }
        logger.error((Object)("[" + status.getStatusCode() + " : " + data.title + "] " + data.description));
        throw new vCloudException(data);
        finally {
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + ctx.getEndpoint() + " <--------------------------------------------------------------------------------------"));
                wire.debug((Object)"");
            }
        }
    }

    public int getVMQuota() throws CloudException, InternalException {
        int quota = -2;
        for (VDC vdc : this.authenticate(false).getVdcs()) {
            int q = vdc.vmQuota;
            if (q <= -1) continue;
            if (quota == -2) {
                quota = q;
                continue;
            }
            quota += q;
        }
        return quota;
    }

    public Collection<DataCenter> listDataCenters() throws CloudException, InternalException {
        ArrayList<DataCenter> dcs = new ArrayList<DataCenter>();
        for (VDC vdc : this.authenticate(false).getVdcs()) {
            dcs.add(vdc.dataCenter);
        }
        return dcs;
    }

    private void loadVDC(@Nonnull VDC vdc, @Nonnull String id) throws CloudException, InternalException {
        String xml = this.get("vdc", id);
        if (xml != null) {
            NodeList vdcs;
            Document doc = this.parseXML(xml);
            String docElementTagName = doc.getDocumentElement().getTagName();
            String nsString = "";
            if (docElementTagName.contains(":")) {
                nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
            }
            if ((vdcs = doc.getElementsByTagName(nsString + "Vdc")).getLength() < 1) {
                return;
            }
            NodeList attributes = vdcs.item(0).getChildNodes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                boolean enabled;
                Node attribute = attributes.item(i);
                nsString = attribute.getNodeName().contains(":") ? attribute.getNodeName().substring(0, attribute.getNodeName().indexOf(":") + 1) : "";
                if (attribute.getNodeName().equalsIgnoreCase(nsString + "Link") && attribute.hasAttributes()) {
                    Node rel = attribute.getAttributes().getNamedItem("rel");
                    if (!rel.getNodeValue().trim().equalsIgnoreCase("add")) continue;
                    Node type = attribute.getAttributes().getNamedItem("type");
                    Node href = attribute.getAttributes().getNamedItem("href");
                    if (type == null || href == null) continue;
                    vdc.actions.put(type.getNodeValue().trim(), href.getNodeValue().trim());
                    continue;
                }
                if (attribute.getNodeName().equalsIgnoreCase(nsString + "VmQuota") && attribute.hasChildNodes()) {
                    try {
                        vdc.vmQuota = Integer.parseInt(attribute.getFirstChild().getNodeValue().trim());
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (attribute.getNodeName().equalsIgnoreCase(nsString + "NetworkQuota") && attribute.hasChildNodes()) {
                    try {
                        vdc.networkQuota = Integer.parseInt(attribute.getFirstChild().getNodeValue().trim());
                    }
                    catch (NumberFormatException ignore) {}
                    continue;
                }
                if (!attribute.getNodeName().equalsIgnoreCase(nsString + "IsEnabled") || !attribute.hasChildNodes() || (enabled = attribute.getFirstChild().getNodeValue().trim().equalsIgnoreCase("true"))) continue;
                vdc.dataCenter.setActive(false);
                vdc.dataCenter.setAvailable(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVDCs(@Nonnull Org org) throws CloudException, InternalException {
        block28: {
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [GET (" + new Date() + ")] -> " + org.url + " >--------------------------------------------------------------------------------------"));
            }
            try {
                StatusLine status;
                HttpResponse response;
                HttpClient client = this.getClient(false);
                HttpGet method = new HttpGet(org.url);
                method.addHeader("Accept", "application/*+xml;version=" + org.version.version + ",application/*+xml;version=" + org.version.version);
                this.addAuth((HttpRequestBase)method, org.token);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)method.getRequestLine().toString());
                    for (Header header : method.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
                try {
                    APITrace.trace((CloudProvider)this.provider, (String)"GET org");
                    response = client.execute((HttpUriRequest)method);
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)response.getStatusLine().toString());
                        for (Header header : response.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                    status = response.getStatusLine();
                }
                catch (IOException e) {
                    throw new CloudException((Throwable)e);
                }
                if (status.getStatusCode() == 200) {
                    String body;
                    HttpEntity entity = response.getEntity();
                    try {
                        body = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)body);
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                    }
                    try {
                        ByteArrayInputStream bas = new ByteArrayInputStream(body.getBytes());
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder parser = factory.newDocumentBuilder();
                        ArrayList<VDC> vdcs = new ArrayList<VDC>();
                        Document doc = parser.parse(bas);
                        bas.close();
                        NodeList links = doc.getElementsByTagName("Link");
                        for (int i = 0; i < links.getLength(); ++i) {
                            Node name;
                            Node type;
                            Node link = links.item(i);
                            if (!link.hasAttributes() || (type = link.getAttributes().getNamedItem("type")) == null || !type.getNodeValue().trim().equals("application/vnd.vmware.vcloud.vdc+xml") || (name = link.getAttributes().getNamedItem("name")) == null) continue;
                            DataCenter dc = new DataCenter();
                            VDC vdc = new VDC();
                            vdc.actions = new HashMap();
                            dc.setActive(true);
                            dc.setAvailable(true);
                            dc.setName(name.getNodeValue().trim());
                            dc.setRegionId(org.region.getProviderRegionId());
                            Node href = link.getAttributes().getNamedItem("href");
                            if (href == null) continue;
                            String id = this.provider.toID(href.getNodeValue().trim());
                            dc.setProviderDataCenterId(id);
                            vdc.dataCenter = dc;
                            this.loadVDC(vdc, id);
                            vdcs.add(vdc);
                        }
                        org.setVdcs(vdcs);
                        break block28;
                    }
                    catch (IOException e) {
                        throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                    }
                    catch (ParserConfigurationException e) {
                        throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                    }
                    catch (SAXException e) {
                        throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                    }
                }
                logger.error((Object)("Expected OK for GET request, got " + status.getStatusCode()));
                String xml = null;
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        xml = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)xml);
                            wire.debug((Object)"");
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                }
                vCloudException.Data data = null;
                if (xml != null && !xml.equals("")) {
                    NodeList errors;
                    Document doc = this.parseXML(xml);
                    String docElementTagName = doc.getDocumentElement().getTagName();
                    String nsString = "";
                    if (docElementTagName.contains(":")) {
                        nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                    }
                    if ((errors = doc.getElementsByTagName(nsString + "Error")).getLength() > 0) {
                        data = vCloudException.parseException(status.getStatusCode(), errors.item(0));
                    }
                }
                if (data == null) {
                    throw new vCloudException(CloudErrorType.GENERAL, status.getStatusCode(), response.getStatusLine().getReasonPhrase(), "No further information");
                }
                logger.error((Object)("[" + status.getStatusCode() + " : " + data.title + "] " + data.description));
                throw new vCloudException(data);
            }
            finally {
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [GET (" + new Date() + ")] -> " + org.url + " <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
            }
        }
    }

    public void parseError(@Nonnull Node errorNode) throws CloudException {
        NodeList attributes = errorNode.getChildNodes();
        CloudErrorType type = CloudErrorType.GENERAL;
        String message = "Unknown";
        String major = "";
        String minor = "";
        Node n = errorNode.getAttributes().getNamedItem("minorErrorCode");
        if (n != null) {
            minor = n.getNodeValue().trim();
        }
        if ((n = errorNode.getAttributes().getNamedItem("majorErrorCode")) != null) {
            major = n.getNodeValue().trim();
        }
        if ((n = errorNode.getAttributes().getNamedItem("message")) != null) {
            message = n.getNodeValue().trim();
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            if (attr.getNodeName().equalsIgnoreCase("message") && attr.hasChildNodes()) {
                message = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (attr.getNodeName().equalsIgnoreCase("majorErrorCode") && attr.hasChildNodes()) {
                major = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!attr.getNodeName().equalsIgnoreCase("minorErrorCode") || !attr.hasChildNodes()) continue;
            minor = attr.getFirstChild().getNodeValue().trim();
        }
        throw new CloudException(type, 200, major + ":" + minor, message);
    }

    public void parseMetaData(@Nonnull Taggable resource, @Nonnull String xml) throws CloudException, InternalException {
        Document doc = this.parseXML(xml);
        String docElementTagName = doc.getDocumentElement().getTagName();
        String nsString = "";
        if (docElementTagName.contains(":")) {
            nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
        }
        NodeList md = doc.getElementsByTagName(nsString + "MetadataEntry");
        for (int i = 0; i < md.getLength(); ++i) {
            Node entry = md.item(i);
            if (!entry.hasChildNodes()) continue;
            NodeList parts = entry.getChildNodes();
            String key = null;
            String value = null;
            for (int j = 0; j < parts.getLength(); ++j) {
                Node part = parts.item(j);
                nsString = part.getNodeName().contains(":") ? part.getNodeName().substring(0, part.getNodeName().indexOf(":") + 1) : "";
                if (part.getNodeName().equalsIgnoreCase(nsString + "Key") && part.hasChildNodes()) {
                    key = part.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (part.getNodeName().equalsIgnoreCase(nsString + "TypedValue") && part.hasChildNodes()) {
                    NodeList values = part.getChildNodes();
                    for (int k = 0; k < values.getLength(); ++k) {
                        Node v = values.item(k);
                        if (!v.getNodeName().equalsIgnoreCase(nsString + "Value") || !v.hasChildNodes()) continue;
                        value = v.getFirstChild().getNodeValue().trim();
                    }
                    continue;
                }
                if (!part.getNodeName().equalsIgnoreCase(nsString + "Value") || !part.hasChildNodes()) continue;
                value = part.getFirstChild().getNodeValue().trim();
            }
            if (key == null || value == null) continue;
            resource.setTag(key, value);
        }
    }

    @Nonnull
    public Document parseXML(@Nonnull String xml) throws CloudException, InternalException {
        try {
            ByteArrayInputStream bas = new ByteArrayInputStream(xml.getBytes());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            return parser.parse(bas);
        }
        catch (ParserConfigurationException e) {
            throw new InternalException((Throwable)e);
        }
        catch (SAXException e) {
            throw new CloudException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String post(@Nonnull String action, @Nullable String vdcId, @Nullable String payload) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + vCloudMethod.class.getName() + ".post(" + action + ")"));
        }
        try {
            String endpoint;
            String contentType;
            Org org = this.authenticate(false);
            VDC vdc = null;
            for (VDC v : org.getVdcs()) {
                if (vdcId == null) {
                    vdc = v;
                    break;
                }
                if (v.dataCenter.getProviderDataCenterId().equals(vdcId)) {
                    vdc = v;
                    break;
                }
                if (vdc != null) continue;
                vdc = v;
            }
            if (vdc == null) {
                throw new CloudException("No VDC was identified for this request (requested " + vdcId + ")");
            }
            if (action.equals(INSTANTIATE_VAPP)) {
                contentType = this.getMediaTypeForActionInstantiateVApp();
                endpoint = vdc.actions.get(contentType);
            } else if (action.equals(COMPOSE_VAPP)) {
                contentType = this.getMediaTypeForActionComposeVApp();
                endpoint = vdc.actions.get(contentType);
            } else if (action.equals(CAPTURE_VAPP)) {
                contentType = this.getMediaTypeForActionCaptureVApp();
                endpoint = vdc.actions.get(contentType);
            } else if (action.equals(CREATE_DISK)) {
                contentType = this.getMediaTypeForActionCreateDisk();
                endpoint = vdc.actions.get(contentType);
            } else {
                throw new CloudException("Unknown content type for post");
            }
            if (endpoint == null) {
                throw new CloudException("No endpoint for " + action);
            }
            String string = this.post(action, endpoint, contentType, payload);
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + vCloudMethod.class.getName() + ".post()"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public String post(@Nonnull String action, @Nonnull String endpoint, @Nullable String contentType, @Nullable String payload) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + vCloudMethod.class.getName() + ".post(" + endpoint + ")"));
        }
        try {
            HttpClient client = null;
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [POST (" + new Date() + ")] -> " + endpoint + " >--------------------------------------------------------------------------------------"));
            }
            try {
                String xml;
                int code;
                HttpResponse response;
                block44: {
                    Org org = this.authenticate(false);
                    client = this.getClient(false);
                    HttpPost post = new HttpPost(endpoint);
                    post.addHeader("Accept", "application/*+xml;version=" + org.version.version + ",application/*+xml;version=" + org.version.version);
                    this.addAuth((HttpRequestBase)post, org.token);
                    if (contentType != null) {
                        post.addHeader("Content-Type", contentType);
                    }
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)post.getRequestLine().toString());
                        for (Header header : post.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                    if (payload != null) {
                        try {
                            post.setEntity((HttpEntity)new StringEntity(payload == null ? "" : payload, "application/json", "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new InternalException((Throwable)e);
                        }
                        try {
                            wire.debug((Object)EntityUtils.toString((HttpEntity)post.getEntity()));
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                        wire.debug((Object)"");
                    }
                    try {
                        APITrace.trace((CloudProvider)this.provider, (String)("POST " + action));
                        response = client.execute((HttpUriRequest)post);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)response.getStatusLine().toString());
                            for (Header header : response.getAllHeaders()) {
                                wire.debug((Object)(header.getName() + ": " + header.getValue()));
                            }
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                        e.printStackTrace();
                        throw new InternalException((Throwable)e);
                    }
                    code = response.getStatusLine().getStatusCode();
                    logger.debug((Object)("HTTP STATUS: " + code));
                    if (code == 404) {
                        throw new CloudException("No action match for " + endpoint);
                    }
                    if (code == 401) {
                        this.authenticate(true);
                        String len$ = this.post(action, endpoint, contentType, payload);
                        return len$;
                    }
                    if (code == 204) {
                        String len$ = "";
                        return len$;
                    }
                    if (code == 200 || code == 201 || code == 202) {
                        String xml2;
                        block43: {
                            xml2 = null;
                            try {
                                HttpEntity entity = response.getEntity();
                                if (entity == null) break block43;
                                xml2 = EntityUtils.toString((HttpEntity)entity);
                                if (wire.isDebugEnabled()) {
                                    wire.debug((Object)xml2);
                                    wire.debug((Object)"");
                                }
                            }
                            catch (IOException e) {
                                logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                                e.printStackTrace();
                                throw new CloudException((Throwable)e);
                            }
                        }
                        String e = xml2;
                        return e;
                    }
                    logger.error((Object)("Expected OK or CREATED or NO_CONTENT or ACCEPTED for POST request, got " + code));
                    xml = null;
                    try {
                        HttpEntity entity = response.getEntity();
                        if (entity == null) break block44;
                        xml = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)xml);
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                        e.printStackTrace();
                        throw new CloudException((Throwable)e);
                    }
                }
                vCloudException.Data data = null;
                if (xml != null && !xml.equals("")) {
                    NodeList errors;
                    Document doc = this.parseXML(xml);
                    String docElementTagName = doc.getDocumentElement().getTagName();
                    String nsString = "";
                    if (docElementTagName.contains(":")) {
                        nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                    }
                    if ((errors = doc.getElementsByTagName(nsString + "Error")).getLength() > 0) {
                        data = vCloudException.parseException(code, errors.item(0));
                    }
                }
                if (data == null) {
                    throw new vCloudException(CloudErrorType.GENERAL, code, response.getStatusLine().getReasonPhrase(), "No further information");
                }
                logger.error((Object)("[" + code + " : " + data.title + "] " + data.description));
                throw new vCloudException(data);
            }
            finally {
                if (client != null) {
                    client.getConnectionManager().shutdown();
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [POST (" + new Date() + ")] -> " + endpoint + " <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + vCloudMethod.class.getName() + ".post()"));
            }
        }
    }

    public void postMetaData(@Nonnull String resource, @Nonnull String id, @Nonnull Map<String, Object> metadata) throws CloudException, InternalException {
        String apiVersion = this.getAPIVersion();
        StringBuilder xml = new StringBuilder();
        xml.append("<Metadata xmlns=\"http://www.vmware.com/vcloud/v1.5\" ");
        xml.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            xml.append("<MetadataEntry>");
            xml.append("<Key>").append(vCloud.escapeXml(entry.getKey())).append("</Key>");
            if (vCloudMethod.matches(apiVersion, "5.1", null)) {
                xml.append("<TypedValue xsi:type=\"MetadataStringValue\">");
            }
            xml.append("<Value>").append(vCloud.escapeXml(value.toString())).append("</Value>");
            if (vCloudMethod.matches(apiVersion, "5.1", null)) {
                xml.append("</TypedValue>");
            }
            xml.append("</MetadataEntry>");
        }
        xml.append("</Metadata>");
        this.post("metaData", this.toURL(resource, id) + "/metadata", this.getMediaTypeForMetadata(), xml.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public String put(@Nonnull String action, @Nonnull String endpoint, @Nullable String contentType, @Nullable String payload) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + vCloudMethod.class.getName() + ".put(" + endpoint + ")"));
        }
        try {
            HttpClient client = null;
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)(">>> [PUT (" + new Date() + ")] -> " + endpoint + " >--------------------------------------------------------------------------------------"));
            }
            try {
                String xml;
                int code;
                HttpResponse response;
                block44: {
                    Org org = this.authenticate(false);
                    client = this.getClient(false);
                    HttpPut put = new HttpPut(endpoint);
                    put.addHeader("Accept", "application/*+xml;version=" + org.version.version + ",application/*+xml;version=" + org.version.version);
                    this.addAuth((HttpRequestBase)put, org.token);
                    if (contentType != null) {
                        put.addHeader("Content-Type", contentType);
                    }
                    if (wire.isDebugEnabled()) {
                        wire.debug((Object)put.getRequestLine().toString());
                        for (Header header : put.getAllHeaders()) {
                            wire.debug((Object)(header.getName() + ": " + header.getValue()));
                        }
                        wire.debug((Object)"");
                    }
                    if (payload != null) {
                        try {
                            put.setEntity((HttpEntity)new StringEntity(payload == null ? "" : payload, "application/json", "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new InternalException((Throwable)e);
                        }
                        try {
                            wire.debug((Object)EntityUtils.toString((HttpEntity)put.getEntity()));
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                        wire.debug((Object)"");
                    }
                    try {
                        APITrace.trace((CloudProvider)this.provider, (String)("PUT " + action));
                        response = client.execute((HttpUriRequest)put);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)response.getStatusLine().toString());
                            for (Header header : response.getAllHeaders()) {
                                wire.debug((Object)(header.getName() + ": " + header.getValue()));
                            }
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                        e.printStackTrace();
                        throw new InternalException((Throwable)e);
                    }
                    code = response.getStatusLine().getStatusCode();
                    logger.debug((Object)("HTTP STATUS: " + code));
                    if (code == 404) {
                        throw new CloudException("No action match for " + endpoint);
                    }
                    if (code == 401) {
                        this.authenticate(true);
                        String len$ = this.post(action, endpoint, contentType, payload);
                        return len$;
                    }
                    if (code == 204) {
                        String len$ = "";
                        return len$;
                    }
                    if (code == 200 || code == 201 || code == 202) {
                        String xml2;
                        block43: {
                            xml2 = null;
                            try {
                                HttpEntity entity = response.getEntity();
                                if (entity == null) break block43;
                                xml2 = EntityUtils.toString((HttpEntity)entity);
                                if (wire.isDebugEnabled()) {
                                    wire.debug((Object)xml2);
                                    wire.debug((Object)"");
                                }
                            }
                            catch (IOException e) {
                                logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                                e.printStackTrace();
                                throw new CloudException((Throwable)e);
                            }
                        }
                        String e = xml2;
                        return e;
                    }
                    logger.error((Object)("Expected OK or CREATED or NO_CONTENT or ACCEPTED for POST request, got " + code));
                    xml = null;
                    try {
                        HttpEntity entity = response.getEntity();
                        if (entity == null) break block44;
                        xml = EntityUtils.toString((HttpEntity)entity);
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)xml);
                            wire.debug((Object)"");
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)("Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                        e.printStackTrace();
                        throw new CloudException((Throwable)e);
                    }
                }
                vCloudException.Data data = null;
                if (xml != null && !xml.equals("")) {
                    NodeList errors;
                    Document doc = this.parseXML(xml);
                    String docElementTagName = doc.getDocumentElement().getTagName();
                    String nsString = "";
                    if (docElementTagName.contains(":")) {
                        nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                    }
                    if ((errors = doc.getElementsByTagName(nsString + "Error")).getLength() > 0) {
                        data = vCloudException.parseException(code, errors.item(0));
                    }
                }
                if (data == null) {
                    throw new vCloudException(CloudErrorType.GENERAL, code, response.getStatusLine().getReasonPhrase(), "No further information");
                }
                logger.error((Object)("[" + code + " : " + data.title + "] " + data.description));
                throw new vCloudException(data);
            }
            finally {
                if (client != null) {
                    client.getConnectionManager().shutdown();
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)("<<< [PUT (" + new Date() + ")] -> " + endpoint + " <--------------------------------------------------------------------------------------"));
                    wire.debug((Object)"");
                }
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + vCloudMethod.class.getName() + ".put()"));
            }
        }
    }

    @Nonnull
    public String toAdminURL(@Nonnull String resource, @Nullable String id) throws CloudException, InternalException {
        String url;
        Org org = this.authenticate(false);
        if (id == null) {
            url = vCloudMethod.matches(org.version.version, "1.5", null) ? org.endpoint + "/api/admin/" + resource : org.endpoint + "/api/v" + org.version.version + "/admin/" + resource;
        } else {
            String r = this.provider.isCompat() ? id : "/" + resource + "/" + id;
            url = vCloudMethod.matches(org.version.version, "1.5", null) ? org.endpoint + "/api/admin" + r : org.endpoint + "/api/v" + org.version.version + "/admin" + r;
        }
        return url;
    }

    @Nonnull
    public String toURL(@Nonnull String resource, @Nullable String id) throws CloudException, InternalException {
        String url;
        Org org = this.authenticate(false);
        if (id == null) {
            url = vCloudMethod.matches(org.version.version, "1.5", null) ? org.endpoint + "/api/" + resource : org.endpoint + "/" + resource;
        } else {
            String r = this.provider.isCompat() ? id : "/" + resource + "/" + id;
            url = vCloudMethod.matches(org.version.version, "1.5", null) ? org.endpoint + "/api" + r : org.endpoint + r;
        }
        return url;
    }

    public void waitFor(@Nullable String xmlTask) throws CloudException {
        long timeout = System.currentTimeMillis() + 1800000L;
        String taskId = null;
        int passCount = 1;
        while (timeout > System.currentTimeMillis()) {
            NodeList tasks;
            if (xmlTask == null || xmlTask.equals("")) {
                return;
            }
            try {
                Document doc = this.parseXML(xmlTask);
                String docElementTagName = doc.getDocumentElement().getTagName();
                String nsString = "";
                if (docElementTagName.contains(":")) {
                    nsString = docElementTagName.substring(0, docElementTagName.indexOf(":") + 1);
                }
                tasks = doc.getElementsByTagName(nsString + "Task");
            }
            catch (Throwable ignore) {
                return;
            }
            if (tasks.getLength() < 1) {
                return;
            }
            Node task = tasks.item(0);
            if (task.hasAttributes()) {
                Node status = task.getAttributes().getNamedItem("status");
                if (status != null) {
                    String s = status.getNodeValue().trim();
                    if (s.equals("success")) {
                        return;
                    }
                    if (s.equals("error")) {
                        NodeList elements = task.getChildNodes();
                        for (int i = 0; i < elements.getLength(); ++i) {
                            Node element = elements.item(i);
                            if (!element.getNodeName().equalsIgnoreCase("Error")) continue;
                            this.parseError(element);
                            return;
                        }
                    }
                }
                if (taskId == null) {
                    Node href = task.getAttributes().getNamedItem("href");
                    if (href == null) {
                        return;
                    }
                    taskId = this.provider.toID(href.getNodeValue().trim());
                }
            }
            try {
                if (passCount > 10) {
                    Thread.sleep(10000L);
                } else {
                    Thread.sleep((long)passCount * 1000L);
                }
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                xmlTask = this.get("task", taskId);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            ++passCount;
        }
        logger.warn((Object)("Task timed out: " + taskId));
    }

    public static class VDC {
        public DataCenter dataCenter;
        public HashMap<String, String> actions;
        public int vmQuota = -2;
        public int networkQuota = -2;
    }

    public static class Version {
        public String loginUrl;
        public String version;

        public String toString() {
            return this.version + " [" + this.loginUrl + "]";
        }
    }

    public static class Org {
        public String token;
        public String endpoint;
        public Version version;
        public Region region;
        public String url;
        private volatile Iterable<VDC> _vdcs;

        public Iterable<VDC> getVdcs() throws InternalException {
            if (this._vdcs != null) {
                return this._vdcs;
            }
            int timeout = 10000;
            while (this._vdcs == null) {
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException ignore) {
                    timeout = (int)((long)timeout - 100L);
                    continue;
                }
                if ((timeout = (int)((long)timeout - 400L)) > 0) continue;
                throw new InternalException("Could not populate VDCs");
            }
            return this._vdcs;
        }

        public void setVdcs(Iterable<VDC> vdcs) {
            this._vdcs = vdcs;
        }
    }
}

