/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere;

import com.vmware.vim25.DatastoreSummary;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedEntityStatus;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ResourcePool;
import com.vmware.vim25.mo.ServiceInstance;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterCapabilities;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Folder;
import org.dasein.cloud.dc.FolderType;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.dc.StoragePool;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.vsphere.DCCapabilities;
import org.dasein.cloud.vsphere.PrivateCloud;
import org.dasein.cloud.vsphere.compute.Host;
import org.dasein.util.uom.UnitOfMeasure;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class Dc
implements DataCenterServices {
    private PrivateCloud provider;
    private volatile transient DCCapabilities capabilities;

    Dc(@Nonnull PrivateCloud cloud) {
        this.provider = cloud;
    }

    @Nonnull
    private ProviderContext getContext() throws CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        return ctx;
    }

    @Nonnull
    private ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ServiceInstance instance = this.provider.getServiceInstance();
        if (instance == null) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 401, null, "Unauthorized");
        }
        return instance;
    }

    @Nonnull
    public DataCenterCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new DCCapabilities(this.provider);
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataCenter getDataCenter(@Nonnull String dcId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getDataCenter");
        try {
            String regionId = this.getContext().getRegionId();
            if (regionId == null) {
                throw new CloudException("No region was specified for this request.");
            }
            for (DataCenter dc : this.listDataCenters(regionId)) {
                if (!dcId.equals(dc.getProviderDataCenterId())) continue;
                DataCenter dataCenter = dc;
                return dataCenter;
            }
            DataCenter dataCenter = null;
            return dataCenter;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "cluster";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "data center";
    }

    @Nullable
    public Region getRegion(@Nonnull String regionId) throws InternalException, CloudException {
        for (Region region : this.listRegions()) {
            if (!region.getProviderRegionId().equals(regionId)) continue;
            return region;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ResourcePool getResourcePoolFromClusterId(@Nonnull ServiceInstance service, @Nonnull String dcId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getResourcePoolFromClusterId");
        try {
            ManagedEntity[] clusters;
            ServiceInstance instance = this.getServiceInstance();
            DataCenter dsdc = this.getDataCenter(dcId);
            if (dsdc == null) {
                ResourcePool resourcePool = null;
                return resourcePool;
            }
            Datacenter dc = this.getVmwareDatacenterFromVDCId(instance, dsdc.getRegionId());
            if (dc == null) {
                ResourcePool resourcePool = null;
                return resourcePool;
            }
            try {
                clusters = new InventoryNavigator((ManagedEntity)dc).searchManagedEntities("ClusterComputeResource");
            }
            catch (InvalidProperty e) {
                throw new CloudException("No cluster support in datacenter: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            for (ManagedEntity entity : clusters) {
                ClusterComputeResource cluster = (ClusterComputeResource)entity;
                if (!cluster.getName().equals(dcId)) continue;
                ResourcePool resourcePool = cluster.getResourcePool();
                return resourcePool;
            }
            ResourcePool resourcePool = null;
            return resourcePool;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Datacenter getVmwareDatacenterFromVDCId(@Nonnull ServiceInstance service, @Nonnull String dcId) throws CloudException, InternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String regionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listDataCenters");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"dataCenters", DataCenter.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)15, (TimePeriodUnit)TimePeriod.MINUTE));
            Collection<DataCenter> dcs = (Collection<DataCenter>)cache.get(this.provider.getContext());
            if (dcs == null) {
                dcs = this.listDataCentersFromClusters(regionId);
                if (dcs != null && dcs.size() > 0) {
                    cache.put(this.provider.getContext(), dcs);
                    Collection<DataCenter> collection = dcs;
                    return collection;
                }
                DataCenter dc = new DataCenter();
                dc.setAvailable(true);
                dc.setActive(true);
                dc.setName(regionId);
                dc.setRegionId(regionId);
                dc.setProviderDataCenterId(regionId + "-a");
                dcs.add(dc);
                cache.put(this.provider.getContext(), dcs);
                List<DataCenter> list = Collections.singletonList(dc);
                return list;
            }
            Collection<DataCenter> collection = dcs;
            return collection;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Collection<DataCenter> listDataCentersFromClusters(@Nonnull String regionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listDataCentersFromClusters");
        try {
            ManagedEntity[] clusters;
            ArrayList<DataCenter> dataCenters = new ArrayList<DataCenter>();
            ServiceInstance instance = this.getServiceInstance();
            Datacenter dc = this.getVmwareDatacenterFromVDCId(instance, regionId);
            if (dc == null) {
                throw new CloudException("No such dc: " + regionId);
            }
            try {
                clusters = new InventoryNavigator((ManagedEntity)dc).searchManagedEntities("ClusterComputeResource");
            }
            catch (InvalidProperty e) {
                throw new CloudException("No cluster support in datacenter: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            for (ManagedEntity entity : clusters) {
                ClusterComputeResource cluster = (ClusterComputeResource)entity;
                DataCenter dataCenter = this.toDataCenter(cluster, regionId);
                if (dataCenter == null) continue;
                dataCenters.add(dataCenter);
            }
            ArrayList<DataCenter> arrayList = dataCenters;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Collection<Region> listRegions() throws InternalException, CloudException {
        return this.listRegionsFromVDCs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<org.dasein.cloud.dc.ResourcePool> listResourcePools(String providerDataCenterId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listResourcePools");
        try {
            Collection<ResourcePool> rps;
            ArrayList<org.dasein.cloud.dc.ResourcePool> list = new ArrayList<org.dasein.cloud.dc.ResourcePool>();
            DataCenter ourDC = this.provider.getDataCenterServices().getDataCenter(providerDataCenterId);
            if (ourDC != null && (rps = ourDC.getProviderDataCenterId().endsWith("-a") ? this.listResourcePoolsForDatacenter(ourDC.getRegionId()) : this.listResourcePoolsForCluster(providerDataCenterId)) != null) {
                for (ResourcePool rp : rps) {
                    list.add(this.toResourcePool(rp, providerDataCenterId));
                }
            }
            ArrayList<org.dasein.cloud.dc.ResourcePool> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ResourcePool> listResourcePoolsForCluster(String providerDataCenterId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listResourcePoolsForCluster");
        try {
            ServiceInstance instance = this.getServiceInstance();
            DataCenter dsdc = this.getDataCenter(providerDataCenterId);
            if (dsdc == null) {
                Collection<ResourcePool> collection = null;
                return collection;
            }
            Datacenter dc = this.getVmwareDatacenterFromVDCId(instance, dsdc.getRegionId());
            if (dc == null) {
                Collection<ResourcePool> collection = null;
                return collection;
            }
            ArrayList<ResourcePool> list = new ArrayList<ResourcePool>();
            try {
                ManagedEntity[] clusters = new InventoryNavigator((ManagedEntity)dc).searchManagedEntities("ClusterComputeResource");
                if (clusters != null) {
                    for (ManagedEntity entity : clusters) {
                        ResourcePool root;
                        ClusterComputeResource cluster = (ClusterComputeResource)entity;
                        if (!cluster.getName().equals(providerDataCenterId) || (root = cluster.getResourcePool()).getResourcePools() == null || root.getResourcePools().length <= 0) continue;
                        this.getChildren(root.getResourcePools(), list);
                    }
                }
            }
            catch (InvalidProperty e) {
                throw new CloudException("No cluster support in datacenter: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            ArrayList<ResourcePool> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getChildren(ResourcePool[] pools, ArrayList<ResourcePool> list) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getChildren(ResourcePool[])");
        try {
            try {
                for (ResourcePool r : pools) {
                    list.add(r);
                    if (r.getResourcePools() == null || r.getResourcePools().length <= 0) continue;
                    this.getChildren(r.getResourcePools(), list);
                }
            }
            catch (InvalidProperty e) {
                throw new CloudException("No resource pool support in cluster: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFolderChildren(com.vmware.vim25.mo.Folder folder, List<com.vmware.vim25.mo.Folder> list) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getFolderChildren(Folder)");
        try {
            try {
                ManagedEntity[] children;
                for (ManagedEntity child : children = folder.getChildEntity()) {
                    if (!(child instanceof com.vmware.vim25.mo.Folder)) continue;
                    list.add((com.vmware.vim25.mo.Folder)child);
                    this.getFolderChildren((com.vmware.vim25.mo.Folder)child, list);
                }
            }
            catch (InvalidProperty e) {
                throw new CloudException("No resource pool support in cluster: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ResourcePool> listResourcePoolsForDatacenter(String dataCenterId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listResourcePoolsForDatacenter");
        try {
            ServiceInstance instance = this.getServiceInstance();
            DataCenter dsdc = this.getDataCenter(dataCenterId);
            if (dsdc == null) {
                Collection<ResourcePool> collection = null;
                return collection;
            }
            Datacenter dc = this.getVmwareDatacenterFromVDCId(instance, dataCenterId);
            if (dc == null) {
                Collection<ResourcePool> collection = null;
                return collection;
            }
            ManagedEntity[] pools = null;
            try {
                pools = new InventoryNavigator((ManagedEntity)dc).searchManagedEntities("ResourcePool");
            }
            catch (InvalidProperty e) {
                throw new CloudException((Throwable)e);
            }
            catch (RuntimeFault e) {
                throw new InternalException((Throwable)e);
            }
            catch (RemoteException e) {
                throw new CloudException((Throwable)e);
            }
            ArrayList<ResourcePool> list = new ArrayList<ResourcePool>();
            if (pools != null) {
                for (ManagedEntity entity : pools) {
                    ResourcePool rp = (ResourcePool)entity;
                    list.add(rp);
                }
            }
            ArrayList<ResourcePool> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.dasein.cloud.dc.ResourcePool getResourcePool(String providerResourcePoolId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getResourcePool");
        try {
            Collection<DataCenter> dcs = this.listDataCenters(this.getContext().getRegionId());
            for (DataCenter dc : dcs) {
                Collection<org.dasein.cloud.dc.ResourcePool> rps = this.listResourcePools(dc.getProviderDataCenterId());
                for (org.dasein.cloud.dc.ResourcePool rp : rps) {
                    if (!rp.getProvideResourcePoolId().equals(providerResourcePoolId)) continue;
                    org.dasein.cloud.dc.ResourcePool resourcePool = rp;
                    return resourcePool;
                }
            }
            org.dasein.cloud.dc.ResourcePool resourcePool = null;
            return resourcePool;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<StoragePool> listStoragePools() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listStoragePools");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"storagePools", StoragePool.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)15, (TimePeriodUnit)TimePeriod.MINUTE));
            ArrayList<StoragePool> pools = (ArrayList<StoragePool>)cache.get(this.provider.getContext());
            if (pools == null) {
                pools = new ArrayList<StoragePool>();
                ArrayList<String> datastoreNames = new ArrayList<String>();
                Host hostSupport = this.provider.getComputeServices().getAffinityGroupSupport();
                for (DataCenter dataCenter : this.listDataCenters(this.provider.getContext().getRegionId())) {
                    boolean sameDC = false;
                    for (HostSystem host : hostSupport.listHostSystems(dataCenter.getProviderDataCenterId())) {
                        Collection<Datastore> datastores = hostSupport.listDatastoresForHost(host);
                        for (Datastore ds : datastores) {
                            if (!datastoreNames.contains(ds.getName())) {
                                datastoreNames.add(ds.getName());
                                StoragePool sp = this.toStoragePool(ds, host.getName(), dataCenter.getProviderDataCenterId());
                                pools.add(sp);
                                continue;
                            }
                            for (StoragePool storagePool : pools) {
                                if (!storagePool.getStoragePoolName().equals(ds.getName())) continue;
                                storagePool.setAffinityGroupId(null);
                                if (sameDC) continue;
                                storagePool.setDataCenterId(null);
                            }
                        }
                        sameDC = true;
                    }
                }
                cache.put(this.provider.getContext(), pools);
            }
            ArrayList<StoragePool> arrayList = pools;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public StoragePool getStoragePool(String providerStoragePoolId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getStoragePool");
        try {
            Collection<StoragePool> pools = this.listStoragePools();
            for (StoragePool pool : pools) {
                if (!pool.getStoragePoolId().equals(providerStoragePoolId)) continue;
                StoragePool storagePool = pool;
                return storagePool;
            }
            StoragePool storagePool = null;
            return storagePool;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<Folder> listVMFolders() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listVMFolders");
        try {
            ProviderContext ctx = this.getContext();
            ArrayList<com.vmware.vim25.mo.Folder> vsphereList = new ArrayList<com.vmware.vim25.mo.Folder>();
            ArrayList<Folder> list = new ArrayList<Folder>();
            ServiceInstance instance = this.getServiceInstance();
            Datacenter dc = this.getVmwareDatacenterFromVDCId(instance, ctx.getRegionId());
            if (dc == null) {
                throw new CloudException("No such dc: " + ctx.getRegionId());
            }
            try {
                com.vmware.vim25.mo.Folder vmFolder = dc.getVmFolder();
                this.getFolderChildren(vmFolder, vsphereList);
            }
            catch (InvalidProperty e) {
                throw new CloudException("No cluster support in datacenter: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            for (com.vmware.vim25.mo.Folder folder : vsphereList) {
                Folder f = this.toFolder(folder, FolderType.VM, true);
                if (f == null) continue;
                list.add(f);
            }
            ArrayList<Folder> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Folder getVMFolder(String providerVMFolderId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getVMFolder");
        try {
            ProviderContext ctx = this.getContext();
            ServiceInstance instance = this.getServiceInstance();
            Datacenter dc = this.getVmwareDatacenterFromVDCId(instance, ctx.getRegionId());
            if (dc == null) {
                throw new CloudException("No such dc: " + ctx.getRegionId());
            }
            try {
                Folder folder;
                ManagedEntity tmp = new InventoryNavigator((ManagedEntity)dc.getVmFolder()).searchManagedEntity("Folder", providerVMFolderId);
                if (tmp != null && (folder = this.toFolder((com.vmware.vim25.mo.Folder)tmp, FolderType.VM, true)).getId().equals(providerVMFolderId)) {
                    Folder folder2 = folder;
                    return folder2;
                }
                Folder folder3 = null;
                return folder3;
            }
            catch (InvalidProperty e) {
                throw new CloudException("No cluster support in region: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to region: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in region processing request: " + e.getMessage());
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourcePool getVMWareResourcePool(String providerResourcePoolId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getVMWareResourcePool");
        try {
            Collection<DataCenter> dcs = this.listDataCenters(this.getContext().getRegionId());
            for (DataCenter dc : dcs) {
                Collection<ResourcePool> rps = dc.getProviderDataCenterId().endsWith("-a") ? this.listResourcePoolsForDatacenter(dc.getRegionId()) : this.listResourcePoolsForCluster(dc.getProviderDataCenterId());
                for (ResourcePool rp : rps) {
                    if (!this.getIdForResourcePool(rp).equals(providerResourcePoolId)) continue;
                    ResourcePool resourcePool = rp;
                    return resourcePool;
                }
            }
            ResourcePool resourcePool = null;
            return resourcePool;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Collection<Region> listRegionsFromVDCs() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listRegionsFromVDCs");
        try {
            ManagedEntity[] mes;
            ArrayList<Region> regions = new ArrayList<Region>();
            ServiceInstance instance = this.getServiceInstance();
            com.vmware.vim25.mo.Folder rootFolder = instance.getRootFolder();
            try {
                mes = new InventoryNavigator((ManagedEntity)rootFolder).searchManagedEntities("Datacenter");
            }
            catch (InvalidProperty e) {
                throw new CloudException("No datacenter support: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            if (mes == null || mes.length < 1) {
                ArrayList<Region> e = regions;
                return e;
            }
            for (ManagedEntity entity : mes) {
                Region r = this.toRegion((Datacenter)entity);
                if (r == null) continue;
                regions.add(r);
            }
            ArrayList<Region> arrayList = regions;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private DataCenter toDataCenter(@Nullable ClusterComputeResource cluster, @Nonnull String regionId) {
        if (cluster == null) {
            return null;
        }
        ManagedEntityStatus status = cluster.getOverallStatus();
        DataCenter dc = new DataCenter();
        dc.setActive(true);
        dc.setActive(!status.equals((Object)ManagedEntityStatus.red));
        dc.setAvailable(true);
        dc.setName(cluster.getName());
        dc.setProviderDataCenterId(cluster.getName());
        dc.setRegionId(regionId);
        return dc;
    }

    @Nullable
    private Region toRegion(@Nullable Datacenter dc) {
        if (dc == null) {
            return null;
        }
        Region region = new Region();
        region.setActive(true);
        region.setAvailable(true);
        region.setJurisdiction("US");
        region.setName(dc.getName());
        region.setProviderRegionId(dc.getName());
        return region;
    }

    private org.dasein.cloud.dc.ResourcePool toResourcePool(@Nonnull ResourcePool resourcePool, @Nonnull String dataCenterId) {
        org.dasein.cloud.dc.ResourcePool rp = new org.dasein.cloud.dc.ResourcePool();
        rp.setName(resourcePool.getName());
        rp.setDataCenterId(dataCenterId);
        ManagedEntityStatus status = resourcePool.getRuntime().getOverallStatus();
        if (status.equals((Object)ManagedEntityStatus.red) || status.equals((Object)ManagedEntityStatus.yellow)) {
            rp.setAvailable(false);
        } else {
            rp.setAvailable(true);
        }
        rp.setProvideResourcePoolId(this.getIdForResourcePool(resourcePool));
        return rp;
    }

    public String getIdForResourcePool(ResourcePool rp) {
        String id = rp.getName();
        for (ManagedEntity parent = rp.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof ResourcePool) {
                id = parent.getName() + "." + id;
                continue;
            }
            int rPIdx = id.indexOf(".") + 1;
            if (rPIdx > 0) {
                id = id.substring(rPIdx);
                break;
            }
            return null;
        }
        return id;
    }

    private StoragePool toStoragePool(Datastore ds, String hostName, String datacenter) {
        StoragePool sp = new StoragePool();
        sp.setAffinityGroupId(hostName);
        sp.setDataCenterId(datacenter);
        sp.setRegionId(this.provider.getContext().getRegionId());
        sp.setStoragePoolName(ds.getName());
        sp.setStoragePoolId(ds.getName());
        DatastoreSummary info = ds.getSummary();
        long capacityBytes = info.getCapacity();
        long freeBytes = info.getFreeSpace();
        long provisioned = capacityBytes - freeBytes;
        sp.setCapacity((Storage)new Storage((Number)capacityBytes, (StorageUnit)Storage.BYTE).convertTo((UnitOfMeasure)Storage.MEGABYTE));
        sp.setFreeSpace((Storage)new Storage((Number)freeBytes, (StorageUnit)Storage.BYTE).convertTo((UnitOfMeasure)Storage.MEGABYTE));
        sp.setProvisioned((Storage)new Storage((Number)provisioned, (StorageUnit)Storage.BYTE).convertTo((UnitOfMeasure)Storage.MEGABYTE));
        return sp;
    }

    private Folder toFolder(com.vmware.vim25.mo.Folder folder, FolderType type, boolean checkRecursive) throws CloudException, InternalException {
        Folder f = new Folder();
        f.setId(folder.getName());
        f.setName(folder.getName());
        f.setType(type);
        if (checkRecursive) {
            ManagedEntity parent = folder.getParent();
            if (parent instanceof com.vmware.vim25.mo.Folder) {
                Folder parentFolder = this.toFolder((com.vmware.vim25.mo.Folder)parent, type, false);
                f.setParent(parentFolder);
            }
            try {
                ManagedEntity[] children;
                ArrayList<Folder> childFolders = new ArrayList<Folder>();
                for (ManagedEntity child : children = folder.getChildEntity()) {
                    if (!(child instanceof com.vmware.vim25.mo.Folder)) continue;
                    Folder childFolder = this.toFolder((com.vmware.vim25.mo.Folder)child, type, false);
                    childFolders.add(childFolder);
                }
                f.setChildren(childFolders);
            }
            catch (InvalidProperty e) {
                throw new CloudException("No folder support: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in folder processing request: " + e.getMessage());
            }
        }
        return f;
    }
}

