/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere.compute;

import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineGuestOsIdentifier;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.compute.AbstractImageSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageCapabilities;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.vsphere.PrivateCloud;
import org.dasein.cloud.vsphere.compute.TemplateCapabilities;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class Template
extends AbstractImageSupport<PrivateCloud> {
    private volatile transient TemplateCapabilities capabilities;

    Template(@Nonnull PrivateCloud cloud) {
        super((CloudProvider)cloud);
    }

    @Nonnull
    private ServiceInstance getServiceInstance() throws CloudException, InternalException {
        ServiceInstance instance = ((PrivateCloud)this.getProvider()).getServiceInstance();
        if (instance == null) {
            throw new CloudException(CloudErrorType.AUTHENTICATION, 401, null, "Unauthorized");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.remove");
        try {
            ManagedEntity[] mes;
            ServiceInstance instance = this.getServiceInstance();
            Folder folder = ((PrivateCloud)this.getProvider()).getVmFolder(instance);
            try {
                mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
            }
            catch (InvalidProperty e) {
                throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            if (mes != null && mes.length > 0) {
                for (ManagedEntity entity : mes) {
                    VirtualMachine template = (VirtualMachine)entity;
                    if (template == null || !template.getConfig().getUuid().equals(providerImageId)) continue;
                    VirtualMachineConfigInfo cfg = null;
                    try {
                        cfg = template.getConfig();
                        if (cfg == null || !cfg.isTemplate()) continue;
                        template.destroy_Task();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                    catch (RemoteException ex) {
                        throw new CloudException((Throwable)ex);
                    }
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    public ImageCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new TemplateCapabilities((PrivateCloud)this.getProvider());
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.getImage");
        try {
            for (ImageClass cls : this.getCapabilities().listSupportedImageClasses()) {
                for (MachineImage image : this.listImages(ImageFilterOptions.getInstance((ImageClass)cls))) {
                    if (!image.getProviderMachineImageId().equals(providerImageId)) continue;
                    MachineImage machineImage = image;
                    return machineImage;
                }
            }
            MachineImage machineImage = null;
            return machineImage;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private MachineImage toMachineImage(@Nullable VirtualMachine template) throws InternalException, CloudException {
        if (template != null) {
            Platform platform;
            VirtualMachineGuestOsIdentifier os;
            VirtualMachineConfigInfo vminfo;
            String ownerId = "";
            String regionId = "";
            String name = "";
            String description = "";
            String imageId = "";
            String dataCenterId = "";
            try {
                vminfo = template.getConfig();
            }
            catch (RuntimeException e) {
                return null;
            }
            try {
                os = VirtualMachineGuestOsIdentifier.valueOf((String)vminfo.getGuestId());
                platform = Platform.guess((String)vminfo.getGuestFullName());
            }
            catch (IllegalArgumentException e) {
                System.out.println("DEBUG: No such guest in enum: " + vminfo.getGuestId());
                os = null;
                platform = Platform.guess((String)vminfo.getGuestId());
            }
            Architecture arch = os == null ? (vminfo.getGuestId().contains("64") ? Architecture.I32 : Architecture.I64) : ((PrivateCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().getArchitecture(os);
            description = template.getName();
            name = template.getName();
            ownerId = this.getContext().getAccountNumber();
            imageId = vminfo.getUuid();
            for (ManagedEntity parent = template.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof Datacenter)) continue;
                Region r = ((PrivateCloud)this.getProvider()).getDataCenterServices().getRegion(parent.getName());
                regionId = r.getProviderRegionId();
                break;
            }
            VirtualMachineRuntimeInfo runtime = template.getRuntime();
            VirtualMachinePowerState state = VirtualMachinePowerState.poweredOff;
            if (runtime != null) {
                state = runtime.getPowerState();
            }
            MachineImageState imgState = state.equals((Object)VirtualMachinePowerState.poweredOff) ? MachineImageState.ACTIVE : MachineImageState.PENDING;
            MachineImage image = MachineImage.getMachineImageInstance((String)ownerId, (String)regionId, (String)imageId, (MachineImageState)imgState, (String)name, (String)description, (Architecture)arch, (Platform)platform);
            image.withSoftware("");
            image.setTags(new HashMap());
            return image;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MachineImage capture(@Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.capture");
        try {
            String vmId = options.getVirtualMachineId();
            if (vmId == null) {
                throw new CloudException("You must specify a virtual machine to capture");
            }
            ServiceInstance service = this.getServiceInstance();
            VirtualMachine vm = ((PrivateCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().getVirtualMachine(service, vmId);
            if (vm == null) {
                throw new CloudException("No such virtual machine for imaging: " + vmId);
            }
            MachineImage img = this.toMachineImage(((PrivateCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().clone(service, vm, options.getName(), true));
            if (img == null) {
                throw new CloudException("Failed to identify newly created template");
            }
            if (task != null) {
                task.completeWithResult((Object)img);
            }
            MachineImage machineImage = img;
            return machineImage;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listImageStatus(@Nonnull ImageClass cls) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listImageStatus");
        try {
            ArrayList<ResourceStatus> status = new ArrayList<ResourceStatus>();
            for (MachineImage img : this.listImages(cls)) {
                status.add(new ResourceStatus(img.getProviderMachineImageId(), (Object)img.getCurrentState()));
            }
            ArrayList<ResourceStatus> arrayList = status;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> listImages(@Nullable ImageFilterOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listImages");
        try {
            ManagedEntity[] mes;
            ArrayList<MachineImage> machineImages = new ArrayList<MachineImage>();
            ServiceInstance instance = this.getServiceInstance();
            Folder folder = ((PrivateCloud)this.getProvider()).getVmFolder(instance);
            try {
                mes = new InventoryNavigator((ManagedEntity)folder).searchManagedEntities("VirtualMachine");
            }
            catch (InvalidProperty e) {
                throw new CloudException("No virtual machine support in cluster: " + e.getMessage());
            }
            catch (RuntimeFault e) {
                throw new CloudException("Error in processing request to cluster: " + e.getMessage());
            }
            catch (RemoteException e) {
                throw new CloudException("Error in cluster processing request: " + e.getMessage());
            }
            if (mes != null && mes.length > 0) {
                for (ManagedEntity entity : mes) {
                    MachineImage image;
                    VirtualMachine template = (VirtualMachine)entity;
                    if (template == null) continue;
                    VirtualMachineConfigInfo cfg = null;
                    try {
                        cfg = template.getConfig();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                    if (cfg == null || !cfg.isTemplate() || (image = this.toMachineImage(template)) == null || options != null && !options.matches(image)) continue;
                    if (options != null) {
                        if (options.getWithAllRegions()) {
                            machineImages.add(image);
                            continue;
                        }
                        if (!image.getProviderRegionId().equals(this.getContext().getRegionId())) continue;
                        machineImages.add(image);
                        continue;
                    }
                    machineImages.add(image);
                }
            }
            ArrayList<MachineImage> arrayList = machineImages;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nonnull ImageFilterOptions options) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nullable
    private MachineImage toMachineImage(@Nonnull VirtualMachineGuestOsIdentifier osIdentifier) throws InternalException, CloudException {
        MachineImage image = null;
        String ownerId = null;
        String regionId = null;
        String imageId = null;
        String name = null;
        String description = null;
        Architecture arch = null;
        MachineImageState state = MachineImageState.ACTIVE;
        arch = ((PrivateCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().getArchitecture(osIdentifier);
        description = osIdentifier.name();
        name = this.getGuestOSNameMap().get(osIdentifier.name());
        if (name == null || name.equals("")) {
            name = osIdentifier.name();
        }
        Platform platform = Platform.guess((String)name);
        ownerId = "--public--";
        imageId = osIdentifier.name();
        regionId = this.getContext().getRegionId();
        image = MachineImage.getMachineImageInstance((String)ownerId, (String)regionId, (String)imageId, (MachineImageState)state, (String)name, (String)description, (Architecture)arch, (Platform)platform);
        image.withSoftware("");
        image.setTags(new HashMap());
        if (imageId != null && name != null) {
            return image;
        }
        return null;
    }

    @Nonnull
    private Map<String, String> getGuestOSNameMap() {
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"guestOS", Map.class, (CacheLevel)CacheLevel.CLOUD, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        ArrayList list = (ArrayList)cache.get(((PrivateCloud)this.getProvider()).getContext());
        if (list == null) {
            list = new ArrayList();
            HashMap<String, String> osMap = new HashMap<String, String>();
            osMap.put("asianux3_64Guest", "Asianux Server 3 (64 bit)");
            osMap.put("asianux3Guest", "Asianux Server 3");
            osMap.put("asianux4_64Guest", "Asianux Server 4 (64 bit)");
            osMap.put("asianux4Guest", "Asianux Server 4");
            osMap.put("centos64Guest", "CentOS 4/5 (64-bit)");
            osMap.put("centosGuest", "CentOS 4/5");
            osMap.put("darwin10_64Guest", "Mac OS 10.6 (64 bit)");
            osMap.put("darwin10Guest", "Mac OS 10.6");
            osMap.put("darwin11_64Guest", "Mac OS 10.7 (64 bit)");
            osMap.put("darwin11Guest", "Mac OS 10.7");
            osMap.put("darwin12_64Guest", "Mac OS 10.8 (64 bit)");
            osMap.put("darwin13_64Guest", "Mac OS 10.9 (64 bit)");
            osMap.put("darwin64Guest", "Mac OS 10.5 (64 bit)");
            osMap.put("darwinGuest", "Mac OS 10.5");
            osMap.put("debian4_64Guest", "Debian GNU/Linux 4 (64 bit)");
            osMap.put("debian4Guest", "Debian GNU/Linux 4");
            osMap.put("debian5_64Guest", "Debian GNU/Linux 5 (64 bit)");
            osMap.put("debian5Guest", "Debian GNU/Linux 5");
            osMap.put("debian6_64Guest", "Debian GNU/Linux 6 (64 bit)");
            osMap.put("debian6Guest", "Debian GNU/Linux 6");
            osMap.put("debian7_64Guest", "Debian GNU/Linux 7 (64 bit)");
            osMap.put("debian7Guest", "Debian GNU/Linux 7");
            osMap.put("dosGuest", "MS-DOS.");
            osMap.put("eComStation2Guest", "eComStation 2.0");
            osMap.put("eComStationGuest", "eComStation 1.x");
            osMap.put("fedora64Guest", "Fedora Linux (64 bit)");
            osMap.put("fedoraGuest", "Fedora Linux");
            osMap.put("freebsd64Guest", "FreeBSD x64");
            osMap.put("freebsdGuest", "FreeBSD");
            osMap.put("genericLinuxGuest", "Other Linux");
            osMap.put("mandrakeGuest", "Mandrake Linux");
            osMap.put("mandriva64Guest", "Mandriva Linux (64 bit)");
            osMap.put("mandrivaGuest", "Mandriva Linux");
            osMap.put("netware4Guest", "Novell NetWare 4 ");
            osMap.put("netware5Guest", "Novell NetWare 5.1");
            osMap.put("netware6Guest", "Novell NetWare 6.x");
            osMap.put("nld9Guest", "Novell Linux Desktop 9");
            osMap.put("oesGuest", "Open Enterprise Server");
            osMap.put("openServer5Guest", "SCO OpenServer 5");
            osMap.put("openServer6Guest", "SCO OpenServer 6");
            osMap.put("opensuse64Guest", "OpenSUSE Linux (64 bit)");
            osMap.put("opensuseGuest", "OpenSUSE Linux");
            osMap.put("oracleLinux64Guest", "Oracle Linux 4/5 (64-bit)");
            osMap.put("oracleLinuxGuest", "Oracle Linux 4/5");
            osMap.put("os2Guest", "OS/2");
            osMap.put("redhatGuest", "Red Hat Linux 2.1");
            osMap.put("rhel2Guest", "Red Hat Enterprise Linux 2");
            osMap.put("rhel3_64Guest", "Red Hat Enterprise Linux 3 (64 bit)");
            osMap.put("rhel3Guest", "Red Hat Enterprise Linux 3");
            osMap.put("rhel4_64Guest", "Red Hat Enterprise Linux 4 (64 bit)");
            osMap.put("rhel4Guest", "Red Hat Enterprise Linux 4");
            osMap.put("rhel5_64Guest", "Red Hat Enterprise Linux 5 (64 bit)");
            osMap.put("rhel5Guest", "Red Hat Enterprise Linux 5");
            osMap.put("rhel6_64Guest", "Red Hat Enterprise Linux 6 (64 bit)");
            osMap.put("rhel6Guest", "Red Hat Enterprise Linux 6");
            osMap.put("rhel7_64Guest", "Red Hat Enterprise Linux 7 (64 bit)");
            osMap.put("rhel7Guest", "Red Hat Enterprise Linux 7");
            osMap.put("sjdsGuest", "Sun Java Desktop System");
            osMap.put("sles10_64Guest", "Suse Linux Enterprise Server 10 (64 bit)");
            osMap.put("sles10Guest", "Suse Linux Enterprise Server 10");
            osMap.put("sles11_64Guest", "Suse Linux Enterprise Server 11 (64 bit)");
            osMap.put("sles11Guest", "Suse Linux Enterprise Server 11");
            osMap.put("sles12_64Guest", "Suse Linux Enterprise Server 12 (64 bit)");
            osMap.put("sles12Guest", "Suse linux Enterprise Server 12");
            osMap.put("sles64Guest", "Suse Linux Enterprise Server 9 (64 bit)");
            osMap.put("slesGuest", "Suse Linux Enterprise Server 9");
            osMap.put("solaris10_64Guest", "Solaris 10 (64 bit) ");
            osMap.put("solaris10Guest", "Solaris 10 (32 bit) ");
            osMap.put("solaris11_64Guest", "Solaris 11 (64 bit)");
            osMap.put("solaris6Guest", "Solaris 6");
            osMap.put("solaris7Guest", "Solaris 7");
            osMap.put("solaris8Guest", "Solaris 8");
            osMap.put("solaris9Guest", "Solaris 9");
            osMap.put("suse64Guest", "Suse Linux (64 bit)");
            osMap.put("suseGuest", "Suse Linux");
            osMap.put("turboLinux64Guest", "Turbolinux (64 bit)");
            osMap.put("turboLinuxGuest", "Turbolinux");
            osMap.put("ubuntu64Guest", "Ubuntu Linux (64 bit)");
            osMap.put("ubuntuGuest", "Ubuntu Linux");
            osMap.put("unixWare7Guest", "SCO UnixWare 7");
            osMap.put("vmkernel5Guest", "VMware ESX 5");
            osMap.put("vmkernelGuest", "VMware ESX 4");
            osMap.put("win2000AdvServGuest", "Windows 2000 Advanced Server");
            osMap.put("win2000ProGuest", "Windows 2000 Professional");
            osMap.put("win2000ServGuest", "Windows 2000 Server");
            osMap.put("win31Guest", "Windows 3.1");
            osMap.put("win95Guest", "Windows 95");
            osMap.put("win98Guest", "Windows 98");
            osMap.put("windows7_64Guest", "Windows 7 (64 bit)");
            osMap.put("windows7Guest", "Windows 7");
            osMap.put("windows7Server64Guest", "Windows Server 2008 R2 (64 bit)");
            osMap.put("windows8_64Guest", "Windows 8 (64 bit)");
            osMap.put("windows8Guest", "Windows 8");
            osMap.put("windows8Server64Guest", "Windows 8 Server (64 bit)");
            osMap.put("windowsHyperVGuest", "Windows Hyper-V");
            osMap.put("winLonghorn64Guest", "Windows Longhorn (64 bit)");
            osMap.put("winLonghornGuest", "Windows Longhorn");
            osMap.put("winMeGuest", "Windows Millenium Edition");
            osMap.put("winNetBusinessGuest", "Windows Small Business Server 2003");
            osMap.put("winNetDatacenter64Guest", "Windows Server 2003, Datacenter Edition (64 bit)");
            osMap.put("winNetDatacenterGuest", "Windows Server 2003, Datacenter Edition");
            osMap.put("winNetEnterprise64Guest", "Windows Server 2003, Enterprise Edition (64 bit)");
            osMap.put("winNetEnterpriseGuest", "Windows Server 2003, Enterprise Edition");
            osMap.put("winNetStandard64Guest", "Windows Server 2003, Standard Edition (64 bit)");
            osMap.put("winNetStandardGuest", "Windows Server 2003, Standard Edition");
            osMap.put("winNetWebGuest", "Windows Server 2003, Web Edition");
            osMap.put("winNTGuest", "Windows NT 4");
            osMap.put("winVista64Guest", "Windows Vista (64 bit)");
            osMap.put("winVistaGuest", "Windows Vista");
            osMap.put("winXPHomeGuest", "Windows XP Home Edition");
            osMap.put("winXPPro64Guest", "Windows XP Professional Edition (64 bit)");
            osMap.put("winXPProGuest", "Windows XP Professional");
            list.add(osMap);
            cache.put(((PrivateCloud)this.getProvider()).getContext(), list);
        }
        return (Map)list.iterator().next();
    }
}

