/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.vsphere.compute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.cloud.vsphere.PrivateCloud;

public class VMCapabilities
extends AbstractCapabilities<PrivateCloud>
implements VirtualMachineCapabilities {
    private static Collection<Architecture> architectures;

    public VMCapabilities(@Nonnull PrivateCloud provider) {
        super((CloudProvider)provider);
    }

    public boolean canAlter(@Nonnull VmState fromState) throws CloudException, InternalException {
        return true;
    }

    public boolean canClone(@Nonnull VmState fromState) throws CloudException, InternalException {
        return true;
    }

    public boolean canPause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canReboot(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState.equals((Object)VmState.RUNNING);
    }

    public boolean canResume(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.RUNNING);
    }

    public boolean canStart(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.RUNNING);
    }

    public boolean canStop(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.STOPPED);
    }

    public boolean canSuspend(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.SUSPENDED);
    }

    public boolean canTerminate(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.TERMINATED);
    }

    public boolean canUnpause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -1;
    }

    public int getCostFactor(@Nonnull VmState state) throws CloudException, InternalException {
        return 0;
    }

    @Nonnull
    public String getProviderTermForVirtualMachine(@Nonnull Locale locale) throws CloudException, InternalException {
        return "server";
    }

    @Nullable
    public VMScalingCapabilities getVerticalScalingCapabilities() throws CloudException, InternalException {
        return VMScalingCapabilities.getInstance((boolean)false, (boolean)false, (boolean)true);
    }

    @Nonnull
    public NamingConstraints getVirtualMachineNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)30).constrainedBy(new char[]{'-'}).lowerCaseOnly();
    }

    @Nullable
    public VisibleScope getVirtualMachineVisibleScope() {
        return null;
    }

    @Nullable
    public VisibleScope getVirtualMachineProductVisibleScope() {
        return null;
    }

    @Nonnull
    public Requirement identifyDataCenterLaunchRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyImageRequirement(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return cls.equals((Object)ImageClass.MACHINE) ? Requirement.REQUIRED : Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyStaticIPRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifySubnetRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isUserDefinedPrivateIPSupported() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        if (architectures == null) {
            ArrayList<Architecture> list = new ArrayList<Architecture>();
            list.add(Architecture.I32);
            list.add(Architecture.I64);
            architectures = Collections.unmodifiableCollection(list);
        }
        return architectures;
    }

    public boolean supportsSpotVirtualMachines() throws InternalException, CloudException {
        return false;
    }

    public boolean supportsAlterVM() {
        return true;
    }

    public boolean supportsClone() {
        return true;
    }

    public boolean supportsPause() {
        return false;
    }

    public boolean supportsReboot() {
        return true;
    }

    public boolean supportsResume() {
        return true;
    }

    public boolean supportsStart() {
        return true;
    }

    public boolean supportsStop() {
        return true;
    }

    public boolean supportsSuspend() {
        return true;
    }

    public boolean supportsTerminate() {
        return true;
    }

    public boolean supportsUnPause() {
        return false;
    }
}

