/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.perspective;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerI18n;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.uberfire.client.annotations.Perspective;
import org.uberfire.client.annotations.WorkbenchPerspective;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.ext.layout.editor.client.widgets.LayoutEditorPropertiesPresenter;
import org.uberfire.ext.plugin.client.perspective.editor.events.PerspectiveEditorFocusEvent;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@ApplicationScoped
@WorkbenchPerspective(identifier="ContentManagerPerspective")
public class ContentManagerPerspective {
    public static final String PERSPECTIVE_ID = "ContentManagerPerspective";
    @Inject
    ContentManagerI18n i18n;
    @Inject
    UberfireDocks uberfireDocks;
    @Inject
    LayoutEditorPropertiesPresenter propertiesPresenter;
    UberfireDock perspectivesExplorerDock;
    UberfireDock navigationExplorerDock;
    UberfireDock componentPaletteDock;
    UberfireDock propertiesEditorDock;
    boolean perspectiveVisible = true;
    boolean propertiesEditorVisible = false;

    @Perspective
    public PerspectiveDefinition getPerspective() {
        return this.buildPerspective();
    }

    private PerspectiveDefinition buildPerspective() {
        PerspectiveDefinitionImpl perspective = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        perspective.setName(ContentManagerConstants.INSTANCE.contentManagerHome());
        perspective.getRoot().addPart("ContentManagerHomeScreen");
        return perspective;
    }

    @AfterInitialization
    public void init() {
        this.perspectivesExplorerDock = new UberfireDock(UberfireDockPosition.WEST, IconType.FILE_TEXT_O.toString(), (PlaceRequest)new DefaultPlaceRequest("PerspectivesExplorerScreen"), PERSPECTIVE_ID).withSize(330.0).withLabel(this.i18n.capitalizeFirst(this.i18n.getPerspectivesResourceName()));
        this.navigationExplorerDock = new UberfireDock(UberfireDockPosition.WEST, IconType.NAVICON.toString(), (PlaceRequest)new DefaultPlaceRequest("NavigationExplorerScreen"), PERSPECTIVE_ID).withSize(330.0).withLabel(ContentManagerConstants.INSTANCE.contentExplorerNavigation());
        this.componentPaletteDock = new UberfireDock(UberfireDockPosition.WEST, IconType.CUBES.toString(), (PlaceRequest)new DefaultPlaceRequest("LavoutComponentPaletteScreen"), PERSPECTIVE_ID).withSize(330.0).withLabel(ContentManagerConstants.INSTANCE.componentPalette());
        this.propertiesEditorDock = new UberfireDock(UberfireDockPosition.EAST, IconType.PENCIL.toString(), (PlaceRequest)new DefaultPlaceRequest("LayoutEditorPropertiesScreen"), PERSPECTIVE_ID).withSize(300.0).withLabel(ContentManagerConstants.INSTANCE.propertiesEditor());
        this.uberfireDocks.add(new UberfireDock[]{this.perspectivesExplorerDock});
        this.uberfireDocks.add(new UberfireDock[]{this.navigationExplorerDock});
    }

    private void refreshWestDocks(boolean show, UberfireDock dockToOpen) {
        if (show && !this.perspectiveVisible) {
            this.uberfireDocks.add(new UberfireDock[]{this.componentPaletteDock});
            this.perspectiveVisible = true;
        }
        if (!show && this.perspectiveVisible) {
            this.uberfireDocks.remove(new UberfireDock[]{this.componentPaletteDock});
            this.perspectiveVisible = false;
        }
        this.uberfireDocks.show(UberfireDockPosition.WEST, PERSPECTIVE_ID);
        if (dockToOpen != null) {
            this.uberfireDocks.open(dockToOpen);
        }
    }

    private void refreshEastDocks(boolean show, UberfireDock dockToOpen) {
        if (show && !this.propertiesEditorVisible) {
            this.uberfireDocks.add(new UberfireDock[]{this.propertiesEditorDock});
            this.propertiesEditorVisible = true;
            this.uberfireDocks.show(UberfireDockPosition.EAST, PERSPECTIVE_ID);
            if (dockToOpen != null) {
                this.uberfireDocks.open(dockToOpen);
            }
        }
        if (!show && this.propertiesEditorVisible) {
            this.uberfireDocks.remove(new UberfireDock[]{this.propertiesEditorDock});
            this.propertiesEditorVisible = false;
            this.uberfireDocks.hide(UberfireDockPosition.EAST, PERSPECTIVE_ID);
        }
    }

    @OnOpen
    public void onOpen() {
        this.refreshWestDocks(false, this.perspectivesExplorerDock);
    }

    public void onPerspectiveEditorFocus(@Observes PerspectiveEditorFocusEvent event) {
        this.refreshWestDocks(true, this.componentPaletteDock);
        this.refreshEastDocks(true, this.propertiesEditorDock);
        this.propertiesPresenter.edit(event.getLayoutEditor());
    }

    public void onPerspectiveEditorHidden(@Observes PlaceHiddenEvent event) {
        String placeId = event.getPlace().getIdentifier();
        if ("Perspective Editor".equals(placeId)) {
            this.refreshWestDocks(false, null);
            this.refreshEastDocks(false, null);
        }
    }
}

