/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.cms.screen.transfer.export.wizard;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.client.cms.resources.i18n.ContentManagerConstants;
import org.dashbuilder.client.cms.screen.transfer.export.wizard.DataSetsWizardPage;
import org.dashbuilder.client.cms.screen.transfer.export.wizard.ExportSummaryWizardPage;
import org.dashbuilder.client.cms.screen.transfer.export.wizard.PagesWizardPage;
import org.dashbuilder.transfer.DataTransferExportModel;
import org.dashbuilder.transfer.ExportInfo;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.AbstractWizard;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageSelectedEvent;
import org.uberfire.mvp.ParameterizedCommand;

@ApplicationScoped
public class ExportWizard
extends AbstractWizard {
    ContentManagerConstants i18n = ContentManagerConstants.INSTANCE;
    @Inject
    DataSetsWizardPage dataSetsWizardPage;
    @Inject
    PagesWizardPage pagesWizardPage;
    @Inject
    ExportSummaryWizardPage exportSummaryWizardPage;
    @Inject
    Event<WizardPageSelectedEvent> wizardPageSelectedEvent;
    private List<WizardPage> wizardPages;
    private boolean canConclude;

    @PostConstruct
    void init() {
        this.wizardPages = new ArrayList<WizardPage>();
        this.wizardPages.add(this.dataSetsWizardPage);
        this.wizardPages.add(this.pagesWizardPage);
        this.wizardPages.add(this.exportSummaryWizardPage);
        this.exportSummaryWizardPage.setExportSummary(this::getDataTransferExportModel);
        this.exportSummaryWizardPage.setGoToDataSetsCommand(() -> this.goTo(this.dataSetsWizardPage));
        this.exportSummaryWizardPage.setGoToPagesCommand(() -> this.goTo(this.pagesWizardPage));
    }

    public void start(ExportInfo exportInfo) {
        this.dataSetsWizardPage.setDataSets(exportInfo.getDatasetsDefinitions());
        this.pagesWizardPage.setPages(exportInfo.getPages());
        this.exportSummaryWizardPage.setExportInfo(exportInfo);
        this.start();
    }

    public List<WizardPage> getPages() {
        return this.wizardPages;
    }

    public Widget getPageWidget(int pageNumber) {
        return this.wizardPages.get(pageNumber).asWidget();
    }

    public String getTitle() {
        return this.i18n.exportWizardTitle();
    }

    public int getPreferredWidth() {
        return 900;
    }

    public int getPreferredHeight() {
        return 600;
    }

    public void isComplete(Callback<Boolean> callback) {
        callback.callback((Object)this.canConclude);
    }

    private void goTo(WizardPage page) {
        this.wizardPageSelectedEvent.fire((Object)new WizardPageSelectedEvent(page));
    }

    public DataTransferExportModel getDataTransferExportModel() {
        return new DataTransferExportModel(this.dataSetsWizardPage.getSelectedDataSetDefs(), this.pagesWizardPage.getSelectedPages(), true);
    }

    public void setDownloadCallback(ParameterizedCommand<DataTransferExportModel> dataTransferExportModelCallback) {
        this.exportSummaryWizardPage.setDownloadCallback(dataTransferExportModelCallback);
    }

    public void setOpenCallback(ParameterizedCommand<DataTransferExportModel> dataTransferExportModelCallback) {
        this.exportSummaryWizardPage.setOpenCallback(dataTransferExportModelCallback);
    }

    public void pageSelected(int pageNumber) {
        super.pageSelected(pageNumber);
        WizardPage page = this.getPages().get(pageNumber);
        page.prepareView();
        this.canConclude = page == this.exportSummaryWizardPage;
        this.checkPagesState();
    }
}

