/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.util.Arrays;
import java.util.List;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.ValidationError;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.junit.Assert;
import org.junit.Test;

public class DataSetLookupConstraintsTest {
    public static final String OFFICE = "office";
    public static final String DEPARTMENT = "department";
    public static final String EMPLOYEE = "employee";
    public static final String AMOUNT = "amount";
    public static final String DATE = "date";
    public static final DataSetMetadata METADATA = new DataSetMetadataImpl(null, "test", 100, 5, Arrays.asList("office", "department", "employee", "amount", "date"), Arrays.asList(ColumnType.LABEL, ColumnType.LABEL, ColumnType.LABEL, ColumnType.NUMBER, ColumnType.DATE), 0);
    public static final DataSetLookupConstraints TWO_COLUMNS_GROUPED = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(2)).setMinColumns(2)).setExtraColumnsAllowed(false)).setGroupsTitle("Categories").setColumnsTitle("Values").setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
    public static final DataSetLookupConstraints MULTIPLE_COLUMNS = ((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupAllowed(true).setGroupRequired(false).setMaxColumns(-1)).setMinColumns(1)).setExtraColumnsAllowed(true)).setGroupsTitle("Rows").setColumnsTitle("Columns");

    @Test
    public void testTwoColumns() {
        DataSetLookup lookup = TWO_COLUMNS_GROUPED.newDataSetLookup(METADATA);
        Assert.assertEquals((Object)lookup.getDataSetUUID(), (Object)"test");
        List opList = lookup.getOperationList();
        Assert.assertEquals((long)opList.size(), (long)1L);
        List groupList = lookup.getOperationList(DataSetGroup.class);
        Assert.assertEquals((long)groupList.size(), (long)1L);
        DataSetGroup groupOp = (DataSetGroup)groupList.get(0);
        Assert.assertNotNull((Object)groupOp);
        Assert.assertEquals((long)groupOp.getGroupFunctions().size(), (long)2L);
        ColumnGroup cg = groupOp.getColumnGroup();
        Assert.assertNotNull((Object)groupOp);
        Assert.assertEquals((Object)cg.getSourceId(), (Object)OFFICE);
        Assert.assertEquals((Object)cg.getColumnId(), (Object)OFFICE);
        Assert.assertEquals((Object)cg.getStrategy(), (Object)GroupStrategy.DYNAMIC);
        GroupFunction gf1 = groupOp.getGroupFunction(OFFICE);
        Assert.assertNotNull((Object)gf1);
        Assert.assertNull((Object)gf1.getFunction());
        Assert.assertEquals((Object)gf1.getSourceId(), (Object)OFFICE);
        Assert.assertEquals((Object)gf1.getColumnId(), (Object)OFFICE);
        GroupFunction gf2 = groupOp.getGroupFunction(AMOUNT);
        Assert.assertNotNull((Object)gf2);
        Assert.assertNotNull((Object)gf2.getFunction());
        Assert.assertEquals((Object)gf2.getSourceId(), (Object)AMOUNT);
        Assert.assertEquals((Object)gf2.getColumnId(), (Object)AMOUNT);
    }

    @Test
    public void testMultipleColumns() {
        DataSetLookup lookup = MULTIPLE_COLUMNS.newDataSetLookup(METADATA);
        Assert.assertEquals((Object)lookup.getDataSetUUID(), (Object)"test");
        List opList = lookup.getOperationList();
        Assert.assertEquals((long)opList.size(), (long)1L);
        List groupList = lookup.getOperationList(DataSetGroup.class);
        Assert.assertEquals((long)groupList.size(), (long)1L);
        DataSetGroup groupOp = (DataSetGroup)groupList.get(0);
        Assert.assertNotNull((Object)groupOp);
        ColumnGroup cg = groupOp.getColumnGroup();
        Assert.assertNull((Object)cg);
        Assert.assertEquals((long)groupOp.getGroupFunctions().size(), (long)METADATA.getNumberOfColumns());
        for (int i = 0; i < METADATA.getNumberOfColumns(); ++i) {
            GroupFunction gf = groupOp.getGroupFunction(METADATA.getColumnId(i));
            Assert.assertNotNull((Object)gf);
            Assert.assertEquals((Object)gf.getSourceId(), (Object)METADATA.getColumnId(i));
            Assert.assertEquals((Object)gf.getColumnId(), (Object)METADATA.getColumnId(i));
            Assert.assertNull((Object)gf.getFunction());
        }
    }

    @Test
    public void testValidationOk() {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().group(DATE)).fixed(DateIntervalType.MONTH, true)).column(DATE)).column(AMOUNT, AggregateFunctionType.SUM)).buildLookup();
        ValidationError error = TWO_COLUMNS_GROUPED.check(lookup, METADATA);
        Assert.assertNull((Object)error);
    }

    @Test
    public void testColumnExcess() {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().group(DATE)).fixed(DateIntervalType.MONTH, true)).column(DATE)).column(AMOUNT, AggregateFunctionType.SUM)).column(AMOUNT, AggregateFunctionType.AVERAGE)).buildLookup();
        ValidationError error = TWO_COLUMNS_GROUPED.check(lookup, METADATA);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((long)error.getCode(), (long)101L);
    }

    @Test
    public void testColumnMissing() {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().group(DEPARTMENT)).column(AMOUNT, AggregateFunctionType.SUM)).buildLookup();
        ValidationError error = TWO_COLUMNS_GROUPED.check(lookup, METADATA);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((long)error.getCode(), (long)101L);
    }

    @Test
    public void testMissingGroup() {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().column(DATE)).column(AMOUNT, AggregateFunctionType.SUM)).buildLookup();
        ValidationError error = TWO_COLUMNS_GROUPED.check(lookup, METADATA);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((long)error.getCode(), (long)203L);
    }

    @Test
    public void testWrongColumnType() {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().group(DEPARTMENT)).column(DEPARTMENT)).column(EMPLOYEE)).buildLookup();
        ValidationError error = TWO_COLUMNS_GROUPED.check(lookup, METADATA);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((long)error.getCode(), (long)100L);
        lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().group(DATE)).column(DATE)).column(EMPLOYEE)).buildLookup();
        error = TWO_COLUMNS_GROUPED.check(lookup, METADATA);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((long)error.getCode(), (long)100L);
    }

    @Test
    public void testUniqueColumns() {
        DataSetLookupConstraints UNIQUE_COLUMNS = new DataSetLookupConstraints().setUniqueColumnIds(true);
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().group(DEPARTMENT)).column(DEPARTMENT, "dept")).column(AMOUNT, AggregateFunctionType.AVERAGE, AMOUNT)).column(AMOUNT, AggregateFunctionType.SUM, AMOUNT)).buildLookup();
        ValidationError error = UNIQUE_COLUMNS.check(lookup, METADATA);
        Assert.assertNotNull((Object)error);
        Assert.assertEquals((long)error.getCode(), (long)204L);
        UNIQUE_COLUMNS.setUniqueColumnIds(false);
        error = UNIQUE_COLUMNS.check(lookup, METADATA);
        Assert.assertNull((Object)error);
    }
}

