/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.filter;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;

public class CoreFunctionFilter
extends ColumnFilter {
    protected CoreFunctionType type = null;
    protected List parameters = new ArrayList();

    public CoreFunctionFilter() {
    }

    public CoreFunctionFilter(String columnId, CoreFunctionType type) {
        super(columnId);
        this.type = type;
    }

    public CoreFunctionFilter(String columnId, CoreFunctionType type, List parameters) {
        super(columnId);
        this.type = type;
        this.setParameters(parameters);
    }

    public CoreFunctionFilter(String columnId, CoreFunctionType type, Comparable ... parameters) {
        super(columnId);
        this.type = type;
        this.setParameters(parameters);
    }

    public CoreFunctionType getType() {
        return this.type;
    }

    public void setType(CoreFunctionType type) {
        this.type = type;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(Comparable ... newParameters) {
        this.parameters.clear();
        if (newParameters != null) {
            for (Comparable param : newParameters) {
                this.parameters.add(param);
            }
        }
    }

    public void setParameters(List newParameters) {
        this.parameters.clear();
        if (newParameters != null) {
            this.parameters.addAll(newParameters);
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (CoreFunctionType.BETWEEN.equals((Object)this.type)) {
            out.append(this.columnId).append(" between (");
            this.appendParameters(out);
            out.append(")");
        } else if (CoreFunctionType.GREATER_THAN.equals((Object)this.type)) {
            out.append(this.columnId).append(" > ");
            this.appendParameters(out);
        } else if (CoreFunctionType.GREATER_OR_EQUALS_TO.equals((Object)this.type)) {
            out.append(this.columnId).append(" >= ");
            this.appendParameters(out);
        } else if (CoreFunctionType.LOWER_THAN.equals((Object)this.type)) {
            out.append(this.columnId).append(" < ");
            this.appendParameters(out);
        } else if (CoreFunctionType.LOWER_OR_EQUALS_TO.equals((Object)this.type)) {
            out.append(this.columnId).append(" <= ");
            this.appendParameters(out);
        } else if (CoreFunctionType.EQUALS_TO.equals((Object)this.type)) {
            out.append(this.columnId).append(" = ");
            this.appendParameters(out);
        } else if (CoreFunctionType.NOT_EQUALS_TO.equals((Object)this.type)) {
            out.append(this.columnId).append(" != ");
            this.appendParameters(out);
        } else if (CoreFunctionType.LIKE_TO.equals((Object)this.type)) {
            out.append(this.columnId).append(" like ");
            this.appendParameters(out);
        } else if (CoreFunctionType.IS_NULL.equals((Object)this.type)) {
            out.append(this.columnId).append(" is_null ");
            this.appendParameters(out);
        } else if (CoreFunctionType.NOT_NULL.equals((Object)this.type)) {
            out.append(this.columnId).append(" not_null ");
            this.appendParameters(out);
        } else if (CoreFunctionType.TIME_FRAME.equals((Object)this.type)) {
            out.append(this.columnId).append(" time_frame ");
            this.appendParameters(out);
        } else if (CoreFunctionType.IN.equals((Object)this.type)) {
            out.append(this.columnId).append(" in ");
            this.appendParameters(out);
        } else if (CoreFunctionType.NOT_IN.equals((Object)this.type)) {
            out.append(this.columnId).append(" not_in ");
            this.appendParameters(out);
        }
        return out.toString();
    }

    private StringBuilder appendParameters(StringBuilder out) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i > 0) {
                out.append(", ");
            }
            out.append(this.parameters.get(i));
        }
        return out;
    }

    @Override
    public ColumnFilter cloneInstance() {
        CoreFunctionFilter clone = new CoreFunctionFilter();
        clone.columnId = this.columnId;
        clone.type = this.type;
        clone.parameters.addAll(this.parameters);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            CoreFunctionFilter other = (CoreFunctionFilter)obj;
            if (!super.equals(other)) {
                return false;
            }
            if (this.type != null && !this.type.equals((Object)other.type)) {
                return false;
            }
            if (this.parameters.size() != other.parameters.size()) {
                return false;
            }
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (this.parameters.get(i).equals(other.parameters.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

