/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.impl;

import java.util.List;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupBuilder;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;

public abstract class AbstractDataSetLookupBuilder<T>
implements DataSetLookupBuilder<T> {
    private static final String SYMBOL_UNDERSCORE = "_";
    private DataSetLookup dataSetLookup = new DataSetLookup();

    protected DataSetOp getCurrentOp() {
        List<DataSetOp> dataSetOps = this.dataSetLookup.getOperationList();
        if (dataSetOps.isEmpty()) {
            return null;
        }
        return dataSetOps.get(dataSetOps.size() - 1);
    }

    @Override
    public T dataset(String uuid) {
        this.dataSetLookup.setDataSetUUID(uuid);
        return (T)this;
    }

    @Override
    public T rowOffset(int offset) {
        this.dataSetLookup.setRowOffset(offset);
        return (T)this;
    }

    @Override
    public T rowNumber(int rows) {
        this.dataSetLookup.setNumberOfRows(rows);
        return (T)this;
    }

    @Override
    public T group(String columnId) {
        return this.group(columnId, columnId);
    }

    @Override
    public T group(String columnId, String newColumnId) {
        DataSetGroup gOp = new DataSetGroup();
        gOp.setColumnGroup(new ColumnGroup(columnId, newColumnId));
        this.dataSetLookup.addOperation(gOp);
        return (T)this;
    }

    @Override
    public T join() {
        DataSetGroup gOp = (DataSetGroup)this.getCurrentOp();
        if (gOp == null || gOp.getColumnGroup() == null) {
            throw new RuntimeException("group() must be called first.");
        }
        gOp.setJoin(true);
        return (T)this;
    }

    @Override
    public T asc() {
        DataSetGroup gOp = (DataSetGroup)this.getCurrentOp();
        if (gOp == null || gOp.getColumnGroup() == null) {
            throw new RuntimeException("group() must be called first.");
        }
        ColumnGroup columnGroup = gOp.getColumnGroup();
        columnGroup.setAscendingOrder(true);
        return (T)this;
    }

    @Override
    public T desc() {
        DataSetGroup gOp = (DataSetGroup)this.getCurrentOp();
        if (gOp == null || gOp.getColumnGroup() == null) {
            throw new RuntimeException("group() must be called first.");
        }
        ColumnGroup columnGroup = gOp.getColumnGroup();
        columnGroup.setAscendingOrder(false);
        return (T)this;
    }

    @Override
    public T dynamic(int maxIntervals, boolean emptyAllowed) {
        return this.groupStrategy(GroupStrategy.DYNAMIC, maxIntervals, null, emptyAllowed);
    }

    @Override
    public T dynamic(int maxIntervals, DateIntervalType intervalSize, boolean emptyAllowed) {
        return this.groupStrategy(GroupStrategy.DYNAMIC, maxIntervals, intervalSize.toString(), emptyAllowed);
    }

    @Override
    public T dynamic(DateIntervalType intervalSize, boolean emptyAllowed) {
        return this.groupStrategy(GroupStrategy.DYNAMIC, -1, intervalSize.toString(), emptyAllowed);
    }

    @Override
    public T fixed(DateIntervalType intervalSize, boolean emptyAllowed) {
        if (!DateIntervalType.FIXED_INTERVALS_SUPPORTED.contains((Object)intervalSize)) {
            throw new IllegalArgumentException("Fixed group size '" + (Object)((Object)intervalSize) + "' not supported.");
        }
        return this.groupStrategy(GroupStrategy.FIXED, -1, intervalSize.toString(), emptyAllowed);
    }

    @Override
    public T firstDay(DayOfWeek dayOfWeek) {
        DataSetGroup gOp = (DataSetGroup)this.getCurrentOp();
        if (gOp == null || gOp.getColumnGroup() == null) {
            throw new RuntimeException("group() must be called first.");
        }
        ColumnGroup columnGroup = gOp.getColumnGroup();
        if (!GroupStrategy.FIXED.equals((Object)columnGroup.getStrategy())) {
            throw new RuntimeException("A fixed group is required.");
        }
        if (!DateIntervalType.DAY_OF_WEEK.equals((Object)DateIntervalType.getByName(columnGroup.getIntervalSize()))) {
            throw new RuntimeException("A fixed DAY_OF_WEEK date group is required.");
        }
        columnGroup.setFirstDayOfWeek(dayOfWeek);
        return (T)this;
    }

    @Override
    public T firstMonth(Month month) {
        DataSetGroup gOp = (DataSetGroup)this.getCurrentOp();
        if (gOp == null || gOp.getColumnGroup() == null) {
            throw new RuntimeException("group() must be called first.");
        }
        ColumnGroup columnGroup = gOp.getColumnGroup();
        if (!GroupStrategy.FIXED.equals((Object)columnGroup.getStrategy())) {
            throw new RuntimeException("A fixed group is required.");
        }
        if (!DateIntervalType.MONTH.equals((Object)DateIntervalType.getByName(columnGroup.getIntervalSize()))) {
            throw new RuntimeException("A fixed MONTH date group is required.");
        }
        columnGroup.setFirstMonthOfYear(month);
        return (T)this;
    }

    private T groupStrategy(GroupStrategy strategy, int maxIntervals, String intervalSize, boolean emptyAllowed) {
        DataSetGroup gOp = (DataSetGroup)this.getCurrentOp();
        if (gOp == null || gOp.getColumnGroup() == null) {
            throw new RuntimeException("group() must be called first.");
        }
        ColumnGroup cg = gOp.getColumnGroup();
        cg.setStrategy(strategy);
        cg.setMaxIntervals(maxIntervals);
        cg.setIntervalSize(intervalSize);
        cg.setEmptyIntervalsAllowed(emptyAllowed);
        return (T)this;
    }

    @Override
    public T select(String ... intervalNames) {
        DataSetOp op = this.getCurrentOp();
        if (op == null || !(op instanceof DataSetGroup)) {
            this.dataSetLookup.addOperation(new DataSetGroup());
        }
        DataSetGroup gOp = (DataSetGroup)this.getCurrentOp();
        gOp.addSelectedIntervalNames(intervalNames);
        return (T)this;
    }

    @Override
    public T filter(ColumnFilter ... filters) {
        return this.filter((String)null, filters);
    }

    @Override
    public T filter(String columnId, ColumnFilter ... filters) {
        DataSetOp op = this.getCurrentOp();
        if (op == null || !(op instanceof DataSetFilter)) {
            this.dataSetLookup.addOperation(new DataSetFilter());
        }
        DataSetFilter fOp = (DataSetFilter)this.getCurrentOp();
        for (ColumnFilter filter : filters) {
            if (columnId != null) {
                filter.setColumnId(columnId);
            }
            fOp.addFilterColumn(filter);
        }
        return (T)this;
    }

    @Override
    public T sort(String columnId, String order) {
        return this.sort(columnId, SortOrder.getByName(order));
    }

    @Override
    public T sort(String columnId, SortOrder order) {
        DataSetOp op = this.getCurrentOp();
        if (op == null || !(op instanceof DataSetSort)) {
            this.dataSetLookup.addOperation(new DataSetSort());
        }
        DataSetSort sOp = (DataSetSort)this.getCurrentOp();
        sOp.addSortColumn(new ColumnSort(columnId, order));
        return (T)this;
    }

    @Override
    public T column(String columnId) {
        return this.column(columnId, null, columnId);
    }

    @Override
    public T column(String columnId, String newColumnId) {
        return this.column(columnId, null, newColumnId);
    }

    @Override
    public T column(String columnId, AggregateFunctionType function) {
        String newColumnId = this.buildColumnId(columnId, function);
        return this.column(columnId, function, newColumnId);
    }

    @Override
    public T column(AggregateFunctionType function, String newColumnId) {
        return this.column(null, function, newColumnId);
    }

    @Override
    public T column(String columnId, AggregateFunctionType function, String newColumnId) {
        DataSetOp op = this.getCurrentOp();
        if (op == null || !(op instanceof DataSetGroup) || ((DataSetGroup)op).isSelect()) {
            this.dataSetLookup.addOperation(new DataSetGroup());
        }
        DataSetGroup gOp = (DataSetGroup)this.getCurrentOp();
        gOp.addGroupFunction(new GroupFunction(columnId, newColumnId, function));
        return (T)this;
    }

    @Override
    public DataSetLookup buildLookup() {
        return this.dataSetLookup;
    }

    protected String buildColumnId(String sourceId, AggregateFunctionType function) {
        if (sourceId == null || sourceId.trim().length() == 0) {
            return function.name().toLowerCase();
        }
        return sourceId + SYMBOL_UNDERSCORE + function.name().toLowerCase();
    }
}

