/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.model;

import java.sql.Connection;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.Table;

public class SQLStatement<T extends SQLStatement> {
    protected Connection connection;
    protected Dialect dialect;
    protected Table table = null;

    public SQLStatement(Connection connection, Dialect dialect) {
        this.connection = connection;
        this.dialect = dialect;
    }

    public T table(Table table) {
        this.table = this.fix(table);
        return (T)this;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public Table getTable() {
        return this.table;
    }

    protected Table fix(Table table) {
        String name = this.fix(table.getName());
        table.setName(name);
        return table;
    }

    protected Column fix(Column column) {
        String name = this.fix(column.getName());
        column.setName(name);
        return column;
    }

    protected String fix(String id) {
        return JDBCUtils.fixCase(this.connection, id);
    }
}

