/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.json;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.Date;
import java.util.List;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;

public class DataSetJSONMarshaller {
    private static final String DATASET_COLUMN = "column";
    private static final String DATASET_COLUMN_ID = "id";
    private static final String DATASET_COLUMN_TYPE = "type";
    private static final String DATASET_COLUMN_VALUES = "values";

    public JSONObject toJson(DataSet dataSet) {
        JSONObject json = new JSONObject();
        if (dataSet != null) {
            int i = 0;
            for (DataColumn dataColumn : dataSet.getColumns()) {
                json.put("column." + i++, (JSONValue)this.formatDataColumn(dataColumn));
            }
        }
        return json;
    }

    private JSONObject formatDataColumn(DataColumn dataColumn) {
        JSONObject columnJson = new JSONObject();
        if (dataColumn != null) {
            columnJson.put(DATASET_COLUMN_ID, (JSONValue)new JSONString(dataColumn.getId()));
            columnJson.put(DATASET_COLUMN_TYPE, (JSONValue)new JSONString(dataColumn.getColumnType().toString()));
            columnJson.put(DATASET_COLUMN_VALUES, (JSONValue)this.formatColumnValues(dataColumn, dataColumn.getValues()));
        }
        return columnJson;
    }

    private JSONArray formatColumnValues(DataColumn dataColumn, List values) {
        JSONArray valuesJson = new JSONArray();
        if (values != null) {
            int i = 0;
            block3: for (Object value : values) {
                switch (dataColumn.getColumnType()) {
                    case DATE: {
                        String l = Long.toString(((Date)value).getTime());
                        valuesJson.set(i++, (JSONValue)new JSONString(l));
                        continue block3;
                    }
                }
                valuesJson.set(i++, (JSONValue)new JSONString(value.toString()));
            }
        }
        return valuesJson;
    }

    public DataSet fromJson(String jsonString) {
        if (StringUtils.isBlank((String)jsonString)) {
            return null;
        }
        JSONObject json = JSONParser.parseStrict((String)jsonString).isObject();
        return this.fromJson(json);
    }

    public DataSet fromJson(JSONObject dataSetJson) {
        if (dataSetJson == null) {
            return null;
        }
        DataSet dataSet = DataSetFactory.newEmptyDataSet();
        for (int i = 0; i < dataSetJson.size(); ++i) {
            JSONObject columnJson = dataSetJson.get("column." + Integer.toString(i)).isObject();
            this.parseDataColumn(dataSet, columnJson);
        }
        return dataSet;
    }

    private void parseDataColumn(DataSet dataSet, JSONObject columnJson) {
        if (columnJson != null) {
            JSONString columnId = columnJson.get(DATASET_COLUMN_ID).isString();
            JSONString columnType = columnJson.get(DATASET_COLUMN_TYPE).isString();
            if (columnId == null || columnType == null) {
                throw new RuntimeException(CommonConstants.INSTANCE.json_dataset_column_id_type_not_specified());
            }
            dataSet.addColumn(columnId.stringValue(), ColumnType.valueOf((String)columnType.stringValue()));
            DataColumn dataColumn = dataSet.getColumnById(columnId.stringValue());
            this.parseColumnValues(dataColumn, columnJson);
        }
    }

    private void parseColumnValues(DataColumn dataColumn, JSONObject columnJson) {
        JSONArray valueArray = columnJson.get(DATASET_COLUMN_VALUES).isArray();
        if (valueArray != null) {
            List values = dataColumn.getValues();
            block6: for (int i = 0; i < valueArray.size(); ++i) {
                JSONString stringJson = valueArray.get(i).isString();
                switch (dataColumn.getColumnType()) {
                    case DATE: {
                        values.add(this.parseDateValue(stringJson.stringValue()));
                        continue block6;
                    }
                    case NUMBER: {
                        values.add(this.parseNumberValue(stringJson.stringValue()));
                        continue block6;
                    }
                    case LABEL: {
                        values.add(stringJson.stringValue());
                        continue block6;
                    }
                    case TEXT: {
                        values.add(stringJson.stringValue());
                    }
                }
            }
        }
    }

    private Date parseDateValue(String stringValue) {
        Long dateLong = Long.parseLong(stringValue, 10);
        return new Date(dateLong);
    }

    private Double parseNumberValue(String stringValue) {
        return Double.parseDouble(stringValue);
    }
}

