/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.constants.LabelType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.DataSetLookupEditor;
import org.dashbuilder.displayer.client.widgets.filter.DataSetFilterEditor;
import org.dashbuilder.displayer.client.widgets.group.ColumnFunctionEditor;
import org.dashbuilder.displayer.client.widgets.group.DataSetGroupDateEditor;

@Dependent
public class DataSetLookupEditorView
extends Composite
implements DataSetLookupEditor.View {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    DataSetLookupEditor presenter;
    @UiField
    ListBox dataSetListBox;
    @UiField
    Label statusLabel;
    @UiField
    Panel groupControlPanel;
    @UiField
    com.google.gwt.user.client.ui.Label groupControlLabel;
    @UiField
    Icon groupDetailsIcon;
    @UiField
    ListBox groupColumnListBox;
    @UiField
    Panel groupDatePanel;
    @UiField
    DataSetGroupDateEditor groupDateEditor;
    @UiField
    Panel columnsControlPanel;
    @UiField
    com.google.gwt.user.client.ui.Label columnsControlLabel;
    @UiField
    Panel columnsPanel;
    @UiField
    Button addColumnButton;
    @UiField
    Panel filtersControlPanel;
    @UiField
    DataSetFilterEditor filterEditor;

    public DataSetLookupEditorView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.groupDetailsIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetLookupEditorView.this.expandCollapseGroupDetails();
            }
        }, ClickEvent.getType());
    }

    @Override
    public void init(DataSetLookupEditor presenter) {
        this.presenter = presenter;
        this.filtersControlPanel.setVisible(false);
        this.groupControlPanel.setVisible(false);
        this.columnsControlPanel.setVisible(false);
    }

    @Override
    public void updateDataSetLookup() {
        this._updateFilterControls();
        this._updateGroupControls();
        this._updateColumnControls();
    }

    @Override
    public void addDataSetDef(DataSetDef def) {
        String name = def.getName();
        if (StringUtils.isBlank((String)name)) {
            name = def.getUUID();
        }
        this.dataSetListBox.addItem(name, def.getUUID());
    }

    @Override
    public void removeDataSetDef(DataSetDef def) {
        int target = -1;
        for (int i = 0; i < this.dataSetListBox.getItemCount(); ++i) {
            String uuid = this.dataSetListBox.getValue(i);
            if (!uuid.equals(def.getUUID())) continue;
            target = i;
        }
        if (target != -1) {
            this.dataSetListBox.removeItem(target);
        }
    }

    @Override
    public void showDataSetDefs(List<DataSetDef> dataSetDefs) {
        this.dataSetListBox.clear();
        String selectedUUID = this.presenter.getDataSetUUID();
        int offset = 0;
        if (StringUtils.isBlank((String)selectedUUID)) {
            this.dataSetListBox.addItem(CommonConstants.INSTANCE.common_dropdown_select());
            ++offset;
        }
        boolean found = false;
        for (int i = 0; i < dataSetDefs.size(); ++i) {
            DataSetDef def = dataSetDefs.get(i);
            this.addDataSetDef(def);
            if (selectedUUID == null || !selectedUUID.equals(def.getUUID())) continue;
            this.dataSetListBox.setSelectedIndex(i + offset);
            found = true;
        }
        if (!StringUtils.isBlank((String)selectedUUID) && !found) {
            this.errorDataSetNotFound(selectedUUID);
        }
    }

    @Override
    public void errorDataSetNotFound(String dataSetUUID) {
        this.statusLabel.setVisible(true);
        this.statusLabel.setText(CommonConstants.INSTANCE.dataset_lookup_dataset_notfound(dataSetUUID));
        this.statusLabel.setType(LabelType.WARNING);
    }

    @Override
    public void errorOnInit(Exception e) {
        this.statusLabel.setVisible(true);
        this.statusLabel.setText(CommonConstants.INSTANCE.dataset_lookup_init_error());
        this.statusLabel.setType(LabelType.WARNING);
        GWT.log((String)e.getMessage(), (Throwable)e);
    }

    @UiHandler(value={"dataSetListBox"})
    public void onDataSetSelected(ChangeEvent changeEvent) {
        this.filtersControlPanel.setVisible(false);
        this.groupControlPanel.setVisible(false);
        this.columnsControlPanel.setVisible(false);
        String dataSetUUID = this.dataSetListBox.getValue(this.dataSetListBox.getSelectedIndex());
        this.presenter.changeDataSet(dataSetUUID);
    }

    @UiHandler(value={"addColumnButton"})
    public void onAddColumnClicked(ClickEvent clickEvent) {
        this.presenter.addGroupFunction();
        this._updateColumnControls();
    }

    @UiHandler(value={"groupColumnListBox"})
    public void onRowColumnChanged(ChangeEvent changeEvent) {
        String columnId = this.groupColumnListBox.getValue(this.groupColumnListBox.getSelectedIndex());
        if (CommonConstants.INSTANCE.dataset_lookup_group_columns_all().equals(columnId)) {
            columnId = null;
        }
        this.presenter.changeGroupColumn(columnId);
        this._updateColumnControls();
        this.groupDatePanel.setVisible(false);
        this.groupDetailsIcon.setVisible(false);
        if (this.presenter.isFirstGroupOpDateBased()) {
            this.groupDetailsIcon.setVisible(true);
            this.expandCollapseGroupDetails();
        }
    }

    public void expandCollapseGroupDetails() {
        if (this.groupDatePanel.isVisible()) {
            this.groupDatePanel.setVisible(false);
            this.groupDetailsIcon.setType(IconType.ARROW_DOWN);
        } else {
            this.groupDatePanel.setVisible(true);
            this.groupDetailsIcon.setType(IconType.ARROW_UP);
            ColumnGroup columnGroup = this.presenter.getFirstGroupOp().getColumnGroup();
            this.groupDateEditor.init(columnGroup, this.presenter);
        }
    }

    private void _updateFilterControls() {
        this.filtersControlPanel.setVisible(true);
        this.filterEditor.init(this.presenter.getDataSetMetadata(), this.presenter.getDataSetLookup().getFirstFilterOp(), this.presenter);
    }

    private void _updateGroupControls() {
        DataSetLookupConstraints constraints = this.presenter.getConstraints();
        String groupColumnId = this.presenter.getFirstGroupColumnId();
        List<Integer> groupColumnIdxs = this.presenter.getAvailableGroupColumnIdxs();
        String rowsTitle = constraints.getGroupsTitle();
        this.groupControlPanel.setVisible(false);
        this.groupColumnListBox.clear();
        this.groupDatePanel.setVisible(false);
        this.groupDetailsIcon.setVisible(false);
        if (this.presenter.isFirstGroupOpDateBased()) {
            this.groupDetailsIcon.setVisible(true);
            this.groupDetailsIcon.setType(IconType.ARROW_DOWN);
        }
        if (constraints.isGroupRequired() || constraints.isGroupAllowed()) {
            this.groupControlPanel.setVisible(true);
            if (!StringUtils.isBlank((String)rowsTitle)) {
                this.groupControlLabel.setText(rowsTitle);
            }
            int offset = 0;
            if (!constraints.isGroupRequired()) {
                this.groupColumnListBox.addItem(CommonConstants.INSTANCE.dataset_lookup_group_columns_all());
                ++offset;
            }
            for (int i = 0; i < groupColumnIdxs.size(); ++i) {
                int idx = groupColumnIdxs.get(i);
                String columnId = this.presenter.getColumnId(idx);
                this.groupColumnListBox.addItem(columnId, columnId);
                if (groupColumnId == null || !groupColumnId.equals(columnId)) continue;
                this.groupColumnListBox.setSelectedIndex(i + offset);
            }
            if (constraints.isGroupRequired() && groupColumnId == null) {
                groupColumnId = this.presenter.getColumnId(groupColumnIdxs.get(0));
                this.presenter.createGroupColumn(groupColumnId);
            }
        }
    }

    private void _updateColumnControls() {
        DataSetLookupConstraints constraints = this.presenter.getConstraints();
        String groupColumnId = this.presenter.getFirstGroupColumnId();
        List<GroupFunction> groupFunctions = this.presenter.getFirstGroupFunctions();
        String columnsTitle = constraints.getColumnsTitle();
        boolean functionsRequired = constraints.isFunctionRequired();
        boolean functionsEnabled = groupColumnId != null || functionsRequired;
        boolean canDelete = groupFunctions.size() > constraints.getMinColumns();
        int n = constraints.getMaxColumns();
        boolean canAdd = constraints.areExtraColumnsAllowed() && (n < 0 || groupFunctions.size() < n);
        this.columnsPanel.clear();
        this.columnsControlPanel.setVisible(true);
        if (!StringUtils.isBlank((String)columnsTitle)) {
            this.columnsControlLabel.setText(columnsTitle);
        }
        this.addColumnButton.setVisible(canAdd);
        ColumnType lastTargetType = null;
        ColumnType[] targetTypes = constraints.getColumnTypes(groupFunctions.size());
        for (int i = 0; i < groupFunctions.size(); ++i) {
            final int columnIdx = i;
            final GroupFunction groupFunction = groupFunctions.get(columnIdx);
            if (targetTypes != null && i < targetTypes.length) {
                lastTargetType = targetTypes[i];
            }
            if (columnIdx == 0 && groupColumnId != null && constraints.isGroupColumn()) continue;
            ColumnType columnType = null;
            if (targetTypes != null && i < targetTypes.length) {
                columnType = targetTypes[columnIdx];
            }
            if (columnType == null) {
                columnType = lastTargetType;
            }
            String columnTitle = constraints.getColumnTitle(Integer.valueOf(columnIdx));
            ColumnFunctionEditor columnEditor = new ColumnFunctionEditor();
            columnEditor.init(this.presenter.getDataSetMetadata(), groupFunction, columnType, columnTitle, functionsEnabled, canDelete, new ColumnFunctionEditor.Listener(){

                @Override
                public void columnChanged(ColumnFunctionEditor editor) {
                    DataSetLookupEditorView.this.presenter.changeGroupFunction(groupFunction, editor.getSourceId(), editor.getFunction());
                    DataSetLookupEditorView.this._updateColumnControls();
                }

                @Override
                public void columnDeleted(ColumnFunctionEditor editor) {
                    DataSetLookupEditorView.this.presenter.removeGroupFunction(columnIdx);
                    DataSetLookupEditorView.this._updateColumnControls();
                }
            });
            this.columnsPanel.add((Widget)columnEditor);
        }
    }

    static interface Binder
    extends UiBinder<Widget, DataSetLookupEditorView> {
    }
}

