/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.github.gwtbootstrap.client.ui.event.ShownEvent;
import com.github.gwtbootstrap.client.ui.event.ShownHandler;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.DisplayerEditor;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;

@Dependent
public class DisplayerEditorPopup
extends BaseModal {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField(provided=true)
    DisplayerEditor editor;
    private DisplayerSettings settings;
    private DisplayerEditor.Listener editorListener;
    private HandlerRegistration showHandlerRegistration;
    private final ShownHandler shownHandler = new ShownHandler(){

        public void onShown(ShownEvent shownEvent) {
            DisplayerEditorPopup.this.editor.init(DisplayerEditorPopup.this.settings, DisplayerEditorPopup.this.editorListener);
            DisplayerEditorPopup.this.setTitle(CommonConstants.INSTANCE.displayer_editor_title());
            if (DisplayerEditorPopup.this.editor.isBrandNewDisplayer()) {
                DisplayerEditorPopup.this.setTitle(CommonConstants.INSTANCE.displayer_editor_new());
            }
            DisplayerEditorPopup.this.removeShownHandler();
        }
    };

    @Inject
    public DisplayerEditorPopup(DisplayerEditor editor) {
        this.editor = editor;
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.setMaxHeigth("550px");
        this.setWidth(950);
    }

    public void init(DisplayerSettings settings, DisplayerEditor.Listener editorListener) {
        this.settings = settings;
        this.editorListener = editorListener;
        this.show();
        this.showHandlerRegistration = this.addShownHandler(this.shownHandler);
    }

    @UiHandler(value={"cancelButton"})
    void cancel(ClickEvent event) {
        this.hide();
        this.editor.close();
        this.clearSettings();
    }

    @UiHandler(value={"okButton"})
    void ok(ClickEvent event) {
        this.hide();
        this.editor.save();
        this.clearSettings();
    }

    private void removeShownHandler() {
        if (this.showHandlerRegistration != null) {
            this.showHandlerRegistration.removeHandler();
            this.showHandlerRegistration = null;
        }
    }

    private void clearSettings() {
        this.settings = null;
        this.editorListener = null;
        this.removeShownHandler();
    }

    static interface Binder
    extends UiBinder<Widget, DisplayerEditorPopup> {
    }
}

