/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.constants.VisibilityChange;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.DataSetLookupEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerEditorStatus;
import org.dashbuilder.displayer.client.widgets.DisplayerError;
import org.dashbuilder.displayer.client.widgets.DisplayerSettingsEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerTypeSelector;

@Dependent
public class DisplayerEditorView
extends Composite
implements DisplayerEditor.View {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    protected DisplayerEditor presenter;
    protected DisplayerSettings settings;
    protected DisplayerTypeSelector typeSelector;
    protected DataSetLookupEditor lookupEditor;
    protected DisplayerSettingsEditor settingsEditor;
    protected Displayer displayer;
    protected DisplayerError errorWidget = new DisplayerError();
    DisplayerListener displayerListener = new AbstractDisplayerListener(){

        @Override
        public void onError(Displayer displayer, ClientRuntimeError error) {
            DisplayerEditorView.this.error(error);
        }
    };
    @UiField
    public Panel leftPanel;
    @UiField
    public Panel centerPanel;
    @UiField
    public TabPanel optionsPanel;
    @UiField
    public Tab optionType;
    @UiField
    public Tab optionData;
    @UiField
    public Tab optionSettings;
    @UiField
    public Panel dataTablePanel;
    @UiField
    public CheckBox viewAsTable;

    @Inject
    public DisplayerEditorView(DisplayerTypeSelector typeSelector, DataSetLookupEditor lookupEditor, DisplayerSettingsEditor settingsEditor) {
        this.typeSelector = typeSelector;
        this.lookupEditor = lookupEditor;
        this.settingsEditor = settingsEditor;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.dataTablePanel.getElement().setAttribute("cellpadding", "5");
    }

    @Override
    public void init(DisplayerSettings settings, DisplayerEditor presenter) {
        this.settings = settings;
        this.presenter = presenter;
        this.showDisplayer();
        this.gotoLastTab();
    }

    @Override
    public void disableTypeSelection() {
        this.optionType.addStyle((Style)VisibilityChange.HIDE);
    }

    public void gotoLastTab() {
        int selectedTab = this.optionsPanel.getSelectedTab();
        int lastTab = DisplayerEditorStatus.get().getSelectedTab(this.settings.getUUID());
        if (selectedTab < 0 || selectedTab != lastTab) {
            switch (lastTab) {
                case 2: {
                    this.gotoDisplaySettings();
                    break;
                }
                case 1: {
                    this.gotoDataSetConf();
                    break;
                }
                default: {
                    this.gotoTypeSelection();
                }
            }
        }
    }

    private void saveLastTab(int tab) {
        DisplayerEditorStatus.get().saveSelectedTab(this.settings.getUUID(), tab);
    }

    @Override
    public void gotoTypeSelection() {
        this.optionsPanel.selectTab(0);
        this.saveLastTab(0);
        this.typeSelector.init(this.presenter);
        this.typeSelector.select(this.settings.getRenderer(), this.settings.getType(), this.settings.getSubtype());
        this.leftPanel.clear();
        this.leftPanel.add((Widget)this.typeSelector);
        this.dataTablePanel.setVisible(false);
        this.showDisplayer();
    }

    @Override
    public void gotoDataSetConf() {
        this.optionsPanel.selectTab(1);
        this.saveLastTab(1);
        if (this.settings.getDataSet() == null && this.settings.getDataSetLookup() != null) {
            this.presenter.fetchDataSetLookup();
        } else {
            this.lookupEditor.init(this.presenter);
        }
        this.leftPanel.clear();
        this.leftPanel.add((IsWidget)this.lookupEditor);
        if (DisplayerType.TABLE.equals((Object)this.settings.getType())) {
            this.dataTablePanel.setVisible(false);
        } else {
            this.dataTablePanel.setVisible(true);
        }
        this.showDisplayer();
    }

    @Override
    public void showTypeChangedWarning(DisplayerSettings oldSettings, DisplayerSettings newSettings) {
        if (Window.confirm((String)CommonConstants.INSTANCE.displayer_editor_incompatible_settings())) {
            this.presenter.changeSettings(oldSettings, newSettings);
        } else {
            this.typeSelector.select(oldSettings.getRenderer(), oldSettings.getType(), oldSettings.getSubtype());
        }
    }

    @Override
    public void updateDataSetLookup(DataSetLookupConstraints constraints, DataSetMetadata metadata) {
        DataSetLookup dataSetLookup = this.settings.getDataSetLookup();
        this.lookupEditor.init(this.presenter, dataSetLookup, constraints, metadata);
        this.showDisplayer();
    }

    @Override
    public void gotoDisplaySettings() {
        this.optionsPanel.selectTab(2);
        this.saveLastTab(2);
        this.optionSettings.setActive(true);
        this.settingsEditor.init(this.settings, this.presenter);
        this.leftPanel.clear();
        this.leftPanel.add((Widget)this.settingsEditor);
        this.dataTablePanel.setVisible(false);
        this.showDisplayer();
    }

    @Override
    public void error(String error) {
        this.centerPanel.clear();
        this.centerPanel.add((Widget)this.errorWidget);
        this.errorWidget.show(error, null);
        GWT.log((String)error);
    }

    @Override
    public void error(ClientRuntimeError e) {
        this.centerPanel.clear();
        this.centerPanel.add((Widget)this.errorWidget);
        this.errorWidget.show(e.getMessage(), e.getCause());
        if (e.getThrowable() != null) {
            GWT.log((String)e.getMessage(), (Throwable)e.getThrowable());
        } else {
            GWT.log((String)e.getMessage());
        }
    }

    @Override
    public void close() {
        if (this.displayer != null) {
            this.displayer.close();
        }
    }

    public void showDisplayer() {
        if (this.displayer != null) {
            this.displayer.close();
        }
        try {
            if (this.dataTablePanel.isVisible() && this.viewAsTable.getValue().booleanValue()) {
                DisplayerSettings tableSettings = this.settings.cloneInstance();
                tableSettings.setTitleVisible(false);
                tableSettings.setType(DisplayerType.TABLE);
                tableSettings.setTablePageSize(8);
                tableSettings.setTableWidth(-1);
                this.displayer = DisplayerLocator.get().lookupDisplayer(tableSettings);
                this.displayer.addListener(this.displayerListener);
                this.displayer.setRefreshOn(false);
                this.centerPanel.clear();
                this.centerPanel.add((IsWidget)this.displayer);
                this.displayer.draw();
            } else {
                this.displayer = DisplayerLocator.get().lookupDisplayer(this.settings);
                this.displayer.addListener(this.displayerListener);
                this.displayer.setRefreshOn(false);
                this.centerPanel.clear();
                this.centerPanel.add((IsWidget)this.displayer);
                this.displayer.draw();
            }
        }
        catch (Exception e) {
            this.error(new ClientRuntimeError((Throwable)e));
        }
    }

    @UiHandler(value={"optionType"})
    public void onTypeSelected(ClickEvent clickEvent) {
        this.gotoTypeSelection();
    }

    @UiHandler(value={"optionData"})
    public void onDataSelected(ClickEvent clickEvent) {
        this.gotoDataSetConf();
    }

    @UiHandler(value={"optionSettings"})
    public void onSettingsSelected(ClickEvent clickEvent) {
        this.gotoDisplaySettings();
    }

    @UiHandler(value={"viewAsTable"})
    public void onRawTableChecked(ClickEvent clickEvent) {
        this.showDisplayer();
    }

    static interface Binder
    extends UiBinder<Widget, DisplayerEditorView> {
    }
}

