/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.github.gwtbootstrap.client.ui.ListBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.dataset.client.resources.i18n.MonthConstants;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.date.TimeFrame;
import org.dashbuilder.dataset.date.TimeInstant;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.displayer.client.widgets.filter.TimeInstantEditor;

@Dependent
public class TimeFrameEditor
extends Composite {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    Listener listener = null;
    TimeFrame timeFrame = null;
    @UiField
    TimeInstantEditor fromEditor;
    @UiField
    TimeInstantEditor toEditor;
    @UiField
    Label firstMonthLabel;
    @UiField
    ListBox firstMonthList;

    public TimeFrameEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void init(TimeFrame frame, final Listener listener) {
        this.listener = listener;
        this.timeFrame = frame;
        if (this.timeFrame == null) {
            this.timeFrame = TimeFrame.parse((String)"begin[year] till end[year]");
        }
        this.initFirstMonthListBox();
        this.changeFirstMonthVisibility();
        TimeInstant instantFrom = this.timeFrame.getFrom();
        this.fromEditor.init(instantFrom.cloneInstance(), true, new TimeInstantEditor.Listener(){

            @Override
            public void valueChanged(TimeInstant timeInstant) {
                TimeFrameEditor.this.timeFrame.setFrom(timeInstant);
                TimeFrameEditor.this.timeFrame.setFrom(timeInstant);
                timeInstant.setFirstMonthOfYear(TimeFrameEditor.this.getFirstMonthOfYear());
                TimeFrameEditor.this.changeFirstMonthVisibility();
                listener.valueChanged(TimeFrameEditor.this.timeFrame);
            }
        });
        TimeInstant instantTo = this.timeFrame.getTo();
        this.toEditor.init(instantTo.cloneInstance(), true, new TimeInstantEditor.Listener(){

            @Override
            public void valueChanged(TimeInstant timeInstant) {
                TimeFrameEditor.this.timeFrame.setTo(timeInstant);
                timeInstant.setFirstMonthOfYear(TimeFrameEditor.this.getFirstMonthOfYear());
                TimeFrameEditor.this.changeFirstMonthVisibility();
                listener.valueChanged(TimeFrameEditor.this.timeFrame);
            }
        });
    }

    protected void changeFirstMonthVisibility() {
        this.firstMonthLabel.setVisible(false);
        this.firstMonthList.setVisible(false);
        if (this.isFirstMonthVisible()) {
            this.firstMonthLabel.setVisible(true);
            this.firstMonthList.setVisible(true);
        }
    }

    protected boolean isFirstMonthVisible() {
        DateIntervalType intervalType;
        DateIntervalType intervalType2;
        TimeInstant instantFrom = this.timeFrame.getFrom();
        TimeInstant.TimeMode modeFrom = instantFrom.getTimeMode();
        if (modeFrom != null && !modeFrom.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType2 = instantFrom.getIntervalType()) != null && intervalType2.getIndex() > DateIntervalType.MONTH.getIndex()) {
            return true;
        }
        TimeInstant instantTo = this.timeFrame.getTo();
        TimeInstant.TimeMode modeTo = instantTo.getTimeMode();
        return modeTo != null && !modeTo.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType = instantTo.getIntervalType()) != null && intervalType.getIndex() > DateIntervalType.MONTH.getIndex();
    }

    protected Month getFirstMonthOfYear() {
        DateIntervalType intervalType;
        DateIntervalType intervalType2;
        TimeInstant instantFrom = this.timeFrame.getFrom();
        TimeInstant.TimeMode modeFrom = instantFrom.getTimeMode();
        if (modeFrom != null && !modeFrom.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType2 = instantFrom.getIntervalType()) != null && intervalType2.getIndex() > DateIntervalType.MONTH.getIndex()) {
            return instantFrom.getFirstMonthOfYear();
        }
        TimeInstant instantTo = this.timeFrame.getTo();
        TimeInstant.TimeMode modeTo = instantTo.getTimeMode();
        if (modeTo != null && !modeTo.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType = instantTo.getIntervalType()) != null && intervalType.getIndex() > DateIntervalType.MONTH.getIndex()) {
            return instantTo.getFirstMonthOfYear();
        }
        return null;
    }

    protected void setFirstMonthOfYear(Month month) {
        DateIntervalType intervalType;
        TimeInstant instantTo;
        TimeInstant.TimeMode modeTo;
        DateIntervalType intervalType2;
        TimeInstant instantFrom = this.timeFrame.getFrom();
        TimeInstant.TimeMode modeFrom = instantFrom.getTimeMode();
        if (modeFrom != null && !modeFrom.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType2 = instantFrom.getIntervalType()) != null && intervalType2.getIndex() > DateIntervalType.MONTH.getIndex()) {
            instantFrom.setFirstMonthOfYear(month);
        }
        if ((modeTo = (instantTo = this.timeFrame.getTo()).getTimeMode()) != null && !modeTo.equals((Object)TimeInstant.TimeMode.NOW) && (intervalType = instantTo.getIntervalType()) != null && intervalType.getIndex() > DateIntervalType.MONTH.getIndex()) {
            instantTo.setFirstMonthOfYear(month);
        }
    }

    protected void initFirstMonthListBox() {
        this.firstMonthList.clear();
        Month current = this.getFirstMonthOfYear();
        Month[] entries = Month.values();
        for (int i = 0; i < entries.length; ++i) {
            Month entry = entries[i];
            this.firstMonthList.addItem(MonthConstants.INSTANCE.getString(entry.name()));
            if (current == null || !current.equals((Object)entry)) continue;
            this.firstMonthList.setSelectedIndex(i);
        }
    }

    @UiHandler(value={"firstMonthList"})
    public void onFirstMonthSelected(ChangeEvent changeEvent) {
        int selectedIdx = this.firstMonthList.getSelectedIndex();
        Month month = Month.getByIndex((int)(selectedIdx + 1));
        this.setFirstMonthOfYear(month);
        this.listener.valueChanged(this.timeFrame);
    }

    static interface Binder
    extends UiBinder<Widget, TimeFrameEditor> {
    }

    static interface Listener {
        public void valueChanged(TimeFrame var1);
    }
}

