/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.displayer.client.events.ColumnFilterChangedEvent;
import org.dashbuilder.displayer.client.events.ColumnFilterDeletedEvent;
import org.dashbuilder.displayer.client.events.DataSetFilterChangedEvent;
import org.dashbuilder.displayer.client.widgets.filter.ColumnFilterEditor;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DataSetFilterEditor
implements IsWidget {
    View view = null;
    DataSetFilter filter = null;
    DataSetMetadata metadata = null;
    SyncBeanManager beanManager;
    Event<DataSetFilterChangedEvent> changeEvent;
    Map<Integer, ColumnFilterEditor> _editorsMap = new HashMap<Integer, ColumnFilterEditor>();

    @Inject
    public DataSetFilterEditor(View view, SyncBeanManager beanManager, Event<DataSetFilterChangedEvent> changeEvent) {
        this.view = view;
        this.beanManager = beanManager;
        this.changeEvent = changeEvent;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public DataSetFilter getFilter() {
        return this.filter;
    }

    public void init(DataSetFilter filter, DataSetMetadata metadata) {
        this.filter = filter;
        this.metadata = metadata;
        this.view.showNewFilterHome();
        this.view.clearColumnSelector();
        if (metadata != null) {
            for (int i = 0; i < metadata.getNumberOfColumns(); ++i) {
                this.view.addColumn(metadata.getColumnId(i));
            }
        }
        this.view.clearColumnFilterEditors();
        this._editorsMap.clear();
        if (filter != null) {
            for (ColumnFilter columnFilter : filter.getColumnFilterList()) {
                ColumnFilterEditor columnFilterEditor = (ColumnFilterEditor)this.beanManager.lookupBean(ColumnFilterEditor.class, new Annotation[0]).newInstance();
                columnFilterEditor.init(metadata, columnFilter);
                this.view.addColumnFilterEditor(columnFilterEditor);
                this._editorsMap.put(this._editorsMap.size(), columnFilterEditor);
            }
        }
    }

    public void onNewFilterStart() {
        this.view.showColumnSelector();
    }

    public void onNewFilterCancel() {
        this.view.showNewFilterHome();
    }

    public void onCreateFilter() {
        ColumnType columnType;
        int selectedIdx = this.view.getSelectedColumnIndex();
        String columnId = this.metadata.getColumnId(selectedIdx);
        CoreFunctionFilter columnFilter = FilterFactory.createCoreFunctionFilter((String)columnId, (ColumnType)columnType, (CoreFunctionType)(ColumnType.DATE.equals((Object)(columnType = this.metadata.getColumnType(selectedIdx))) ? CoreFunctionType.TIME_FRAME : CoreFunctionType.NOT_EQUALS_TO));
        if (this.filter == null) {
            this.filter = new DataSetFilter();
        }
        this.filter.addFilterColumn(new ColumnFilter[]{columnFilter});
        ColumnFilterEditor columnFilterEditor = (ColumnFilterEditor)this.beanManager.lookupBean(ColumnFilterEditor.class, new Annotation[0]).newInstance();
        columnFilterEditor.init(this.metadata, (ColumnFilter)columnFilter);
        columnFilterEditor.expand();
        this._editorsMap.put(this._editorsMap.size(), columnFilterEditor);
        this.view.addColumnFilterEditor(columnFilterEditor);
        this.view.resetSelectedColumn();
        this.view.showNewFilterHome();
        this.changeEvent.fire((Object)new DataSetFilterChangedEvent(this.filter));
    }

    protected void onColumnFilterChanged(@Observes ColumnFilterChangedEvent event) {
        this.changeEvent.fire((Object)new DataSetFilterChangedEvent(this.filter));
    }

    protected void onColumnFilterDeleted(@Observes ColumnFilterDeletedEvent event) {
        Integer index = this.filter.getColumnFilterIdx(event.getColumnFilter());
        if (index != null && index >= 0) {
            this.filter.getColumnFilterList().remove(index);
            ColumnFilterEditor editor = this._editorsMap.remove(index);
            this.view.removeColumnFilterEditor(editor);
            this.view.showNewFilterHome();
            this.beanManager.destroyBean((Object)editor);
            this.changeEvent.fire((Object)new DataSetFilterChangedEvent(this.filter));
        }
    }

    public static interface View
    extends UberView<DataSetFilterEditor> {
        public void showNewFilterHome();

        public void clearColumnSelector();

        public void showColumnSelector();

        public void addColumn(String var1);

        public int getSelectedColumnIndex();

        public void resetSelectedColumn();

        public void clearColumnFilterEditors();

        public void addColumnFilterEditor(ColumnFilterEditor var1);

        public void removeColumnFilterEditor(ColumnFilterEditor var1);
    }
}

