/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.group;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.dataset.client.resources.i18n.AggregateFunctionTypeConstants;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.displayer.client.widgets.group.ColumnDetailsEditor;
import org.dashbuilder.displayer.client.widgets.group.ColumnFunctionEditor;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.constants.IconType;

@Dependent
public class ColumnFunctionEditorView
extends Composite
implements ColumnFunctionEditor.View {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    ListBox columnListBox;
    @UiField
    ListBox functionListBox;
    @UiField
    Icon columnDeleteIcon;
    @UiField
    Icon columnExpandIcon;
    @UiField
    Panel columnDetailsPanel;
    @UiField(provided=true)
    ColumnDetailsEditor columnDetailsEditor;
    ColumnFunctionEditor presenter = null;
    boolean voidFunctionEnabled = false;

    public void init(final ColumnFunctionEditor presenter) {
        this.presenter = presenter;
        this.columnDetailsEditor = presenter.getColumnDetailsEditor();
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.columnExpandIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ColumnFunctionEditorView.this.expandOrCollapse();
            }
        }, ClickEvent.getType());
        this.columnDeleteIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                presenter.delete();
            }
        }, ClickEvent.getType());
    }

    @Override
    public void setDeleteOptionEnabled(boolean enabled) {
        this.columnDeleteIcon.setVisible(enabled);
    }

    @Override
    public void setColumnSelectorTitle(String title) {
        this.columnListBox.setTitle(title);
    }

    @Override
    public void clearColumnSelector() {
        this.columnListBox.clear();
    }

    @Override
    public void addColumnItem(String columnId) {
        this.columnListBox.addItem(columnId);
    }

    @Override
    public void setSelectedColumnIndex(int i) {
        this.columnListBox.setSelectedIndex(i);
    }

    @Override
    public String getSelectedColumnId() {
        return this.columnListBox.getValue(this.columnListBox.getSelectedIndex());
    }

    @Override
    public void setFunctionSelectorEnabled(boolean enabled) {
        if (enabled) {
            this.functionListBox.setVisible(true);
            this.columnListBox.setWidth("120px");
        } else {
            this.functionListBox.setVisible(false);
            this.columnListBox.setWidth("200px");
        }
    }

    @Override
    public void clearFunctionSelector() {
        this.functionListBox.clear();
    }

    @Override
    public void setVoidFunctionEnabled(boolean enabled) {
        this.voidFunctionEnabled = enabled;
        if (enabled) {
            this.functionListBox.addItem("---");
        }
    }

    @Override
    public void addFunctionItem(AggregateFunctionType functionType) {
        String functionName = AggregateFunctionTypeConstants.INSTANCE.getString(functionType.name());
        this.functionListBox.addItem(functionName);
    }

    @Override
    public void setSelectedFunctionIndex(int i) {
        this.functionListBox.setSelectedIndex(this.voidFunctionEnabled ? i + 1 : i);
    }

    @Override
    public int getSelectedFunctionIndex() {
        int i = this.functionListBox.getSelectedIndex();
        return this.voidFunctionEnabled ? i - 1 : i;
    }

    protected void expandOrCollapse() {
        if (this.columnDetailsPanel.isVisible()) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    protected void expand() {
        this.columnDetailsPanel.setVisible(true);
        this.columnExpandIcon.setType(IconType.ARROW_UP);
    }

    protected void collapse() {
        this.columnDetailsPanel.setVisible(false);
        this.columnExpandIcon.setType(IconType.ARROW_DOWN);
    }

    @UiHandler(value={"columnListBox"})
    protected void onColumnSelected(ChangeEvent changeEvent) {
        this.presenter.onColumnSelected();
    }

    @UiHandler(value={"functionListBox"})
    protected void onFunctionSelected(ChangeEvent changeEvent) {
        this.presenter.onFunctionSelected();
    }

    static interface Binder
    extends UiBinder<Widget, ColumnFunctionEditorView> {
    }
}

