/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.client.resources.i18n.DayOfWeekConstants;
import org.dashbuilder.dataset.client.resources.i18n.MonthConstants;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.displayer.client.AbstractDisplayer;

public class DisplayerGwtFormatter
implements AbstractDisplayer.Formatter {
    protected static Map<String, NumberFormat> numberPatternMap = new HashMap<String, NumberFormat>();
    protected static Map<String, DateTimeFormat> datePatternMap = new HashMap<String, DateTimeFormat>();

    @Override
    public Date parseDate(String pattern, String d) {
        DateTimeFormat df = this.getDateFormat(pattern);
        return df.parse(d);
    }

    @Override
    public String formatDate(String pattern, Date d) {
        DateTimeFormat df = this.getDateFormat(pattern);
        return df.format(d);
    }

    @Override
    public String formatNumber(String pattern, Number n) {
        NumberFormat f = this.getNumberFormat(pattern);
        return f.format(n);
    }

    @Override
    public String formatDayOfWeek(DayOfWeek dayOfWeek) {
        return DayOfWeekConstants.INSTANCE.getString(dayOfWeek.name());
    }

    @Override
    public String formatMonth(Month month) {
        return MonthConstants.INSTANCE.getString(month.name());
    }

    protected NumberFormat getNumberFormat(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return this.getNumberFormat("#,##0.00");
        }
        NumberFormat format = numberPatternMap.get(pattern);
        if (format == null) {
            format = NumberFormat.getFormat((String)pattern);
            numberPatternMap.put(pattern, format);
        }
        return format;
    }

    protected DateTimeFormat getDateFormat(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return this.getDateFormat("MMM dd, yyyy HH:mm");
        }
        DateTimeFormat format = datePatternMap.get(pattern);
        if (format == null) {
            format = DateTimeFormat.getFormat((String)pattern);
            datePatternMap.put(pattern, format);
        }
        return format;
    }
}

