/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.date.TimeFrame;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.displayer.client.events.ColumnFilterChangedEvent;
import org.dashbuilder.displayer.client.events.ColumnFilterDeletedEvent;
import org.dashbuilder.displayer.client.widgets.filter.DateParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.FunctionParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.LikeToFunctionEditor;
import org.dashbuilder.displayer.client.widgets.filter.MultipleNumberParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.MultipleTextParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.NumberParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.TextParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.TimeFrameEditor;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

@Dependent
public class ColumnFilterEditor
implements IsWidget {
    View view = null;
    SyncBeanManager beanManager = null;
    ColumnFilter filter = null;
    DataSetMetadata metadata = null;
    Event<ColumnFilterChangedEvent> changedEvent = null;
    Event<ColumnFilterDeletedEvent> deletedEvent = null;

    @Inject
    public ColumnFilterEditor(View view, SyncBeanManager beanManager, Event<ColumnFilterChangedEvent> changedEvent, Event<ColumnFilterDeletedEvent> deletedEvent) {
        this.view = view;
        this.beanManager = beanManager;
        this.changedEvent = changedEvent;
        this.deletedEvent = deletedEvent;
        this.view.init(this);
    }

    public void init(DataSetMetadata metadata, ColumnFilter filter) {
        this.filter = filter;
        this.metadata = metadata;
        this.initFilterSelector();
        this.initFilterConfig();
    }

    public ColumnFilter getFilter() {
        return this.filter;
    }

    public View getView() {
        return this.view;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void expand() {
        this.view.showFilterConfig();
    }

    public void onSelectFilterFunction() {
        int selectedIdx = this.view.getSelectedFunctionIndex();
        if (selectedIdx >= 0) {
            CoreFunctionFilter coreFilter = this.getCoreFilter();
            CoreFunctionType functionType = this.getAvailableFunctions(coreFilter).get(selectedIdx);
            ColumnType columnType = this.metadata.getColumnType(coreFilter.getColumnId());
            List params = FilterFactory.createParameters((ColumnType)columnType, (CoreFunctionType)functionType);
            coreFilter.setType(functionType);
            coreFilter.setParameters(params);
            this.initFilterSelector();
            this.fireFilterChanged();
            if (!this.initFilterConfig().isEmpty()) {
                this.view.showFilterConfig();
            }
        }
    }

    public void onDeleteFilter() {
        this.deletedEvent.fire((Object)new ColumnFilterDeletedEvent(this));
    }

    protected CoreFunctionFilter getCoreFilter() {
        try {
            return (CoreFunctionFilter)this.filter;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected List<FunctionParameterEditor> createFilterInputControls() {
        ArrayList<FunctionParameterEditor> filterInputControls = new ArrayList<FunctionParameterEditor>();
        CoreFunctionFilter coreFilter = this.getCoreFilter();
        if (CoreFunctionType.LIKE_TO.equals((Object)coreFilter.getType())) {
            FunctionParameterEditor paramInput = this.createLikeToFunctionWidget(coreFilter);
            filterInputControls.add(paramInput);
        } else {
            for (int i = 0; i < coreFilter.getType().getParametersCount(); ++i) {
                FunctionParameterEditor paramInput = this.createParamInputWidget(coreFilter, i);
                filterInputControls.add(paramInput);
            }
        }
        return filterInputControls;
    }

    protected void initFilterSelector() {
        CoreFunctionFilter coreFilter = this.getCoreFilter();
        if (coreFilter != null) {
            this.view.clearFunctionSelector();
            String currentFunction = this.formatFilterFunction(coreFilter);
            this.view.setFunctionSelected(currentFunction);
            List<CoreFunctionType> calculateAvailableFunctions = this.getAvailableFunctions(coreFilter);
            for (CoreFunctionType functionType : calculateAvailableFunctions) {
                this.view.addFunctionItem(functionType);
            }
        }
    }

    protected List<CoreFunctionType> getAvailableFunctions(CoreFunctionFilter coreFilter) {
        ColumnType columnType = this.metadata.getColumnType(coreFilter.getColumnId());
        List functionTypes = CoreFunctionType.getSupportedTypes((ColumnType)columnType);
        Iterator it = functionTypes.iterator();
        while (it.hasNext()) {
            CoreFunctionType next = (CoreFunctionType)it.next();
            if (!next.equals((Object)coreFilter.getType())) continue;
            it.remove();
        }
        return functionTypes;
    }

    protected List<FunctionParameterEditor> initFilterConfig() {
        this.view.clearFilterConfig();
        List<FunctionParameterEditor> inputs = this.createFilterInputControls();
        if (!inputs.isEmpty()) {
            for (IsWidget isWidget : inputs) {
                this.view.addFilterConfigWidget(isWidget);
            }
            inputs.get(0).setFocus(true);
        }
        return inputs;
    }

    protected void updateSelectedFilter() {
        String currentFunction = this.formatFilterFunction(this.getCoreFilter());
        this.view.setFunctionSelected(currentFunction);
        this.fireFilterChanged();
    }

    protected void fireFilterChanged() {
        this.changedEvent.fire((Object)new ColumnFilterChangedEvent(this));
    }

    protected FunctionParameterEditor createParamInputWidget(CoreFunctionFilter coreFilter, int paramIndex) {
        boolean isMultiple;
        List paramList = coreFilter.getParameters();
        ColumnType columnType = this.metadata.getColumnType(coreFilter.getColumnId());
        CoreFunctionType functionType = coreFilter.getType();
        boolean bl = isMultiple = CoreFunctionType.IN.equals((Object)functionType) || CoreFunctionType.NOT_IN.equals((Object)functionType);
        if (ColumnType.DATE.equals((Object)columnType)) {
            if (CoreFunctionType.TIME_FRAME.equals((Object)coreFilter.getType())) {
                return this.createTimeFrameWidget(paramList, paramIndex);
            }
            return this.createDateInputWidget(paramList, paramIndex);
        }
        if (!isMultiple) {
            if (ColumnType.NUMBER.equals((Object)columnType)) {
                return this.createNumberInputWidget(paramList, paramIndex);
            }
            return this.createTextInputWidget(paramList, paramIndex);
        }
        if (ColumnType.NUMBER.equals((Object)columnType)) {
            return this.createMultipleNumberInputWidget(paramList);
        }
        return this.createMultipleTextInputWidget(paramList);
    }

    protected FunctionParameterEditor createDateInputWidget(final List paramList, final int paramIndex) {
        Date param = (Date)paramList.get(paramIndex);
        final DateParameterEditor input = (DateParameterEditor)this.beanManager.lookupBean(DateParameterEditor.class, new Annotation[0]).newInstance();
        input.setCurrentValue(param);
        input.setOnChangeCommand(new Command(){

            public void execute() {
                paramList.set(paramIndex, input.getCurrentValue());
                ColumnFilterEditor.this.updateSelectedFilter();
            }
        });
        return input;
    }

    protected FunctionParameterEditor createNumberInputWidget(final List paramList, final int paramIndex) {
        final NumberParameterEditor input = (NumberParameterEditor)this.beanManager.lookupBean(NumberParameterEditor.class, new Annotation[0]).newInstance();
        input.setValue(Double.parseDouble(paramList.get(paramIndex).toString()));
        input.setOnChangeCommand(new Command(){

            public void execute() {
                paramList.set(paramIndex, input.getValue());
                ColumnFilterEditor.this.updateSelectedFilter();
            }
        });
        return input;
    }

    protected FunctionParameterEditor createTextInputWidget(final List paramList, final int paramIndex) {
        final TextParameterEditor input = (TextParameterEditor)this.beanManager.lookupBean(TextParameterEditor.class, new Annotation[0]).newInstance();
        input.setValue((String)paramList.get(paramIndex));
        input.setOnChangeCommand(new Command(){

            public void execute() {
                paramList.set(paramIndex, input.getValue());
                ColumnFilterEditor.this.updateSelectedFilter();
            }
        });
        return input;
    }

    protected FunctionParameterEditor createMultipleNumberInputWidget(List paramList) {
        MultipleNumberParameterEditor input = (MultipleNumberParameterEditor)this.beanManager.lookupBean(MultipleNumberParameterEditor.class, new Annotation[0]).newInstance();
        input.setValues(paramList);
        input.setOnChangeCommand(new Command(){

            public void execute() {
                ColumnFilterEditor.this.updateSelectedFilter();
            }
        });
        return input;
    }

    protected FunctionParameterEditor createMultipleTextInputWidget(List paramList) {
        MultipleTextParameterEditor input = (MultipleTextParameterEditor)this.beanManager.lookupBean(MultipleTextParameterEditor.class, new Annotation[0]).newInstance();
        input.setValues(paramList);
        input.setOnChangeCommand(new Command(){

            public void execute() {
                ColumnFilterEditor.this.updateSelectedFilter();
            }
        });
        return input;
    }

    protected FunctionParameterEditor createTimeFrameWidget(final List paramList, final int paramIndex) {
        TimeFrame timeFrame = TimeFrame.parse((String)((String)paramList.get(paramIndex)));
        final TimeFrameEditor input = (TimeFrameEditor)this.beanManager.lookupBean(TimeFrameEditor.class, new Annotation[0]).newInstance();
        input.init(timeFrame, new Command(){

            public void execute() {
                paramList.set(paramIndex, input.getTimeFrame().toString());
                ColumnFilterEditor.this.updateSelectedFilter();
            }
        });
        return input;
    }

    protected FunctionParameterEditor createLikeToFunctionWidget(CoreFunctionFilter coreFilter) {
        final LikeToFunctionEditor input = (LikeToFunctionEditor)this.beanManager.lookupBean(LikeToFunctionEditor.class, new Annotation[0]).newInstance();
        final List paramList = coreFilter.getParameters();
        String pattern = (String)paramList.get(0);
        boolean caseSensitive = paramList.size() < 2 || Boolean.parseBoolean(paramList.get(1).toString());
        input.setCaseSensitive(caseSensitive);
        input.setPattern(pattern);
        input.setOnChangeCommand(new Command(){

            public void execute() {
                paramList.clear();
                paramList.add(input.getPattern());
                if (!input.isCaseSensitive()) {
                    paramList.add(input.isCaseSensitive());
                }
                ColumnFilterEditor.this.updateSelectedFilter();
            }
        });
        return input;
    }

    public String formatFilterFunction(CoreFunctionFilter filter) {
        String columnId = filter.getColumnId();
        CoreFunctionType type = filter.getType();
        List parameters = filter.getParameters();
        StringBuilder out = new StringBuilder();
        if (CoreFunctionType.BETWEEN.equals((Object)type)) {
            out.append(columnId).append(" [");
            this.formatParameters(out, parameters);
            out.append("]");
        } else if (CoreFunctionType.GREATER_THAN.equals((Object)type)) {
            out.append(columnId).append(" > ");
            this.formatParameters(out, parameters);
        } else if (CoreFunctionType.GREATER_OR_EQUALS_TO.equals((Object)type)) {
            out.append(columnId).append(" >= ");
            this.formatParameters(out, parameters);
        } else if (CoreFunctionType.LOWER_THAN.equals((Object)type)) {
            out.append(columnId).append(" < ");
            this.formatParameters(out, parameters);
        } else if (CoreFunctionType.LOWER_OR_EQUALS_TO.equals((Object)type)) {
            out.append(columnId).append(" <= ");
            this.formatParameters(out, parameters);
        } else if (CoreFunctionType.EQUALS_TO.equals((Object)type)) {
            out.append(columnId).append(" = ");
            this.formatParameters(out, parameters);
        } else if (CoreFunctionType.NOT_EQUALS_TO.equals((Object)type)) {
            out.append(columnId).append(" != ");
            this.formatParameters(out, parameters);
        } else if (CoreFunctionType.LIKE_TO.equals((Object)type)) {
            out.append(columnId).append(" like ");
            this.formatParameters(out, parameters);
        } else if (CoreFunctionType.IS_NULL.equals((Object)type)) {
            out.append(columnId).append(" = null ");
            this.formatParameters(out, parameters);
        } else if (CoreFunctionType.NOT_NULL.equals((Object)type)) {
            out.append(columnId).append(" != null ");
            this.formatParameters(out, parameters);
        } else if (CoreFunctionType.TIME_FRAME.equals((Object)type)) {
            out.append(columnId).append(" = ");
            this.formatParameters(out, parameters);
        } else if (CoreFunctionType.IN.equals((Object)type)) {
            out.append(columnId).append(" in (");
            this.formatParameters(out, parameters);
            out.append(")");
        } else if (CoreFunctionType.NOT_IN.equals((Object)type)) {
            out.append(columnId).append(" not in (");
            this.formatParameters(out, parameters);
            out.append(")");
        }
        return out.toString();
    }

    protected StringBuilder formatParameters(StringBuilder out, List parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                out.append(" ");
            }
            out.append(this.formatParameter(parameters.get(i)));
        }
        return out;
    }

    protected String formatParameter(Object p) {
        if (p == null) {
            return "";
        }
        if (p instanceof Date) {
            Date d = (Date)p;
            return this.view.formatDate(d);
        }
        if (p instanceof Number) {
            Number n = (Number)p;
            return this.view.formatNumber(n);
        }
        return p.toString();
    }

    public static interface View
    extends UberView<ColumnFilterEditor> {
        public void clearFunctionSelector();

        public void addFunctionItem(CoreFunctionType var1);

        public void setFunctionSelected(String var1);

        public int getSelectedFunctionIndex();

        public void showFilterConfig();

        public void clearFilterConfig();

        public void addFilterConfigWidget(IsWidget var1);

        public String formatDate(Date var1);

        public String formatNumber(Number var1);
    }
}

