/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.date.TimeAmount;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

@Dependent
public class TimeAmountEditor
implements IsWidget {
    public static List<DateIntervalType> INTERVAL_TYPES = Arrays.asList(DateIntervalType.SECOND, DateIntervalType.MINUTE, DateIntervalType.HOUR, DateIntervalType.DAY, DateIntervalType.WEEK, DateIntervalType.MONTH, DateIntervalType.QUARTER, DateIntervalType.YEAR, DateIntervalType.CENTURY);
    View view;
    TimeAmount timeAmount = null;
    Command onChangeCommand = new Command(){

        public void execute() {
        }
    };

    @Inject
    public TimeAmountEditor(View view) {
        this.view = view;
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public TimeAmount getTimeAmount() {
        return this.timeAmount;
    }

    public void init(TimeAmount ta, Command onChangeCommand) {
        this.onChangeCommand = onChangeCommand;
        this.timeAmount = ta != null ? ta : new TimeAmount();
        this.view.setQuantity(this.timeAmount.getQuantity());
        this.view.clearIntervalTypeSelector();
        for (int i = 0; i < INTERVAL_TYPES.size(); ++i) {
            DateIntervalType type = INTERVAL_TYPES.get(i);
            this.view.addIntervalTypeItem(type);
            if (this.timeAmount == null || !this.timeAmount.getType().equals((Object)type)) continue;
            this.view.setSelectedTypeIndex(i);
        }
    }

    public long getQuantity() {
        return this.timeAmount.getQuantity();
    }

    public void decreaseQuantity() {
        long q = this.getQuantity() - 1L;
        this.changeQuantity(q);
        this.view.setQuantity(q);
    }

    public void increaseQuantity() {
        long q = this.getQuantity() + 1L;
        this.changeQuantity(q);
        this.view.setQuantity(q);
    }

    public void changeQuantity(String value) {
        if (StringUtils.isBlank((String)value)) {
            this.changeQuantity(0L);
        } else {
            this.changeQuantity(Long.parseLong(value));
        }
    }

    public void changeIntervalType() {
        DateIntervalType type = INTERVAL_TYPES.get(this.view.getSelectedTypeIndex());
        this.timeAmount.setType(type);
        this.onChangeCommand.execute();
    }

    protected void changeQuantity(long q) {
        if (this.timeAmount == null) {
            this.timeAmount = new TimeAmount();
            DateIntervalType type = INTERVAL_TYPES.get(0);
            this.timeAmount.setType(type);
        }
        this.timeAmount.setQuantity(q);
        this.onChangeCommand.execute();
    }

    public static interface View
    extends UberView<TimeAmountEditor> {
        public void setQuantity(long var1);

        public long getQuantity();

        public void clearIntervalTypeSelector();

        public void addIntervalTypeItem(DateIntervalType var1);

        public void setSelectedTypeIndex(int var1);

        public int getSelectedTypeIndex();
    }
}

