/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.sourcecode;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.resources.i18n.SourceCodeEditorConstants;
import org.dashbuilder.displayer.client.widgets.sourcecode.SourceCodeEditor;
import org.dashbuilder.displayer.client.widgets.sourcecode.SourceCodeType;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.NodeList;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.widgets.common.client.ace.AceEditor;
import org.uberfire.ext.widgets.common.client.ace.AceEditorMode;
import org.uberfire.ext.widgets.common.client.ace.AceEditorTheme;

@Dependent
@Templated
public class SourceCodeEditorView
extends Composite
implements SourceCodeEditor.View {
    SourceCodeEditor presenter;
    boolean eventsEnabled = true;
    @Inject
    @DataField
    Div mainDiv;
    @Inject
    @DataField
    AceEditor aceEditor;
    @Inject
    @DataField
    Span errorLabel;
    @Inject
    @DataField
    Button addVariableButton;
    @Inject
    @DataField
    UnorderedList variablesMenu;

    public void init(SourceCodeEditor presenter) {
        this.presenter = presenter;
        this.aceEditor.startEditor();
        this.aceEditor.setTheme(AceEditorTheme.CHROME);
        this.aceEditor.setReadOnly(false);
        this.aceEditor.addOnChangeHandler(this::onEditorChange);
        this.aceEditor.setAutocompleteEnabled(true);
        this.addVariableButton.setTitle(SourceCodeEditorConstants.INSTANCE.add_variable());
    }

    protected void onEditorChange(JavaScriptObject obj) {
        if (this.eventsEnabled && !this.presenter.onSourceCodeChanged(this.aceEditor.getText())) {
            this.aceEditor.setFocus();
        }
    }

    @Override
    public void clearAll() {
        this.clearError();
        this.removeAllChildren((org.jboss.errai.common.client.dom.Element)this.variablesMenu);
        this.aceEditor.setFocus();
    }

    @Override
    public void edit(SourceCodeType type, String code) {
        switch (type) {
            case HTML: {
                this.aceEditor.setMode(AceEditorMode.HTML);
                break;
            }
            case JAVASCRIPT: {
                this.aceEditor.setMode(AceEditorMode.JAVASCRIPT);
            }
        }
        this.eventsEnabled = false;
        this.aceEditor.setText(code != null ? code : "");
        this.aceEditor.setFocus();
        this.eventsEnabled = true;
    }

    @Override
    public void focus() {
        this.aceEditor.setFocus();
    }

    @Override
    public void error(String error) {
        this.mainDiv.setClassName("form-group has-error");
        this.errorLabel.setInnerHTML(error);
    }

    @Override
    public void clearError() {
        this.mainDiv.setClassName("form-group");
        this.errorLabel.setInnerHTML("");
    }

    @Override
    public void declareVariable(String var, String description) {
        SpanElement span = Document.get().createSpanElement();
        span.setInnerText(var);
        AnchorElement anchor = Document.get().createAnchorElement();
        anchor.setTitle(description);
        anchor.appendChild((Node)span);
        LIElement li = Document.get().createLIElement();
        li.getStyle().setCursor(Style.Cursor.POINTER);
        li.appendChild((Node)anchor);
        this.variablesMenu.appendChild((org.jboss.errai.common.client.dom.Node)li);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                this.presenter.onVariableSelected(var);
            }
        });
    }

    @Override
    public void injectVariable(String var) {
        this.aceEditor.insertAtCursor(var);
    }

    private void removeAllChildren(org.jboss.errai.common.client.dom.Element element) {
        NodeList nodeList = element.getChildNodes();
        int lenght = nodeList.getLength();
        for (int i = 0; i < lenght; ++i) {
            element.removeChild(nodeList.item(0));
        }
    }
}

