/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.resources.i18n.DisplayerConstants;

public abstract class AbstractDisplayerView<P extends AbstractDisplayer>
extends Composite
implements AbstractDisplayer.View<P> {
    private FlowPanel panel = new FlowPanel();
    private Label label = new Label();
    private Widget visualization = null;
    private Timer refreshTimer = null;
    private P presenter = null;

    public AbstractDisplayerView() {
        this.initWidget((Widget)this.panel);
    }

    public void setPresenter(P presenter) {
        this.presenter = presenter;
    }

    public P getPresenter() {
        return this.presenter;
    }

    public void setVisualization(Widget widget) {
        this.visualization = widget;
    }

    @Override
    public void setId(String id) {
        this.panel.getElement().setId(id);
    }

    @Override
    public void clear() {
        this.panel.clear();
    }

    @Override
    public void showLoading() {
        this.displayMessage(DisplayerConstants.INSTANCE.initializing());
    }

    @Override
    public void showVisualization() {
        if (this.visualization != null) {
            this.panel.clear();
            this.panel.add(this.visualization);
        }
    }

    @Override
    public void errorMissingSettings() {
        this.displayMessage(DisplayerConstants.INSTANCE.error() + DisplayerConstants.INSTANCE.error_settings_unset());
    }

    @Override
    public void errorMissingHandler() {
        this.displayMessage(DisplayerConstants.INSTANCE.error() + DisplayerConstants.INSTANCE.error_handler_unset());
    }

    @Override
    public void errorDataSetNotFound(String dataSetUUID) {
        this.displayMessage(CommonConstants.INSTANCE.dataset_lookup_dataset_notfound(dataSetUUID));
    }

    @Override
    public void error(ClientRuntimeError e) {
        this.displayMessage(DisplayerConstants.INSTANCE.error() + e.getMessage());
        if (e.getThrowable() != null) {
            GWT.log((String)e.getMessage(), (Throwable)e.getThrowable());
        } else {
            GWT.log((String)e.getMessage());
        }
    }

    @Override
    public void enableRefreshTimer(int seconds) {
        if (this.refreshTimer == null) {
            this.refreshTimer = new Timer(){

                public void run() {
                    if (AbstractDisplayerView.this.presenter.isDrawn()) {
                        AbstractDisplayerView.this.presenter.redraw();
                    }
                }
            };
        }
        this.refreshTimer.schedule(seconds * 1000);
    }

    @Override
    public void cancelRefreshTimer() {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
    }

    public void displayMessage(String msg) {
        this.panel.clear();
        this.panel.add((Widget)this.label);
        this.label.setText(msg);
    }
}

