/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.prototypes;

import java.util.EnumMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.prototypes.DataSetPrototypes;
import org.dashbuilder.displayer.impl.AreaChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.BarChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.BubbleChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.LineChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.MapChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.MeterChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.MetricSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.PieChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;

@ApplicationScoped
public class DisplayerPrototypes {
    protected DataSetPrototypes dataSetPrototypes;
    protected UUIDGenerator uuidGenerator;
    protected Map<DisplayerType, DisplayerSettings> prototypeMap = new EnumMap<DisplayerType, DisplayerSettings>(DisplayerType.class);
    protected Map<DisplayerSubType, DisplayerSettings> subprotoMap = new EnumMap<DisplayerSubType, DisplayerSettings>(DisplayerSubType.class);

    public DisplayerPrototypes() {
    }

    @Inject
    public DisplayerPrototypes(DataSetPrototypes dataSetPrototypes, UUIDGenerator uuidGenerator) {
        this.dataSetPrototypes = dataSetPrototypes;
        this.uuidGenerator = uuidGenerator;
        this.init();
    }

    public void init() {
        this.prototypeMap.put(DisplayerType.PIECHART, ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().uuid("pieChartPrototype")).dataset(this.dataSetPrototypes.getContinentPopulation())).title("Population per Continent")).titleVisible(false)).column("Population")).expression("value/1000000")).format("Population", "#,### M")).width(500)).height(300)).margins(10, 10, 10, 100)).legendOn("right")).set3d(true).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.BARCHART, ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().subType_Bar()).uuid("barChartPrototype")).dataset(this.dataSetPrototypes.getTopRichCountries())).title("Top Rich Countries")).titleVisible(false)).column("Country")).format("Country")).column("GDP 2013")).format("2013", "$ #,### M")).column("GDP 2014")).format("2014", "$ #,### M")).width(500)).height(250)).margins(10, 40, 100, 50)).legendOn("right")).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.LINECHART, ((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)DisplayerSettingsFactory.newLineChartSettings().uuid("lineChartPrototype")).dataset(this.dataSetPrototypes.getContinentPopulation())).title("Population per Continent")).titleVisible(false)).column("Population")).expression("value/1000000")).format("Population", "#,### M")).width(500)).height(300)).margins(10, 40, 90, 10)).legendOff()).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.AREACHART, ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().uuid("areaChartPrototype")).dataset(this.dataSetPrototypes.getContinentPopulation())).title("Population per Continent")).titleVisible(false)).column("Population")).expression("value/1000000")).format("Population", "#,### M")).width(500)).height(300)).margins(10, 40, 90, 10)).legendOff()).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.BUBBLECHART, ((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)DisplayerSettingsFactory.newBubbleChartSettings().uuid("bubbleChartPrototype")).dataset(this.dataSetPrototypes.getContinentPopulationExt())).title("Population per Continent")).titleVisible(false)).width(500)).height(300)).margins(10, 30, 50, 10)).legendOff()).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.METERCHART, ((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)DisplayerSettingsFactory.newMeterChartSettings().uuid("meterChartPrototype")).dataset(this.dataSetPrototypes.getContinentPopulation())).title("Population per Continent")).titleVisible(false)).width(400)).height(300)).column("Population")).expression("value/1000000")).format("Population", "#,### M")).margins(10, 10, 10, 10)).meter(0L, 1000L, 3000L, 6000L).filterOn(false, true, true)).buildSettings());
        DisplayerSettings metricCard = ((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().uuid("metricCardPrototype")).dataset(this.dataSetPrototypes.getTotalPopulation())).column("Population")).format("Population", "#,##0 MM")).subtype(DisplayerSubType.METRIC_CARD)).title("World population")).titleVisible(true)).width(200)).height(100)).margins(0, 0, 0, 0)).backgroundColor("white")).filterOn(false, false, true)).htmlTemplate("<div id=\"${this}\" class=\"card-pf card-pf-accented card-pf-aggregate-status\" style=\"background-color:${bgColor}; width:${width}px; height:${height}px; margin-top:${marginTop}px; margin-right:${marginRight}px; margin-bottom:${marginBottom}px; margin-left:${marginLeft}px;\">\n  <h3>${title}</h3>\n  <h2>${value}</h2>\n</div>")).jsTemplate("if (${isFilterEnabled}) {  \n  var filterOn = false;\n  ${this}.style.cursor=\"pointer\";\n\n  ${this}.onmouseover = function() {\n    if (!filterOn) ${this}.style.backgroundColor = \"lightblue\";\n  };\n  ${this}.onmouseout = function() {\n    if (!filterOn) ${this}.style.backgroundColor = \"${bgColor}\";\n  };\n  ${this}.onclick = function() {\n    filterOn = !filterOn;\n    ${this}.style.backgroundColor = filterOn ? \"lightblue\" : \"${bgColor}\";\n    ${doFilter};\n  };\n}")).buildSettings();
        DisplayerSettings metricCard2 = ((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().uuid("metricCard2Prototype")).dataset(this.dataSetPrototypes.getTotalPopulation())).column("Population")).format("Population", "#,##0 MM")).subtype(DisplayerSubType.METRIC_CARD2)).title("World population")).titleVisible(true)).width(200)).height(100)).margins(0, 0, 0, 0)).backgroundColor("white")).filterOn(false, false, true)).htmlTemplate("<h2 class=\"card-pf-title\">\n    ${title}\n  </h2>\n<div class=\"card-pf-body\">\n   <p class=\"card-pf-utilization-details\">\n      <span class=\"card-pf-utilization-card-details-count\">${value}</span>\n        <span class=\"card-pf-utilization-card-details-description\">\n          <span class=\"card-pf-utilization-card-details-line-1\">people</span>\n          <span class=\"card-pf-utilization-card-details-line-2\">in the world</span>\n        </span>\n   </p>\n</div>")).buildSettings();
        DisplayerSettings metricQuota = ((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().uuid("metricQuotaPrototype")).dataset(this.dataSetPrototypes.getTotalPopulation())).column("Population")).format("Population", "#,##0 MM")).subtype(DisplayerSubType.METRIC_QUOTA)).title("World population")).titleVisible(true)).width(200)).height(100)).margins(0, 0, 0, 0)).metric(0L, 0L, 0L, 100000L).filterOn(false, false, true)).htmlTemplate("<div class=\"progress-description\">\n   ${title}\n</div>\n<div class=\"progress progress-label-top-right\">\n  <div id=\"${bar}\" class=\"progress-bar\" role=\"progressbar\" data-toggle=\"tooltip\" title=\"${value}\">\n    <span><strong>${value}</strong></span>\n  </div>\n  <div class=\"progress-bar progress-bar-remaining\" role=\"progressbar\" data-toggle=\"tooltip\">\n  </div>\n</div>")).jsTemplate("var end = ${value.end};\nvar current = Math.round(${value.raw} * 100 / end);\n${bar}.style.width = current + \"%\";")).buildSettings();
        DisplayerSettings metricPlainText = ((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().uuid("metricPlainTextPrototype")).dataset(this.dataSetPrototypes.getTotalPopulation())).column("Population")).format("Population", "#,##0 MM")).subtype(DisplayerSubType.METRIC_PLAIN_TEXT)).title("World population ")).titleVisible(true)).width(200)).height(100)).margins(0, 0, 0, 0)).metric(0L, 50000L, 75000L, 100000L).filterOn(false, false, true)).htmlTemplate("<div>\n  ${title}: <span id=\"${valref}\" style=\"font-weight: bold\">${value}</span>\n</div>\n")).jsTemplate("if (${value.raw} > ${value.critical}) {  \n    ${valref}.style.color = \"red\"; \n} else if (${value.raw} > ${value.warning}) {  \n    ${valref}.style.color = \"yellow\"; \n} else {\n    ${valref}.style.color = \"black\";\n}")).buildSettings();
        this.prototypeMap.put(DisplayerType.METRIC, metricCard);
        this.subprotoMap.put(DisplayerSubType.METRIC_CARD, metricCard);
        this.subprotoMap.put(DisplayerSubType.METRIC_CARD2, metricCard2);
        this.subprotoMap.put(DisplayerSubType.METRIC_QUOTA, metricQuota);
        this.subprotoMap.put(DisplayerSubType.METRIC_PLAIN_TEXT, metricPlainText);
        this.prototypeMap.put(DisplayerType.MAP, ((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)DisplayerSettingsFactory.newMapChartSettings().uuid("mapChartPrototype")).dataset(this.dataSetPrototypes.getCountryPopulation())).title("World Population")).titleVisible(false)).width(500)).height(300)).margins(10, 10, 10, 10)).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.TABLE, ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().uuid("tablePrototype")).dataset(this.dataSetPrototypes.getWorldPopulation())).title("Population per Continent")).titleVisible(false)).column("Population")).expression("value/1000000")).format("Population", "#,### M")).tableOrderEnabled(true).tableOrderDefault("Population", SortOrder.DESCENDING).tablePageSize(8).filterOn(false, true, true)).buildSettings());
    }

    public DisplayerSettings getProto(DisplayerType type) {
        return this.getProto(type, null);
    }

    public DisplayerSettings getProto(DisplayerType type, DisplayerSubType subType) {
        boolean hasSubproto = subType != null && this.subprotoMap.containsKey(subType);
        DisplayerSettings proto = hasSubproto ? this.subprotoMap.get(subType) : this.prototypeMap.get(type);
        proto = proto.cloneInstance();
        proto.setUUID(this.uuidGenerator.newUuid());
        if (subType != null) {
            proto.setSubtype(subType);
        }
        return proto;
    }
}

