/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.resources.i18n.DisplayerHtmlConstants;
import org.dashbuilder.displayer.client.widgets.DisplayerHtmlEditor;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.NodeList;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class DisplayerHtmlEditorView
extends Composite
implements DisplayerHtmlEditor.View {
    @Inject
    @DataField
    FlowPanel contentPanel;
    @Inject
    @DataField
    UnorderedList tabList;
    @Inject
    @DataField
    ListItem previewItem;
    @Inject
    @DataField
    Anchor previewAnchor;
    LIElement selectedItem;
    DisplayerHtmlEditor presenter;

    public void init(DisplayerHtmlEditor presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showDisplayer(IsWidget displayer) {
        this.contentPanel.clear();
        this.contentPanel.add(displayer);
        this.previewItem.setClassName("active");
        this.previewAnchor.setTextContent(DisplayerHtmlConstants.INSTANCE.displayer_html_preview_link());
    }

    @Override
    public void clearSourceCodeItems() {
        this.removeAllChildren((org.jboss.errai.common.client.dom.Element)this.tabList);
        this.tabList.appendChild((org.jboss.errai.common.client.dom.Node)this.previewItem);
    }

    @Override
    public void editSourceCodeItem(String name, IsWidget editor) {
        this.contentPanel.clear();
        this.contentPanel.add(editor);
    }

    @Override
    public void addSourceCodeItem(String name) {
        AnchorElement anchor = Document.get().createAnchorElement();
        String displayName = DisplayerHtmlConstants.INSTANCE.getString("displayer_source_code_" + name);
        anchor.setInnerText(displayName);
        LIElement li = Document.get().createLIElement();
        li.getStyle().setCursor(Style.Cursor.POINTER);
        li.appendChild((Node)anchor);
        this.tabList.appendChild((org.jboss.errai.common.client.dom.Node)li);
        Event.sinkEvents((Element)anchor, (int)1);
        Event.setEventListener((Element)anchor, event -> {
            if (1 == event.getTypeInt()) {
                this.presenter.onSourceCodeItemSelected(name);
                if (this.selectedItem != null) {
                    this.selectedItem.setClassName("");
                    this.selectedItem.getStyle().setCursor(Style.Cursor.POINTER);
                }
                this.selectedItem = li;
                this.selectedItem.setClassName("active");
                this.selectedItem.getStyle().setCursor(Style.Cursor.DEFAULT);
                this.previewItem.setClassName("");
            }
        });
    }

    private void removeAllChildren(org.jboss.errai.common.client.dom.Element element) {
        NodeList nodeList = element.getChildNodes();
        int lenght = nodeList.getLength();
        for (int i = 0; i < lenght; ++i) {
            element.removeChild(nodeList.item(0));
        }
    }

    @EventHandler(value={"previewAnchor"})
    private void onPreviewClicked(ClickEvent event) {
        if (!this.presenter.showDisplayer()) {
            event.stopPropagation();
        } else {
            this.previewItem.setClassName("active");
            if (this.selectedItem != null) {
                this.selectedItem.setClassName("");
                this.selectedItem.getStyle().setCursor(Style.Cursor.POINTER);
            }
        }
    }
}

