/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.ValidationError;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalPattern;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerGwtExprEval;
import org.dashbuilder.displayer.client.DisplayerGwtFormatter;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.export.ExportCallback;
import org.dashbuilder.displayer.client.export.ExportFormat;
import org.dashbuilder.displayer.client.formatter.ValueFormatter;

public abstract class AbstractDisplayer<V extends View>
implements Displayer {
    protected DataSet dataSet;
    protected DataSetHandler dataSetHandler;
    protected DisplayerSettings displayerSettings;
    protected DisplayerConstraints displayerConstraints;
    protected List<DisplayerListener> listenerList = new ArrayList<DisplayerListener>();
    protected Map<String, List<Interval>> columnSelectionMap = new HashMap<String, List<Interval>>();
    protected Map<String, ValueFormatter> formatterMap = new HashMap<String, ValueFormatter>();
    protected Formatter formatter = null;
    protected ExpressionEval evaluator = null;
    protected DataSetFilter currentFilter = null;
    protected boolean refreshEnabled = true;
    protected boolean drawn = false;

    public Widget asWidget() {
        return this.getView().asWidget();
    }

    public abstract V getView();

    public abstract DisplayerConstraints createDisplayerConstraints();

    protected abstract void createVisualization();

    protected abstract void updateVisualization();

    @Override
    public DisplayerConstraints getDisplayerConstraints() {
        if (this.displayerConstraints == null) {
            this.displayerConstraints = this.createDisplayerConstraints();
        }
        return this.displayerConstraints;
    }

    @Override
    public DisplayerSettings getDisplayerSettings() {
        return this.displayerSettings;
    }

    @Override
    public void setDisplayerSettings(DisplayerSettings displayerSettings) {
        this.checkDisplayerSettings(displayerSettings);
        this.displayerSettings = displayerSettings;
    }

    public void checkDisplayerSettings(DisplayerSettings displayerSettings) {
        ValidationError error;
        DisplayerConstraints constraints = this.getDisplayerConstraints();
        if (this.displayerConstraints != null && (error = constraints.check(displayerSettings)) != null) {
            throw error;
        }
    }

    @Override
    public DataSetHandler getDataSetHandler() {
        return this.dataSetHandler;
    }

    @Override
    public void setDataSetHandler(DataSetHandler dataSetHandler) {
        this.dataSetHandler = dataSetHandler;
    }

    public Formatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = new DisplayerGwtFormatter();
        }
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public ExpressionEval getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new DisplayerGwtExprEval(this);
        }
        return this.evaluator;
    }

    public void setEvaluator(ExpressionEval evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public void addListener(DisplayerListener ... listeners) {
        for (DisplayerListener listener : listeners) {
            this.listenerList.add(listener);
        }
    }

    public String getDisplayerId() {
        String id = this.displayerSettings.getUUID();
        if (!StringUtils.isBlank((String)id)) {
            return id;
        }
        id = this.displayerSettings.getTitle();
        if (!StringUtils.isBlank((String)id)) {
            int hash = id.hashCode();
            return Integer.toString(hash < 0 ? hash * -1 : hash);
        }
        return null;
    }

    @Override
    public boolean isDrawn() {
        return this.drawn;
    }

    @Override
    public void draw() {
        if (this.displayerSettings == null) {
            this.getView().errorMissingSettings();
        } else if (this.dataSetHandler == null) {
            this.getView().errorMissingHandler();
        } else if (!this.isDrawn()) {
            try {
                this.drawn = true;
                this.getView().showLoading();
                this.beforeLoad();
                this.beforeDataSetLookup();
                this.dataSetHandler.lookupDataSet(new DataSetReadyCallback(){

                    public void callback(DataSet result) {
                        try {
                            AbstractDisplayer.this.dataSet = result;
                            AbstractDisplayer.this.afterLoad();
                            AbstractDisplayer.this.afterDataSetLookup(result);
                            AbstractDisplayer.this.createVisualization();
                            AbstractDisplayer.this.getView().showVisualization();
                            String id = AbstractDisplayer.this.getDisplayerId();
                            if (!StringUtils.isBlank((String)id)) {
                                AbstractDisplayer.this.getView().setId(id);
                            }
                            AbstractDisplayer.this.afterDraw();
                        }
                        catch (Exception e) {
                            AbstractDisplayer.this.showError(new ClientRuntimeError((Throwable)e));
                        }
                    }

                    public void notFound() {
                        AbstractDisplayer.this.getView().errorDataSetNotFound(AbstractDisplayer.this.displayerSettings.getDataSetLookup().getDataSetUUID());
                    }

                    public boolean onError(ClientRuntimeError error) {
                        AbstractDisplayer.this.showError(error);
                        return false;
                    }
                });
            }
            catch (Exception e) {
                this.showError(new ClientRuntimeError((Throwable)e));
            }
        }
    }

    @Override
    public void redraw() {
        if (!this.isDrawn()) {
            this.draw();
        } else {
            try {
                this.beforeLoad();
                this.beforeDataSetLookup();
                this.dataSetHandler.lookupDataSet(new DataSetReadyCallback(){

                    public void callback(DataSet result) {
                        try {
                            AbstractDisplayer.this.dataSet = result;
                            AbstractDisplayer.this.afterDataSetLookup(result);
                            AbstractDisplayer.this.updateVisualization();
                            AbstractDisplayer.this.afterRedraw();
                        }
                        catch (Exception e) {
                            AbstractDisplayer.this.showError(new ClientRuntimeError((Throwable)e));
                        }
                    }

                    public void notFound() {
                        String uuid = AbstractDisplayer.this.displayerSettings.getDataSetLookup().getDataSetUUID();
                        AbstractDisplayer.this.getView().errorDataSetNotFound(uuid);
                        AbstractDisplayer.this.handleError("Data set not found: " + uuid);
                    }

                    public boolean onError(ClientRuntimeError error) {
                        AbstractDisplayer.this.showError(error);
                        AbstractDisplayer.this.requestDraw();
                        return false;
                    }
                });
            }
            catch (Exception e) {
                this.showError(new ClientRuntimeError((Throwable)e));
            }
        }
    }

    private void requestDraw() {
        this.drawn = false;
    }

    public void showError(ClientRuntimeError error) {
        this.getView().error(error);
        this.handleError(error);
    }

    @Override
    public void close() {
        this.getView().clear();
        this.afterClose();
    }

    protected void beforeDataSetLookup() {
    }

    protected void afterDataSetLookup(DataSet dataSet) {
    }

    @Override
    public void setRefreshOn(boolean enabled) {
        boolean changed = enabled != this.refreshEnabled;
        this.refreshEnabled = enabled;
        if (changed) {
            this.updateRefreshTimer();
        }
    }

    @Override
    public boolean isRefreshOn() {
        return this.refreshEnabled;
    }

    protected void updateRefreshTimer() {
        if (this.isDrawn()) {
            int seconds = this.displayerSettings.getRefreshInterval();
            if (this.refreshEnabled && seconds > 0) {
                this.getView().enableRefreshTimer(seconds);
            } else {
                this.getView().cancelRefreshTimer();
            }
        }
    }

    protected void beforeLoad() {
        for (DisplayerListener listener : this.listenerList) {
            listener.onDataLookup(this);
        }
    }

    protected void afterLoad() {
        for (DisplayerListener listener : this.listenerList) {
            listener.onDataLoaded(this);
        }
    }

    protected void afterDraw() {
        this.updateRefreshTimer();
        for (DisplayerListener listener : this.listenerList) {
            listener.onDraw(this);
        }
    }

    protected void afterRedraw() {
        this.updateRefreshTimer();
        for (DisplayerListener listener : this.listenerList) {
            listener.onRedraw(this);
        }
    }

    protected void afterClose() {
        this.setRefreshOn(false);
        for (DisplayerListener listener : this.listenerList) {
            listener.onClose(this);
        }
    }

    public void handleError(String message) {
        this.handleError(new ClientRuntimeError(message, null));
    }

    public void handleError(String message, Throwable error) {
        this.handleError(new ClientRuntimeError(message, error));
    }

    public void handleError(Throwable error) {
        this.handleError(new ClientRuntimeError(error));
    }

    public void handleError(ClientRuntimeError error) {
        for (DisplayerListener listener : this.listenerList) {
            listener.onError(this, error);
        }
    }

    @Override
    public void onDataLookup(Displayer displayer) {
    }

    @Override
    public void onDataLoaded(Displayer displayer) {
    }

    @Override
    public void onDraw(Displayer displayer) {
    }

    @Override
    public void onRedraw(Displayer displayer) {
    }

    @Override
    public void onClose(Displayer displayer) {
    }

    @Override
    public void onError(Displayer displayer, ClientRuntimeError error) {
    }

    @Override
    public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
        if (this.displayerSettings.isFilterListeningEnabled() && this.dataSetHandler.filter(groupOp)) {
            this.redraw();
        }
    }

    @Override
    public void onFilterEnabled(Displayer displayer, DataSetFilter filter) {
        if (this.displayerSettings.isFilterListeningEnabled() && this.dataSetHandler.filter(filter)) {
            this.redraw();
        }
    }

    @Override
    public void onFilterUpdate(Displayer displayer, DataSetFilter oldFilter, DataSetFilter newFilter) {
        if (this.displayerSettings.isFilterListeningEnabled()) {
            boolean unfilter = this.dataSetHandler.unfilter(oldFilter);
            boolean filter = this.dataSetHandler.filter(newFilter);
            if (unfilter || filter) {
                this.redraw();
            }
        }
    }

    @Override
    public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
        if (this.displayerSettings.isFilterListeningEnabled()) {
            boolean applied = false;
            for (DataSetGroup groupOp : groupOps) {
                if (!this.dataSetHandler.unfilter(groupOp)) continue;
                applied = true;
            }
            if (applied) {
                this.redraw();
            }
        }
    }

    @Override
    public void onFilterReset(Displayer displayer, DataSetFilter filter) {
        if (this.displayerSettings.isFilterListeningEnabled() && this.dataSetHandler.unfilter(filter)) {
            this.redraw();
        }
    }

    public Set<String> filterColumns() {
        return this.columnSelectionMap.keySet();
    }

    public List<Interval> filterIntervals(String columnId) {
        List<Interval> selected = this.columnSelectionMap.get(columnId);
        if (selected == null) {
            return new ArrayList<Interval>();
        }
        return selected;
    }

    public Interval filterInterval(String columnId, int idx) {
        List<Interval> selected = this.columnSelectionMap.get(columnId);
        if (selected != null && !selected.isEmpty()) {
            for (Interval interval : selected) {
                if (interval.getIndex() != idx) continue;
                return interval;
            }
        }
        return null;
    }

    public List<Integer> filterIndexes(String columnId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<Interval> selected = this.columnSelectionMap.get(columnId);
        if (selected == null) {
            return result;
        }
        for (Interval interval : selected) {
            result.add(interval.getIndex());
        }
        return result;
    }

    public void filterUpdate(String columnId, int row) {
        this.filterUpdate(columnId, row, null);
    }

    public void filterUpdate(String columnId, int row, Integer maxSelections) {
        if (this.displayerSettings.isFilterEnabled()) {
            List<Interval> selectedIntervals = this.columnSelectionMap.get(columnId);
            Interval intervalFiltered = this.filterInterval(columnId, row);
            if (intervalFiltered != null) {
                selectedIntervals.remove(intervalFiltered);
                if (!selectedIntervals.isEmpty()) {
                    this.filterApply(columnId, selectedIntervals);
                } else {
                    this.filterReset(columnId);
                }
            } else if (selectedIntervals == null) {
                Interval intervalSelected = this.dataSetHandler.getInterval(columnId, row);
                if (intervalSelected != null) {
                    selectedIntervals = new ArrayList<Interval>();
                    selectedIntervals.add(intervalSelected);
                    this.columnSelectionMap.put(columnId, selectedIntervals);
                    this.filterApply(columnId, selectedIntervals);
                }
            } else {
                Interval intervalSelected = this.dataSetHandler.getInterval(columnId, row);
                if (intervalSelected != null) {
                    if (this.displayerSettings.isFilterSelfApplyEnabled()) {
                        selectedIntervals = new ArrayList<Interval>();
                        this.columnSelectionMap.put(columnId, selectedIntervals);
                    }
                    selectedIntervals.add(intervalSelected);
                    if (maxSelections != null && maxSelections > 0 && selectedIntervals.size() >= maxSelections) {
                        this.filterReset(columnId);
                    } else {
                        this.filterApply(columnId, selectedIntervals);
                    }
                }
            }
        }
    }

    public void filterApply(String columnId, List<Interval> intervalList) {
        if (this.displayerSettings.isFilterEnabled()) {
            DataSetGroup groupOp = this.dataSetHandler.getGroupOperation(columnId);
            groupOp.setSelectedIntervalList(intervalList);
            if (this.displayerSettings.isFilterNotificationEnabled()) {
                for (DisplayerListener listener : this.listenerList) {
                    listener.onFilterEnabled((Displayer)this, groupOp);
                }
            }
            if (this.displayerSettings.isFilterSelfApplyEnabled()) {
                this.dataSetHandler.drillDown(groupOp);
                this.redraw();
            }
        }
    }

    public void filterApply(DataSetFilter filter) {
        if (this.displayerSettings.isFilterEnabled()) {
            this.currentFilter = filter;
            if (this.displayerSettings.isFilterNotificationEnabled()) {
                for (DisplayerListener listener : this.listenerList) {
                    listener.onFilterEnabled((Displayer)this, filter);
                }
            }
            if (this.displayerSettings.isFilterSelfApplyEnabled()) {
                this.dataSetHandler.filter(filter);
                this.redraw();
            }
        }
    }

    public void filterUpdate(DataSetFilter filter) {
        if (this.displayerSettings.isFilterEnabled()) {
            DataSetFilter oldFilter = this.currentFilter;
            this.currentFilter = filter;
            if (this.displayerSettings.isFilterNotificationEnabled()) {
                for (DisplayerListener listener : this.listenerList) {
                    listener.onFilterUpdate(this, oldFilter, filter);
                }
            }
            if (this.displayerSettings.isFilterSelfApplyEnabled()) {
                this.dataSetHandler.unfilter(oldFilter);
                this.dataSetHandler.filter(filter);
                this.redraw();
            }
        }
    }

    public void filterReset(String columnId) {
        if (this.displayerSettings.isFilterEnabled()) {
            this.columnSelectionMap.remove(columnId);
            DataSetGroup groupOp = this.dataSetHandler.getGroupOperation(columnId);
            if (this.displayerSettings.isFilterNotificationEnabled()) {
                for (DisplayerListener listener : this.listenerList) {
                    listener.onFilterReset((Displayer)this, Arrays.asList(groupOp));
                }
            }
            if (this.displayerSettings.isFilterSelfApplyEnabled()) {
                this.dataSetHandler.drillUp(groupOp);
                this.redraw();
            }
        }
    }

    public void filterReset() {
        if (this.displayerSettings.isFilterEnabled()) {
            ArrayList<DataSetGroup> groupOpList = new ArrayList<DataSetGroup>();
            for (String columnId : this.columnSelectionMap.keySet()) {
                DataSetGroup groupOp = this.dataSetHandler.getGroupOperation(columnId);
                groupOpList.add(groupOp);
            }
            this.columnSelectionMap.clear();
            if (this.displayerSettings.isFilterNotificationEnabled()) {
                for (DisplayerListener listener : this.listenerList) {
                    if (this.currentFilter != null) {
                        listener.onFilterReset((Displayer)this, this.currentFilter);
                    }
                    listener.onFilterReset((Displayer)this, groupOpList);
                }
            }
            if (this.displayerSettings.isFilterSelfApplyEnabled()) {
                boolean applied = false;
                if (this.currentFilter != null && this.dataSetHandler.unfilter(this.currentFilter)) {
                    applied = true;
                }
                for (DataSetGroup groupOp : groupOpList) {
                    if (!this.dataSetHandler.drillUp(groupOp)) continue;
                    applied = true;
                }
                if (applied) {
                    this.redraw();
                }
            }
            if (this.currentFilter != null) {
                this.currentFilter = null;
            }
        }
    }

    public void sortApply(String columnId, SortOrder sortOrder) {
        this.dataSetHandler.sort(columnId, sortOrder);
    }

    public String formatInterval(Interval interval, DataColumn column) {
        DateIntervalType intervalType;
        if (column == null || column.getColumnGroup() == null) {
            return interval.getName();
        }
        String type = interval.getType();
        if (StringUtils.isBlank((String)type)) {
            type = column.getIntervalType();
        }
        if (StringUtils.isBlank((String)type)) {
            type = column.getColumnGroup().getIntervalSize();
        }
        if ((intervalType = DateIntervalType.getByName((String)type)) != null) {
            String expression;
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(column.getId());
            String pattern = columnSettings != null ? columnSettings.getValuePattern() : ColumnSettings.getDatePattern((DateIntervalType)intervalType);
            String string = expression = columnSettings != null ? columnSettings.getValueExpression() : null;
            if (pattern == null) {
                pattern = ColumnSettings.getDatePattern((DateIntervalType)intervalType);
            }
            if (expression == null && column.getColumnGroup().getStrategy().equals((Object)GroupStrategy.FIXED)) {
                expression = ColumnSettings.getFixedExpression((DateIntervalType)intervalType);
            }
            return this.formatDate(intervalType, column.getColumnGroup().getStrategy(), interval.getName(), pattern, expression);
        }
        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(column);
        String expression = columnSettings.getValueExpression();
        if (StringUtils.isBlank((String)expression)) {
            return interval.getName();
        }
        return this.getEvaluator().evalExpression(interval.getName(), expression);
    }

    @Override
    public void addFormatter(String columnId, ValueFormatter formatter) {
        this.formatterMap.put(columnId, formatter);
    }

    public ValueFormatter getFormatter(String columnId) {
        return this.formatterMap.get(columnId);
    }

    public String formatValue(int row, int column) {
        Object value = row < this.dataSet.getRowCount() ? this.dataSet.getValueAt(row, column) : null;
        DataColumn columnObj = this.dataSet.getColumnByIndex(column);
        ValueFormatter formatter = this.getFormatter(columnObj.getId());
        if (formatter != null) {
            return formatter.formatValue(this.dataSet, row, column);
        }
        return this.formatValue(value, columnObj);
    }

    public String formatValue(Object value, DataColumn column) {
        ValueFormatter formatter = this.getFormatter(column.getId());
        if (formatter != null) {
            return formatter.formatValue(value);
        }
        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(column);
        String pattern = columnSettings.getValuePattern();
        String empty = columnSettings.getEmptyTemplate();
        String expression = columnSettings.getValueExpression();
        if (value == null) {
            return empty;
        }
        DateIntervalType intervalType = DateIntervalType.getByName((String)column.getIntervalType());
        if (intervalType != null) {
            ColumnGroup columnGroup = column.getColumnGroup();
            return this.formatDate(intervalType, columnGroup.getStrategy(), value.toString(), pattern, expression);
        }
        ColumnType columnType = column.getColumnType();
        if (ColumnType.DATE.equals((Object)columnType)) {
            Date d = (Date)value;
            return this.getFormatter().formatDate(pattern, d);
        }
        if (ColumnType.NUMBER.equals((Object)columnType)) {
            OptionalDouble od = OptionalDouble.empty();
            if (value instanceof Number) {
                od = OptionalDouble.of(((Number)value).doubleValue());
            }
            if (!StringUtils.isBlank((String)expression)) {
                String r = this.getEvaluator().evalExpression(value.toString(), expression);
                try {
                    od = OptionalDouble.of(Double.parseDouble(r));
                }
                catch (NumberFormatException e) {
                    return r;
                }
            }
            return this.getFormatter().formatNumber(pattern, od.getAsDouble());
        }
        if (StringUtils.isBlank((String)expression)) {
            return value.toString();
        }
        return this.getEvaluator().evalExpression(value.toString(), expression);
    }

    protected String formatDate(DateIntervalType type, GroupStrategy strategy, String date, String pattern, String expression) {
        String str;
        if (date == null) {
            return null;
        }
        String string = str = GroupStrategy.FIXED.equals((Object)strategy) ? this.formatDateFixed(type, date) : this.formatDateDynamic(type, date, pattern);
        if (StringUtils.isBlank((String)expression)) {
            return str;
        }
        return this.getEvaluator().evalExpression(str, expression);
    }

    protected String formatDateFixed(DateIntervalType type, String date) {
        if (date == null) {
            return null;
        }
        int index = Integer.parseInt(date);
        if (DateIntervalType.DAY_OF_WEEK.equals((Object)type)) {
            DayOfWeek dayOfWeek = DayOfWeek.getByIndex((int)index);
            return this.getFormatter().formatDayOfWeek(dayOfWeek);
        }
        if (DateIntervalType.MONTH.equals((Object)type)) {
            Month month = Month.getByIndex((int)index);
            return this.getFormatter().formatMonth(month);
        }
        return date;
    }

    protected String formatDateDynamic(DateIntervalType type, String date, String pattern) {
        if (date == null) {
            return null;
        }
        Date d = this.parseDynamicGroupDate(type, date);
        return this.getFormatter().formatDate(pattern, d);
    }

    protected Date parseDynamicGroupDate(DateIntervalType type, String date) {
        String pattern = DateIntervalPattern.getPattern((DateIntervalType)type);
        return this.getFormatter().parseDate(pattern, date);
    }

    @Override
    public void export(ExportFormat format, int maxRows, ExportCallback callback) {
        if (this.dataSetHandler == null) {
            callback.noData();
        } else {
            HashMap<String, String> columnNameMap = new HashMap<String, String>();
            this.displayerSettings.getColumnSettingsList().forEach(cs -> columnNameMap.put(cs.getColumnId(), cs.getColumnName()));
            this.dataSetHandler.exportCurrentDataSetLookup(format, maxRows, callback, columnNameMap);
        }
    }

    public static interface ExpressionEval {
        public String evalExpression(String var1, String var2);
    }

    public static interface Formatter {
        public String formatDate(String var1, Date var2);

        public Date parseDate(String var1, String var2);

        public String formatNumber(String var1, Number var2);

        public String formatDayOfWeek(DayOfWeek var1);

        public String formatMonth(Month var1);
    }

    public static interface View
    extends IsWidget {
        public void errorMissingSettings();

        public void errorMissingHandler();

        public void showLoading();

        public void showVisualization();

        public void clear();

        public void setId(String var1);

        public void errorDataSetNotFound(String var1);

        public void error(ClientRuntimeError var1);

        public void enableRefreshTimer(int var1);

        public void cancelRefreshTimer();
    }
}

