/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.DisplayerErrorWidget;
import org.dashbuilder.displayer.client.widgets.RendererSelector;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class DisplayerViewer
extends Composite {
    protected DisplayerSettings displayerSettings;
    protected Panel container = new FlowPanel();
    protected Label label = new Label();
    protected Displayer displayer;
    protected Boolean isShowRendererSelector = false;
    @Inject
    protected DisplayerErrorWidget errorWidget;
    protected boolean error = true;
    protected DisplayerLocator displayerLocator;
    protected RendererSelector rendererSelector;
    ClientRuntimeError displayerInitializationError;
    CommonConstants i18n = CommonConstants.INSTANCE;
    DisplayerListener displayerListener = new AbstractDisplayerListener(){

        @Override
        public void onDraw(Displayer displayer) {
            if (DisplayerViewer.this.error) {
                DisplayerViewer.this.show();
            }
        }

        @Override
        public void onRedraw(Displayer displayer) {
            if (DisplayerViewer.this.error) {
                DisplayerViewer.this.show();
            }
        }

        @Override
        public void onError(Displayer displayer, ClientRuntimeError error) {
            DisplayerViewer.this.error(error);
        }
    };

    @Inject
    public DisplayerViewer(DisplayerLocator displayerLocator, RendererSelector rendererSelector) {
        this.displayerLocator = displayerLocator;
        this.rendererSelector = rendererSelector;
        this.initWidget((Widget)this.container);
    }

    public DisplayerSettings getDisplayerSettings() {
        return this.displayerSettings;
    }

    public void setIsShowRendererSelector(Boolean isShowRendererSelector) {
        this.isShowRendererSelector = isShowRendererSelector;
    }

    public Displayer getDisplayer() {
        return this.displayer;
    }

    public void init(DisplayerSettings displayerSettings) {
        try {
            PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)displayerSettings);
            this.displayerSettings = displayerSettings;
            this.displayer = this.displayerLocator.lookupDisplayer(displayerSettings);
            this.displayer.addListener(this.displayerListener);
            this.show();
        }
        catch (Exception e) {
            this.displayerInitializationError = new ClientRuntimeError((Throwable)e);
            this.error(this.displayerInitializationError);
        }
    }

    protected void show() {
        this.container.clear();
        final FlowPanel displayerContainer = new FlowPanel();
        displayerContainer.add((IsWidget)this.displayer);
        if (this.isShowRendererSelector.booleanValue()) {
            this.rendererSelector.init(this.displayerSettings, RendererSelector.SelectorType.TAB, 300, new Command(){

                public void execute() {
                    DisplayerViewer.this.displayerSettings.setRenderer(DisplayerViewer.this.rendererSelector.getRendererLibrary().getUUID());
                    DisplayerViewer.this.displayer = DisplayerViewer.this.displayerLocator.lookupDisplayer(DisplayerViewer.this.displayerSettings);
                    DisplayerViewer.this.displayer.draw();
                    displayerContainer.clear();
                    displayerContainer.add((IsWidget)DisplayerViewer.this.displayer);
                }
            });
            this.container.add((IsWidget)this.rendererSelector);
        }
        this.container.add((Widget)displayerContainer);
        this.error = false;
    }

    public Displayer draw() {
        if (this.displayerInitializationError != null) {
            this.error(this.displayerInitializationError, this.i18n.displayerviewer_displayer_not_created());
        } else {
            try {
                this.displayer.draw();
            }
            catch (Exception e) {
                this.error(new ClientRuntimeError((Throwable)e));
            }
        }
        return this.displayer;
    }

    public Displayer redraw() {
        try {
            PortablePreconditions.checkNotNull((String)"displayerSettings", (Object)this.displayerSettings);
            PortablePreconditions.checkNotNull((String)"displayer", (Object)this.displayer);
            this.displayer.setDisplayerSettings(this.displayerSettings);
            this.displayer.redraw();
        }
        catch (Exception e) {
            this.error(new ClientRuntimeError((Throwable)e));
        }
        return this.displayer;
    }

    public void error(ClientRuntimeError e) {
        String message = e.getMessage();
        if (e.getThrowable() != null) {
            message = e.getThrowable().getMessage();
        }
        this.error(e, message);
    }

    public void error(ClientRuntimeError e, String message) {
        this.container.clear();
        this.container.add((Widget)this.errorWidget);
        this.errorWidget.show(message, e.getThrowable());
        this.error = true;
        GWT.log((String)e.getMessage(), (Throwable)e.getThrowable());
    }
}

