/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.widgets.ExternalComponentPresenter;
import org.dashbuilder.displayer.client.widgets.ExternalComponentPropertiesEditor;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.dashbuilder.displayer.external.ExternalComponentMessageHelper;
import org.uberfire.client.mvp.UberView;

@Dependent
public class ExternalComponentEditor
implements IsWidget {
    @Inject
    View view;
    @Inject
    ExternalComponentPropertiesEditor propertiesEditor;
    @Inject
    ExternalComponentPresenter externalComponentPresenter;
    @Inject
    ExternalComponentMessageHelper messageHelper;
    private Map<String, String> newProperties;

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void withComponent(String componentId, Map<String, String> properties) {
        this.propertiesEditor.init(componentId, properties, this::propertiesChange);
        this.externalComponentPresenter.withComponent(componentId);
        this.propertiesChange(properties);
    }

    public void propertiesChange(Map<String, String> propertiesChange) {
        this.newProperties = propertiesChange;
        HashMap<String, String> props = new HashMap<String, String>(propertiesChange);
        ExternalComponentMessage message = this.messageHelper.newInitMessage(props);
        this.externalComponentPresenter.sendMessage(message);
    }

    public Map<String, String> getNewProperties() {
        return this.newProperties;
    }

    public ExternalComponentPresenter getExternalComponentPresenter() {
        return this.externalComponentPresenter;
    }

    public ExternalComponentPropertiesEditor getPropertiesEditor() {
        return this.propertiesEditor;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public static interface View
    extends UberView<ExternalComponentEditor> {
    }
}

