/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.inject.Inject;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

public class RendererSelector
implements IsWidget {
    View tabListView;
    View listBoxView;
    View radioListView;
    View view;
    RendererManager rendererManager;
    RendererLibrary rendererLibrary;
    Command selectCommand;

    @Inject
    public RendererSelector(TabListView tabListView, ListBoxView listBoxView, RadioListView radioListView, RendererManager rendererManager) {
        this.tabListView = tabListView;
        this.listBoxView = listBoxView;
        this.radioListView = radioListView;
        this.rendererManager = rendererManager;
        this.rendererLibrary = null;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public RendererLibrary getRendererLibrary() {
        return this.rendererLibrary;
    }

    public void init(DisplayerSettings displayerSettings, SelectorType selectorType, int width, Command onSelectCommand) {
        switch (selectorType) {
            case LIST: {
                this.view = this.listBoxView;
                break;
            }
            case RADIO: {
                this.view = this.radioListView;
                break;
            }
            case TAB: {
                this.view = this.tabListView;
            }
        }
        this.view.init(this);
        this.selectCommand = onSelectCommand;
        RendererLibrary rendererLibrary = this.rendererManager.getRendererForDisplayer(displayerSettings);
        List<RendererLibrary> renderers = this.rendererManager.getRenderersForType(displayerSettings.getType(), displayerSettings.getSubtype());
        if (renderers != null && renderers.size() > 1) {
            this.view.setVisible(true);
            this.view.setWidth(width);
            this.view.clearRendererSelector();
            for (int i = 0; i < renderers.size(); ++i) {
                RendererLibrary rendererLib = renderers.get(i);
                this.view.addRendererItem(rendererLib.getName());
                if (rendererLibrary == null || !rendererLib.equals(rendererLibrary)) continue;
                this.view.setSelectedRendererIndex(i);
            }
        } else {
            this.view.setVisible(false);
        }
    }

    void onRendererSelected() {
        if (this.view.getRendererSelected() != null) {
            this.rendererLibrary = this.rendererManager.getRendererByName(this.view.getRendererSelected());
            this.selectCommand.execute();
        }
    }

    public static interface RadioListView
    extends View {
    }

    public static interface ListBoxView
    extends View {
    }

    public static interface TabListView
    extends View {
    }

    public static interface View
    extends UberView<RendererSelector> {
        public void setVisible(boolean var1);

        public void setWidth(int var1);

        public void setHeight(int var1);

        public void clearRendererSelector();

        public void addRendererItem(String var1);

        public void setSelectedRendererIndex(int var1);

        public String getRendererSelected();
    }

    public static enum SelectorType {
        LIST,
        RADIO,
        TAB;

    }
}

