/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.factory.navigation;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.dashbuilder.dsl.model.NavigationGroup;
import org.dashbuilder.dsl.model.NavigationItem;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.impl.NavGroupImpl;

public class NavigationGroupBuilder {
    private NavGroup navGroup;

    private NavigationGroupBuilder(NavGroup navGroup) {
        this.navGroup = navGroup;
    }

    public static NavigationGroupBuilder newBuilder(String name, NavigationItem ... items) {
        NavGroupImpl group = new NavGroupImpl();
        List navItems = Arrays.stream(items).map(NavigationItem::getNavItem).collect(Collectors.toList());
        group.setName(name);
        group.setDescription("Some Group");
        group.setId(System.currentTimeMillis() + "");
        group.setChildren(navItems);
        group.setModifiable(false);
        return new NavigationGroupBuilder((NavGroup)group);
    }

    public NavigationGroupBuilder name(String name) {
        this.navGroup.setName(name);
        return this;
    }

    public NavigationGroupBuilder item(NavigationItem item) {
        this.navGroup.getChildren().add(item.getNavItem());
        return this;
    }

    public NavigationGroup build() {
        return NavigationGroup.of(this.navGroup);
    }
}

