/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.navigation.layout;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.layout.LayoutNavigationRef;
import org.dashbuilder.navigation.layout.LayoutNavigationRefType;
import org.dashbuilder.navigation.layout.LayoutRecursionIssueI18n;
import org.dashbuilder.navigation.layout.NavDragComponentType;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class LayoutRecursionIssue {
    List<LayoutNavigationRef> refList = new ArrayList<LayoutNavigationRef>();

    public boolean contains(LayoutNavigationRef other) {
        if (other != null) {
            for (LayoutNavigationRef ref : this.refList) {
                if (ref.getType() == null || !ref.getType().equals((Object)other.getType()) || ref.getName() == null || !ref.getName().equals(other.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void push(LayoutNavigationRef ref) {
        this.refList.add(ref);
    }

    public LayoutNavigationRef pop() {
        return this.refList.remove(this.refList.size() - 1);
    }

    public boolean isEmpty() {
        return this.refList.isEmpty();
    }

    public List<LayoutNavigationRef> getRefList() {
        return this.refList;
    }

    public LayoutNavigationRef getLastDefaultItemRef() {
        for (LayoutNavigationRef ref : this.refList) {
            if (!ref.getType().equals((Object)LayoutNavigationRefType.DEFAULT_ITEM_FOUND) && !ref.getType().equals((Object)LayoutNavigationRefType.DEFAULT_ITEM_DEFINED)) continue;
            return ref;
        }
        return null;
    }

    public String printReport(NavTree navTree, LayoutRecursionIssueI18n i18n) {
        String msg = "";
        LayoutNavigationRef previousRef = null;
        for (int i = 0; i < this.refList.size(); ++i) {
            LayoutNavigationRef navigationRef = this.refList.get(i);
            boolean isLast = i == this.refList.size() - 1;
            String name = navigationRef.getName();
            switch (navigationRef.getType()) {
                case PERSPECTIVE: {
                    String perspective = this.enclose(name);
                    if (previousRef == null) {
                        msg = msg + " " + i18n.navRefPerspectiveI18n(perspective);
                        break;
                    }
                    String lastMsg = isLast ? perspective + " " + i18n.navRefPerspectiveRecursionEndI18n() : perspective;
                    switch (previousRef.getType()) {
                        case NAV_GROUP_DEFINED: {
                            msg = msg + " " + i18n.navRefPerspectiveInGroupI18n(lastMsg);
                            break;
                        }
                        case DEFAULT_ITEM_DEFINED: {
                            msg = msg + " " + i18n.navRefPerspectiveDefaultI18n(lastMsg);
                            msg = msg + (isLast ? "" : " " + i18n.navRefPerspectiveI18n(perspective));
                            break;
                        }
                        case DEFAULT_ITEM_FOUND: {
                            msg = msg + " " + i18n.navRefPerspectiveFoundI18n(lastMsg);
                            msg = msg + (isLast ? "" : " " + i18n.navRefPerspectiveI18n(perspective));
                        }
                    }
                    break;
                }
                case NAV_GROUP_DEFINED: {
                    NavItem navGroup = navTree.getItemById(name);
                    msg = msg + " " + i18n.navRefGroupDefinedI18n(this.enclose(navGroup.getName()));
                    break;
                }
                case NAV_GROUP_CONTEXT: {
                    NavItem navGroup = navTree.getItemById(name);
                    msg = msg + " " + i18n.navRefGroupContextI18n(this.enclose(navGroup.getName()));
                    break;
                }
                case NAV_COMPONENT: {
                    NavDragComponentType dragType = NavDragComponentType.getByClassName(name);
                    String dragName = dragType != null ? this.getNavDragTypeI18nName(dragType, i18n) : name;
                    msg = msg + " " + i18n.navRefComponentI18n(this.enclose(dragName));
                    break;
                }
                case DEFAULT_ITEM_DEFINED: {
                    NavItem navItem = navTree.getItemById(name);
                    msg = msg + " " + i18n.navRefDefaultItemDefinedI18n(this.enclose(navItem.getName()));
                    break;
                }
                case DEFAULT_ITEM_FOUND: {
                    NavItem navItem = navTree.getItemById(name);
                    msg = msg + " " + i18n.navRefDefaultItemFoundI18n(this.enclose(navItem.getName()));
                    break;
                }
                default: {
                    msg = msg + " " + (Object)((Object)navigationRef.getType()) + " " + navigationRef.getName();
                }
            }
            previousRef = navigationRef;
        }
        return msg;
    }

    private String enclose(String name) {
        return "\"" + name + "\"";
    }

    public String getNavDragTypeI18nName(NavDragComponentType dragType, LayoutRecursionIssueI18n i18n) {
        switch (dragType) {
            case CAROUSEL: {
                return i18n.navCarouselDragComponentI18n();
            }
            case TABLIST: {
                return i18n.navTabListDragComponentI18n();
            }
            case TILES: {
                return i18n.navTilesDragComponentI18n();
            }
            case TREE: {
                return i18n.navTreeDragComponentI18n();
            }
            case MENUBAR: {
                return i18n.navMenubarDragComponentI18n();
            }
        }
        return null;
    }
}

