/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.renderer.lienzo.client;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.client.AbstractGwtDisplayer;

public abstract class LienzoDisplayer<V extends View>
extends AbstractGwtDisplayer<V> {
    protected void createVisualization() {
        if (this.displayerSettings.isTitleVisible()) {
            ((View)this.getView()).showTitle(this.displayerSettings.getTitle());
        }
        ((View)this.getView()).setSubType(this.displayerSettings.getSubtype());
        ((View)this.getView()).setWidth(this.getChartWidth());
        ((View)this.getView()).setHeight(this.getChartHeight());
        ((View)this.getView()).setMarginLeft(this.displayerSettings.getChartMarginLeft());
        ((View)this.getView()).setMarginRight(this.displayerSettings.getChartMarginRight());
        ((View)this.getView()).setMarginTop(this.displayerSettings.getChartMarginTop());
        ((View)this.getView()).setMarginBottom(this.displayerSettings.getChartMarginBottom());
        ((View)this.getView()).setFontFamily("Verdana");
        ((View)this.getView()).setFontStyle("bold");
        ((View)this.getView()).setFontSize(8);
        ((View)this.getView()).setResizeEnabled(this.displayerSettings.isResizable());
        ((View)this.getView()).setFilterEnabled(this.displayerSettings.isFilterEnabled());
        if (this.dataSet.getRowCount() == 0) {
            ((View)this.getView()).nodata();
        } else {
            this.pushDataToView();
            ((View)this.getView()).drawChart();
        }
    }

    protected void updateVisualization() {
        this.updateFilterStatus();
        if (this.dataSet.getRowCount() == 0) {
            ((View)this.getView()).nodata();
        } else {
            this.pushDataToView();
            ((View)this.getView()).reloadChart();
        }
    }

    protected void updateFilterStatus() {
        ((View)this.getView()).clearFilterStatus();
        Set columnFilters = this.filterColumns();
        if (this.displayerSettings.isFilterEnabled() && !columnFilters.isEmpty()) {
            for (String columnId : columnFilters) {
                List selectedValues = this.filterIntervals(columnId);
                DataColumn column = this.dataSet.getColumnById(columnId);
                for (Interval interval : selectedValues) {
                    String formattedValue = this.formatInterval(interval, column);
                    ((View)this.getView()).addFilterValue(formattedValue);
                }
            }
            ((View)this.getView()).addFilterReset();
        }
    }

    protected void pushDataToView() {
        ((View)this.getView()).dataClear();
        List columns = this.dataSet.getColumns();
        if (columns != null && !columns.isEmpty()) {
            for (int i = 0; i < columns.size(); ++i) {
                DataColumn dataColumn = (DataColumn)columns.get(i);
                List columnValues = dataColumn.getValues();
                ColumnType columnType = dataColumn.getColumnType();
                String columnId = dataColumn.getId();
                ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(dataColumn);
                String columnName = columnSettings.getColumnName();
                ((View)this.getView()).dataAddColumn(columnId, columnName, dataColumn.getColumnType());
                for (int j = 0; j < columnValues.size(); ++j) {
                    Object value = columnValues.get(j);
                    if (ColumnType.LABEL.equals((Object)columnType)) {
                        value = super.formatValue(j, i);
                    }
                    if (ColumnType.DATE.equals((Object)columnType)) {
                        ((View)this.getView()).dataAddValue(columnId, value == null ? new Date() : (Date)value);
                        continue;
                    }
                    if (ColumnType.NUMBER.equals((Object)columnType)) {
                        ((View)this.getView()).dataAddValue(columnId, value == null ? 0.0 : Double.parseDouble(value.toString()));
                        continue;
                    }
                    ((View)this.getView()).dataAddValue(columnId, value.toString());
                }
            }
        }
    }

    public int getChartWidth() {
        return this.displayerSettings.getChartWidth();
    }

    public int getChartHeight() {
        return this.displayerSettings.getChartHeight();
    }

    public int getWidth() {
        int width = this.displayerSettings.isResizable() ? this.displayerSettings.getChartMaxWidth() : this.displayerSettings.getChartWidth();
        int left = this.displayerSettings.getChartMarginLeft();
        int right = this.displayerSettings.getChartMarginRight();
        return this.displayerSettings.getChartWidth() + right + left;
    }

    public int getHeight() {
        int height = this.displayerSettings.isResizable() ? this.displayerSettings.getChartMaxHeight() : this.displayerSettings.getChartHeight();
        int top = this.displayerSettings.getChartMarginTop();
        int bottom = this.displayerSettings.getChartMarginBottom();
        return this.displayerSettings.getChartHeight() + top + bottom;
    }

    void onCategorySelected(String columnId, int row) {
        Integer maxSelections = this.displayerSettings.isFilterSelfApplyEnabled() ? null : Integer.valueOf(this.dataSet.getRowCount());
        this.filterUpdate(columnId, row, maxSelections);
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    void onFilterResetClicked() {
        this.filterReset();
        if (!this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.updateVisualization();
        }
    }

    public static interface View<P extends LienzoDisplayer>
    extends AbstractGwtDisplayer.View<P> {
        public void showTitle(String var1);

        public void setWidth(int var1);

        public void setHeight(int var1);

        public void setMarginTop(int var1);

        public void setMarginBottom(int var1);

        public void setMarginRight(int var1);

        public void setMarginLeft(int var1);

        public void setSubType(DisplayerSubType var1);

        public void setFilterEnabled(boolean var1);

        public void setResizeEnabled(boolean var1);

        public void setFontFamily(String var1);

        public void setFontStyle(String var1);

        public void setFontSize(int var1);

        public String getGroupsTitle();

        public String getColumnsTitle();

        public void dataClear();

        public void dataAddColumn(String var1, String var2, ColumnType var3);

        public void dataAddValue(String var1, Date var2);

        public void dataAddValue(String var1, Number var2);

        public void dataAddValue(String var1, String var2);

        public void clearFilterStatus();

        public void addFilterValue(String var1);

        public void addFilterReset();

        public void nodata();

        public void drawChart();

        public void reloadChart();
    }
}

