/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.validations.dataset;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.validation.Validator;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.validation.groups.DataSetDefBasicAttributesGroup;
import org.dashbuilder.dataset.validation.groups.DataSetDefCacheRowsValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefProviderTypeGroup;
import org.dashbuilder.dataset.validation.groups.DataSetDefPushSizeValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefRefreshIntervalValidation;
import org.dashbuilder.dataset.validation.groups.ElasticSearchDataSetDefValidation;
import org.dashbuilder.validations.dataset.AbstractValidationTest;
import org.dashbuilder.validations.dataset.ElasticSearchDataSetDefValidator;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ElasticSearchDataSetDefValidatorTest
extends AbstractValidationTest {
    @Mock
    ElasticSearchDataSetDef elasticSearchDataSetDef;
    private ElasticSearchDataSetDefValidator tested;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.tested = (ElasticSearchDataSetDefValidator)Mockito.spy((Object)new ElasticSearchDataSetDefValidator());
        ((ElasticSearchDataSetDefValidator)Mockito.doReturn((Object)this.validator).when((Object)this.tested)).getDashbuilderValidator();
    }

    @Test
    public void testValidateAttributes() {
        this.tested.validateAttributes(this.elasticSearchDataSetDef, new Object[0]);
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.elasticSearchDataSetDef, new Class[]{ElasticSearchDataSetDefValidation.class});
    }

    @Test
    public void testValidate() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = true;
        this.tested.validate(this.elasticSearchDataSetDef, true, true, true, new Object[0]);
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.elasticSearchDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefPushSizeValidation.class, DataSetDefRefreshIntervalValidation.class, ElasticSearchDataSetDefValidation.class});
    }

    @Test
    public void testValidateNoCache() {
        boolean isCacheEnabled = false;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = true;
        this.tested.validate(this.elasticSearchDataSetDef, false, true, true, new Object[0]);
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.elasticSearchDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefPushSizeValidation.class, DataSetDefRefreshIntervalValidation.class, ElasticSearchDataSetDefValidation.class});
    }

    @Test
    public void testValidateNoPush() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = false;
        boolean isRefreshEnabled = true;
        this.tested.validate(this.elasticSearchDataSetDef, true, false, true, new Object[0]);
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.elasticSearchDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefRefreshIntervalValidation.class, ElasticSearchDataSetDefValidation.class});
    }

    @Test
    public void testValidateNoRefresh() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = false;
        this.tested.validate(this.elasticSearchDataSetDef, true, true, false, new Object[0]);
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.elasticSearchDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefPushSizeValidation.class, ElasticSearchDataSetDefValidation.class});
    }
}

