/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.validations.dataset;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.validation.Validator;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.validation.groups.DataSetDefBasicAttributesGroup;
import org.dashbuilder.dataset.validation.groups.DataSetDefCacheRowsValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefProviderTypeGroup;
import org.dashbuilder.dataset.validation.groups.DataSetDefPushSizeValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefRefreshIntervalValidation;
import org.dashbuilder.dataset.validation.groups.SQLDataSetDefDbSQLValidation;
import org.dashbuilder.dataset.validation.groups.SQLDataSetDefDbTableValidation;
import org.dashbuilder.dataset.validation.groups.SQLDataSetDefValidation;
import org.dashbuilder.validations.dataset.AbstractValidationTest;
import org.dashbuilder.validations.dataset.SQLDataSetDefValidator;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class SQLDataSetDefValidatorTest
extends AbstractValidationTest {
    @Mock
    SQLDataSetDef sqlDataSetDef;
    private SQLDataSetDefValidator tested;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.tested = (SQLDataSetDefValidator)Mockito.spy((Object)new SQLDataSetDefValidator());
        ((SQLDataSetDefValidator)Mockito.doReturn((Object)this.validator).when((Object)this.tested)).getDashbuilderValidator();
    }

    @Test
    public void testValidateAttributesUsingQuery() {
        boolean isUsingQuery = true;
        this.tested.validateAttributes(this.sqlDataSetDef, new Object[]{true});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.sqlDataSetDef, new Class[]{SQLDataSetDefValidation.class, SQLDataSetDefDbSQLValidation.class});
    }

    @Test
    public void testValidateAttributesUsingTable() {
        boolean isUsingQuery = false;
        this.tested.validateAttributes(this.sqlDataSetDef, new Object[]{false});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.sqlDataSetDef, new Class[]{SQLDataSetDefValidation.class, SQLDataSetDefDbTableValidation.class});
    }

    @Test
    public void testValidateUsingQuery() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = true;
        boolean isUsingQuery = true;
        this.tested.validate(this.sqlDataSetDef, true, true, true, new Object[]{true});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.sqlDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefPushSizeValidation.class, DataSetDefRefreshIntervalValidation.class, SQLDataSetDefValidation.class, SQLDataSetDefDbSQLValidation.class});
    }

    @Test
    public void testValidateUsingTable() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = true;
        boolean isUsingQuery = false;
        this.tested.validate(this.sqlDataSetDef, true, true, true, new Object[]{false});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.sqlDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefPushSizeValidation.class, DataSetDefRefreshIntervalValidation.class, SQLDataSetDefValidation.class, SQLDataSetDefDbTableValidation.class});
    }

    @Test
    public void testValidateNoCache() {
        boolean isCacheEnabled = false;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = true;
        boolean isUsingQuery = false;
        this.tested.validate(this.sqlDataSetDef, false, true, true, new Object[]{false});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.sqlDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefPushSizeValidation.class, DataSetDefRefreshIntervalValidation.class, SQLDataSetDefValidation.class, SQLDataSetDefDbTableValidation.class});
    }

    @Test
    public void testValidateNoPush() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = false;
        boolean isRefreshEnabled = true;
        boolean isUsingQuery = false;
        this.tested.validate(this.sqlDataSetDef, true, false, true, new Object[]{false});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.sqlDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefRefreshIntervalValidation.class, SQLDataSetDefValidation.class, SQLDataSetDefDbTableValidation.class});
    }

    @Test
    public void testValidateNoRefresh() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = false;
        boolean isUsingQuery = false;
        this.tested.validate(this.sqlDataSetDef, true, true, false, new Object[]{false});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.sqlDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefPushSizeValidation.class, SQLDataSetDefValidation.class, SQLDataSetDefDbTableValidation.class});
    }
}

