/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.validations.dataset;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.validation.Validator;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.validation.groups.BeanDataSetDefValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefBasicAttributesGroup;
import org.dashbuilder.dataset.validation.groups.DataSetDefCacheRowsValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefProviderTypeGroup;
import org.dashbuilder.dataset.validation.groups.DataSetDefPushSizeValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefRefreshIntervalValidation;
import org.dashbuilder.validations.dataset.AbstractValidationTest;
import org.dashbuilder.validations.dataset.BeanDataSetDefValidator;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class BeanDataSetDefValidatorTest
extends AbstractValidationTest {
    @Mock
    BeanDataSetDef beanDataSetDef;
    private BeanDataSetDefValidator tested;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.tested = (BeanDataSetDefValidator)Mockito.spy((Object)new BeanDataSetDefValidator(this.validator));
    }

    @Test
    public void testValidateAttributes() {
        this.tested.validateCustomAttributes(this.beanDataSetDef, new Object[0]);
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.beanDataSetDef, new Class[]{BeanDataSetDefValidation.class});
    }

    @Test
    public void testValidate() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = true;
        this.tested.validate(this.beanDataSetDef, true, true, true, new Object[0]);
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.beanDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefPushSizeValidation.class, DataSetDefRefreshIntervalValidation.class, BeanDataSetDefValidation.class});
    }

    @Test
    public void testValidateNoCache() {
        boolean isCacheEnabled = false;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = true;
        this.tested.validate(this.beanDataSetDef, false, true, true, new Object[0]);
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.beanDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefPushSizeValidation.class, DataSetDefRefreshIntervalValidation.class, BeanDataSetDefValidation.class});
    }

    @Test
    public void testValidateNoPush() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = false;
        boolean isRefreshEnabled = true;
        this.tested.validate(this.beanDataSetDef, true, false, true, new Object[0]);
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.beanDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefRefreshIntervalValidation.class, BeanDataSetDefValidation.class});
    }

    @Test
    public void testValidateNoRefresh() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = false;
        this.tested.validate(this.beanDataSetDef, true, true, false, new Object[0]);
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.beanDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefPushSizeValidation.class, BeanDataSetDefValidation.class});
    }
}

