/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.validations.dataset;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.validation.Validator;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.validation.groups.CSVDataSetDefFilePathValidation;
import org.dashbuilder.dataset.validation.groups.CSVDataSetDefFileURLValidation;
import org.dashbuilder.dataset.validation.groups.CSVDataSetDefValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefBasicAttributesGroup;
import org.dashbuilder.dataset.validation.groups.DataSetDefCacheRowsValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefProviderTypeGroup;
import org.dashbuilder.dataset.validation.groups.DataSetDefPushSizeValidation;
import org.dashbuilder.dataset.validation.groups.DataSetDefRefreshIntervalValidation;
import org.dashbuilder.validations.dataset.AbstractValidationTest;
import org.dashbuilder.validations.dataset.CSVDataSetDefValidator;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class CSVDataSetDefValidatorTest
extends AbstractValidationTest {
    @Mock
    CSVDataSetDef csvDataSetDef;
    private CSVDataSetDefValidator tested;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.tested = (CSVDataSetDefValidator)Mockito.spy((Object)new CSVDataSetDefValidator(this.validator));
    }

    @Test
    public void testValidateAttributesUsingFilePath() {
        boolean isUsingFilePath = true;
        this.tested.validateCustomAttributes(this.csvDataSetDef, new Object[]{true});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.csvDataSetDef, new Class[]{CSVDataSetDefValidation.class, CSVDataSetDefFilePathValidation.class});
    }

    @Test
    public void testValidateAttributesUsingFileUrl() {
        boolean isUsingFilePath = false;
        this.tested.validateCustomAttributes(this.csvDataSetDef, new Object[]{false});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.csvDataSetDef, new Class[]{CSVDataSetDefValidation.class, CSVDataSetDefFileURLValidation.class});
    }

    @Test
    public void testValidateUsingFilePath() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = true;
        boolean isUsingFilePath = true;
        this.tested.validate(this.csvDataSetDef, true, true, true, new Object[]{true});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.csvDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefPushSizeValidation.class, DataSetDefRefreshIntervalValidation.class, CSVDataSetDefValidation.class, CSVDataSetDefFilePathValidation.class});
    }

    @Test
    public void testValidateUsingFileUrl() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = true;
        boolean isUsingFilePath = false;
        this.tested.validate(this.csvDataSetDef, true, true, true, new Object[]{false});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.csvDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefPushSizeValidation.class, DataSetDefRefreshIntervalValidation.class, CSVDataSetDefValidation.class, CSVDataSetDefFileURLValidation.class});
    }

    @Test
    public void testValidateNoCache() {
        boolean isCacheEnabled = false;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = true;
        boolean isUsingFilePath = false;
        this.tested.validate(this.csvDataSetDef, false, true, true, new Object[]{false});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.csvDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefPushSizeValidation.class, DataSetDefRefreshIntervalValidation.class, CSVDataSetDefValidation.class, CSVDataSetDefFileURLValidation.class});
    }

    @Test
    public void testValidateNoPush() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = false;
        boolean isRefreshEnabled = true;
        boolean isUsingFilePath = false;
        this.tested.validate(this.csvDataSetDef, true, false, true, new Object[]{false});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.csvDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefRefreshIntervalValidation.class, CSVDataSetDefValidation.class, CSVDataSetDefFileURLValidation.class});
    }

    @Test
    public void testValidateNoRefresh() {
        boolean isCacheEnabled = true;
        boolean isPushEnabled = true;
        boolean isRefreshEnabled = false;
        boolean isUsingFilePath = false;
        this.tested.validate(this.csvDataSetDef, true, true, false, new Object[]{false});
        ((Validator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)1))).validate((Object)this.csvDataSetDef, new Class[]{DataSetDefBasicAttributesGroup.class, DataSetDefProviderTypeGroup.class, DataSetDefCacheRowsValidation.class, DataSetDefPushSizeValidation.class, CSVDataSetDefValidation.class, CSVDataSetDefFileURLValidation.class});
    }
}

