/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.security;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.authz.AuthorizationPolicyStorage;
import org.uberfire.backend.events.AuthorizationPolicyDeployedEvent;
import org.uberfire.backend.server.authz.AuthorizationPolicyDeployer;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionCollection;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionManager;

@RunWith(value=MockitoJUnitRunner.class)
public class SecurityPolicyTest {
    static final String HOME_PERSPECTIVE = "HomePerspective";
    static final List<String> DEFAULT_DENIED = Arrays.asList("perspective.read", "perspective.create", "perspective.delete", "perspective.update");
    @Mock
    AuthorizationPolicyStorage storage;
    @Mock
    Event<AuthorizationPolicyDeployedEvent> deployedEvent;
    AuthorizationPolicyDeployer deployer;
    PermissionManager permissionManager;
    AuthorizationPolicy policy;

    @Before
    public void setUp() throws Exception {
        this.permissionManager = new DefaultPermissionManager();
        this.deployer = new AuthorizationPolicyDeployer(this.storage, this.permissionManager, this.deployedEvent);
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("security-policy.properties");
        Path policyDir = Paths.get(fileURL.toURI()).getParent();
        this.deployer.deployPolicy(policyDir);
        ArgumentCaptor policyCaptor = ArgumentCaptor.forClass(AuthorizationPolicy.class);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).loadPolicy();
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).savePolicy((AuthorizationPolicy)policyCaptor.capture());
        this.policy = (AuthorizationPolicy)policyCaptor.getValue();
    }

    @Test
    public void testPolicyDeployment() {
        Assert.assertNotNull((Object)this.policy);
        Assert.assertEquals((long)this.policy.getRoles().size(), (long)1L);
        ((AuthorizationPolicyStorage)Mockito.verify((Object)this.storage)).savePolicy(this.policy);
        ((Event)Mockito.verify(this.deployedEvent)).fire(Matchers.any());
    }

    @Test
    public void testDefaultPermissions() {
        Assert.assertEquals((Object)this.policy.getHomePerspective(), (Object)HOME_PERSPECTIVE);
        PermissionCollection pc = this.policy.getPermissions();
        for (String permissionName : DEFAULT_DENIED) {
            Permission p = pc.get(permissionName);
            Assert.assertNotNull((Object)p);
            Assert.assertEquals((Object)p.getResult(), (Object)AuthorizationResult.ACCESS_DENIED);
        }
    }

    @Test
    public void testAdminPermissions() {
        this.testPermissions((Role)new RoleImpl("admin"), null, HOME_PERSPECTIVE, AuthorizationResult.ACCESS_GRANTED, null);
    }

    public void testPermissions(Role role, List<String> exceptionList, String homeExpected, AuthorizationResult defaultExpected, AuthorizationResult exceptionExpected) {
        Permission p;
        Assert.assertEquals((Object)(role != null ? this.policy.getHomePerspective(role) : this.policy.getHomePerspective()), (Object)homeExpected);
        PermissionCollection pc = this.policy.getPermissions(role);
        for (String permissionName : DEFAULT_DENIED) {
            if (exceptionList != null && exceptionList.contains(permissionName)) continue;
            p = pc.get(permissionName);
            Assert.assertNotNull((Object)p);
            Assert.assertEquals((Object)p.getResult(), (Object)defaultExpected);
        }
        if (exceptionList != null) {
            for (String permissionName : exceptionList) {
                p = pc.get(permissionName);
                Assert.assertNotNull((Object)p);
                Assert.assertEquals((Object)p.getResult(), (Object)exceptionExpected);
            }
        }
    }
}

