/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.attributes;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefRefreshIntervalEditor;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.editor.ToggleSwitchEditor;
import org.dashbuilder.dataset.def.DataSetDef;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

@Dependent
public class DataSetDefRefreshAttributesEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.DataSetDefRefreshAttributesEditor {
    ToggleSwitchEditor refreshAlways;
    DataSetDefRefreshIntervalEditor refreshTime;
    public View view;
    boolean isRefreshEnabled;
    final Command refreshEnabledButtonHandler = new Command(){

        public void execute() {
            DataSetDefRefreshAttributesEditor.this.setRefreshEnabled(!DataSetDefRefreshAttributesEditor.this.isRefreshEnabled);
        }
    };

    @Inject
    public DataSetDefRefreshAttributesEditor(ToggleSwitchEditor refreshAlways, DataSetDefRefreshIntervalEditor refreshTime, View view) {
        this.refreshAlways = refreshAlways;
        this.refreshTime = refreshTime;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.initWidgets((IsWidget)this.refreshAlways.asWidget(), this.refreshTime.view);
        this.view.addRefreshEnabledButtonHandler(this.refreshEnabledButtonHandler);
        this.refreshTime.addHelpContent(DataSetEditorConstants.INSTANCE.attributeRefreshInterval(), DataSetEditorConstants.INSTANCE.attributeRefreshInterval_description(), Placement.RIGHT);
    }

    public boolean isRefreshEnabled() {
        return this.isRefreshEnabled;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public ToggleSwitchEditor refreshAlways() {
        return this.refreshAlways;
    }

    public DataSetDefRefreshIntervalEditor refreshTime() {
        return this.refreshTime;
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setValue(DataSetDef value) {
        String rTime = value != null ? value.getRefreshTime() : null;
        this.setRefreshEnabled(rTime != null);
    }

    public void setDelegate(EditorDelegate<DataSetDef> delegate) {
    }

    private void setRefreshEnabled(boolean refreshEnabled) {
        this.isRefreshEnabled = refreshEnabled;
        this.view.setEnabled(refreshEnabled);
        this.refreshTime.setEnabled(refreshEnabled);
        this.refreshAlways.setEnabled(refreshEnabled);
    }

    public static interface View
    extends UberView<DataSetDefRefreshAttributesEditor> {
        public void initWidgets(IsWidget var1, DataSetDefRefreshIntervalEditor.View var2);

        public void addRefreshEnabledButtonHandler(Command var1);

        public void setEnabled(boolean var1);
    }
}

