/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.databene.commons.ArrayFormat;
import org.databene.commons.Assert;
import org.databene.commons.Context;
import org.databene.commons.StringUtil;
import org.databene.commons.SyntaxError;
import org.databene.script.Assignment;
import org.databene.script.BeanSpec;
import org.databene.script.Expression;
import org.databene.script.PrimitiveType;
import org.databene.script.QNBeanSpecExpression;
import org.databene.script.QNExpression;
import org.databene.script.QNInvocationExpression;
import org.databene.script.WeightedSample;
import org.databene.script.WeightedTransition;
import org.databene.script.antlr.DatabeneScriptLexer;
import org.databene.script.antlr.DatabeneScriptParser;
import org.databene.script.expression.AssignmentExpression;
import org.databene.script.expression.BeanConstruction;
import org.databene.script.expression.BitwiseAndExpression;
import org.databene.script.expression.BitwiseComplementExpression;
import org.databene.script.expression.BitwiseExclusiveOrExpression;
import org.databene.script.expression.BitwiseOrExpression;
import org.databene.script.expression.ConditionalAndExpression;
import org.databene.script.expression.ConditionalExpression;
import org.databene.script.expression.ConditionalOrExpression;
import org.databene.script.expression.ConstantExpression;
import org.databene.script.expression.DivisionExpression;
import org.databene.script.expression.EqualsExpression;
import org.databene.script.expression.FieldExpression;
import org.databene.script.expression.ForNameExpression;
import org.databene.script.expression.GreaterExpression;
import org.databene.script.expression.GreaterOrEqualsExpression;
import org.databene.script.expression.IndexExpression;
import org.databene.script.expression.InvocationExpression;
import org.databene.script.expression.LeftShiftExpression;
import org.databene.script.expression.LessExpression;
import org.databene.script.expression.LessOrEqualsExpression;
import org.databene.script.expression.LogicalComplementExpression;
import org.databene.script.expression.ModuloExpression;
import org.databene.script.expression.MultiplicationExpression;
import org.databene.script.expression.NotEqualsExpression;
import org.databene.script.expression.ParameterizedConstruction;
import org.databene.script.expression.RightShiftExpression;
import org.databene.script.expression.SubtractionExpression;
import org.databene.script.expression.SumExpression;
import org.databene.script.expression.TypeConvertingExpression;
import org.databene.script.expression.UnaryMinusExpression;
import org.databene.script.expression.UnsignedRightShiftExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabeneScriptParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabeneScriptParser.class);
    private static final Expression<?>[] EMPTY_ARGUMENT_LIST = new Expression[0];

    public static WeightedSample<?>[] parseWeightedLiteralList(String text) throws SyntaxError {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return new WeightedSample[0];
        }
        try {
            org.databene.script.antlr.DatabeneScriptParser parser = DatabeneScriptParser.parser(text);
            DatabeneScriptParser.weightedLiteralList_return r = parser.weightedLiteralList();
            DatabeneScriptParser.checkForSyntaxErrors(text, "weightedLiteralList", parser, r);
            if (r != null) {
                CommonTree tree = (CommonTree)r.getTree();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("parsed " + text + " to " + tree.toStringTree());
                }
                return DatabeneScriptParser.convertWeightedLiteralList(tree);
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw DatabeneScriptParser.mapToSyntaxError((RecognitionException)e.getCause(), text);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Encountered illegal state in weightedLiteralList parsing", e);
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw DatabeneScriptParser.mapToSyntaxError(e, text);
        }
    }

    public static Expression<?> parseExpression(String text) throws SyntaxError {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            org.databene.script.antlr.DatabeneScriptParser parser = DatabeneScriptParser.parser(text);
            DatabeneScriptParser.expression_return r = parser.expression();
            DatabeneScriptParser.checkForSyntaxErrors(text, "expression", parser, r);
            CommonTree tree = (CommonTree)r.getTree();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("parsed " + text + " to " + tree.toStringTree());
            }
            return DatabeneScriptParser.convertNode(tree);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw DatabeneScriptParser.mapToSyntaxError((RecognitionException)e.getCause(), text);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Encountered illegal state in regex parsing", e);
        }
        catch (RecognitionException e) {
            throw DatabeneScriptParser.mapToSyntaxError(e, text);
        }
    }

    public static WeightedTransition[] parseTransitionList(String text) throws SyntaxError {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            org.databene.script.antlr.DatabeneScriptParser parser = DatabeneScriptParser.parser(text);
            DatabeneScriptParser.transitionList_return r = parser.transitionList();
            DatabeneScriptParser.checkForSyntaxErrors(text, "transitionList", parser, r);
            if (r != null) {
                CommonTree tree = (CommonTree)r.getTree();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("parsed " + text + " to " + tree.toStringTree());
                }
                return DatabeneScriptParser.convertTransitionList(tree);
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw DatabeneScriptParser.mapToSyntaxError((RecognitionException)e.getCause(), text);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Encountered illegal state in regex parsing", e);
        }
        catch (RecognitionException e) {
            e.printStackTrace();
            throw DatabeneScriptParser.mapToSyntaxError(e, text);
        }
    }

    public static Expression<?>[] parseBeanSpecList(String text) throws SyntaxError {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        CommonTree tree = DatabeneScriptParser.parseBeanSpecListAsTree(text);
        return DatabeneScriptParser.convertBeanSpecList(tree);
    }

    public static CommonTree parseBeanSpecListAsTree(String text) throws SyntaxError {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            org.databene.script.antlr.DatabeneScriptParser parser = DatabeneScriptParser.parser(text);
            DatabeneScriptParser.beanSpecList_return r = parser.beanSpecList();
            DatabeneScriptParser.checkForSyntaxErrors(text, "beanSpecList", parser, r);
            if (r != null) {
                CommonTree tree = (CommonTree)r.getTree();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("parsed " + text + " to " + tree.toStringTree());
                }
                return tree;
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw DatabeneScriptParser.mapToSyntaxError((RecognitionException)e.getCause(), text);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Encountered illegal state in regex parsing", e);
        }
        catch (RecognitionException e) {
            throw DatabeneScriptParser.mapToSyntaxError(e, text);
        }
    }

    public static BeanSpec[] resolveBeanSpecList(String text, Context context) {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        CommonTree tree = DatabeneScriptParser.parseBeanSpecListAsTree(text);
        return DatabeneScriptParser.resolveBeanSpecList(tree, context);
    }

    public static Expression<?> parseBeanSpec(String text) throws SyntaxError {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            org.databene.script.antlr.DatabeneScriptParser parser = DatabeneScriptParser.parser(text);
            DatabeneScriptParser.beanSpec_return r = parser.beanSpec();
            DatabeneScriptParser.checkForSyntaxErrors(text, "beanSpec", parser, r);
            if (r != null) {
                CommonTree tree = (CommonTree)r.getTree();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("parsed " + text + " to " + tree.toStringTree());
                }
                return DatabeneScriptParser.convertBeanSpec(tree);
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw DatabeneScriptParser.mapToSyntaxError((RecognitionException)e.getCause(), text);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Encountered illegal state in regex parsing", e);
        }
        catch (RecognitionException e) {
            throw DatabeneScriptParser.mapToSyntaxError(e, text);
        }
    }

    public static BeanSpec resolveBeanSpec(String text, Context context) throws SyntaxError {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            org.databene.script.antlr.DatabeneScriptParser parser = DatabeneScriptParser.parser(text);
            DatabeneScriptParser.beanSpec_return r = parser.beanSpec();
            DatabeneScriptParser.checkForSyntaxErrors(text, "beanSpec", parser, r);
            if (r != null) {
                CommonTree tree = (CommonTree)r.getTree();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("parsed " + text + " to " + tree.toStringTree());
                }
                return DatabeneScriptParser.resolveBeanSpec(tree, context);
            }
            return null;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof RecognitionException) {
                throw DatabeneScriptParser.mapToSyntaxError((RecognitionException)e.getCause(), text);
            }
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Encountered illegal state in regex parsing", e);
        }
        catch (RecognitionException e) {
            throw DatabeneScriptParser.mapToSyntaxError(e, text);
        }
    }

    private static void checkForSyntaxErrors(String text, String type, org.databene.script.antlr.DatabeneScriptParser parser, ParserRuleReturnScope r) {
        if (parser.getNumberOfSyntaxErrors() > 0) {
            throw new SyntaxError("Illegal " + type, text, -1, -1);
        }
        CommonToken stop = (CommonToken)r.stop;
        if (stop.getStopIndex() < StringUtil.trimRight((String)text).length() - 1) {
            if (stop.getStopIndex() == 0) {
                throw new SyntaxError("Syntax error after " + stop.getText(), text);
            }
            throw new SyntaxError("Unspecific syntax error", text);
        }
    }

    private static org.databene.script.antlr.DatabeneScriptParser parser(String text) throws IOException {
        DatabeneScriptLexer lex = new DatabeneScriptLexer((CharStream)new ANTLRReaderStream((Reader)new StringReader(text)));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        return new org.databene.script.antlr.DatabeneScriptParser((TokenStream)tokens);
    }

    private static SyntaxError mapToSyntaxError(RecognitionException cause, String text) {
        return new SyntaxError("Error parsing Benerator Script expression", (Throwable)cause, text, cause.line, cause.charPositionInLine);
    }

    private static WeightedSample<?>[] convertWeightedLiteralList(CommonTree node) throws SyntaxError {
        if (!node.isNil()) {
            return new WeightedSample[]{DatabeneScriptParser.convertWeightedLiteral(node)};
        }
        int childCount = node.getChildCount();
        WeightedSample[] transitions = new WeightedSample[childCount];
        for (int i = 0; i < childCount; ++i) {
            transitions[i] = DatabeneScriptParser.convertWeightedLiteral(DatabeneScriptParser.childAt(i, node));
        }
        return transitions;
    }

    private static WeightedSample<?> convertWeightedLiteral(CommonTree node) throws SyntaxError {
        if (node.getType() == 52) {
            Expression<?> value = DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node));
            Expression<Double> weight = null;
            weight = node.getChildCount() > 1 ? new TypeConvertingExpression<Double>(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)), Double.class) : new ConstantExpression<Double>(1.0);
            return new WeightedSample(value.evaluate(null), weight.evaluate(null));
        }
        return new WeightedSample(DatabeneScriptParser.convertNode(node).evaluate(null), 1.0);
    }

    private static WeightedTransition[] convertTransitionList(CommonTree node) throws SyntaxError {
        if (node.getType() == 63) {
            return new WeightedTransition[]{DatabeneScriptParser.convertTransition(node)};
        }
        if (node.isNil()) {
            int childCount = node.getChildCount();
            WeightedTransition[] transitions = new WeightedTransition[childCount];
            for (int i = 0; i < childCount; ++i) {
                transitions[i] = DatabeneScriptParser.convertTransition(DatabeneScriptParser.childAt(i, node));
            }
            return transitions;
        }
        throw new SyntaxError("Unexpected token in transition list: ", node.getToken().getText(), node.getLine(), node.getCharPositionInLine());
    }

    private static WeightedTransition convertTransition(CommonTree node) throws SyntaxError {
        Assert.isTrue((node.getType() == 63 ? 1 : 0) != 0, (String)("expected transition, found: " + node.getToken()));
        Expression<?> from = DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node));
        Expression<?> to = DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node));
        Expression<Double> weight = node.getChildCount() > 2 ? new TypeConvertingExpression<Double>(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(2, node)), Double.class) : new ConstantExpression<Double>(1.0);
        return new WeightedTransition(from.evaluate(null), to.evaluate(null), weight.evaluate(null));
    }

    private static Expression<?>[] convertBeanSpecList(CommonTree node) throws SyntaxError {
        if (node.getType() == 21) {
            return new Expression[]{DatabeneScriptParser.convertBeanSpec(node)};
        }
        if (node.isNil()) {
            int childCount = node.getChildCount();
            Expression[] specs = new Expression[childCount];
            for (int i = 0; i < childCount; ++i) {
                specs[i] = DatabeneScriptParser.convertBeanSpec(DatabeneScriptParser.childAt(i, node));
            }
            return specs;
        }
        throw new SyntaxError("Unexpected token", node.getToken().getText(), node.getLine(), node.getCharPositionInLine());
    }

    private static BeanSpec[] resolveBeanSpecList(CommonTree node, Context context) throws SyntaxError {
        if (node.getType() == 21) {
            return new BeanSpec[]{DatabeneScriptParser.resolveBeanSpec(node, context)};
        }
        if (node.isNil()) {
            int childCount = node.getChildCount();
            BeanSpec[] specs = new BeanSpec[childCount];
            for (int i = 0; i < childCount; ++i) {
                specs[i] = DatabeneScriptParser.resolveBeanSpec(DatabeneScriptParser.childAt(i, node), context);
            }
            return specs;
        }
        throw new SyntaxError("Unexpected token", node.getToken().getText(), node.getLine(), node.getCharPositionInLine());
    }

    private static Expression<?> convertBeanSpec(CommonTree node) throws SyntaxError {
        Assert.isTrue((node.getType() == 21 ? 1 : 0) != 0, (String)("BEANSPEC expected, found: " + node.getToken()));
        node = DatabeneScriptParser.childAt(0, node);
        if (node.getType() == 19) {
            return new QNBeanSpecExpression(DatabeneScriptParser.convertQualifiedNameToStringArray(node));
        }
        if (node.getType() == 4) {
            return new QNBeanSpecExpression(new String[]{node.getText()});
        }
        if (node.getType() == 20) {
            return DatabeneScriptParser.convertBean(node);
        }
        return DatabeneScriptParser.convertNode(node);
    }

    private static BeanSpec resolveBeanSpec(CommonTree node, Context context) throws SyntaxError {
        Assert.isTrue((node.getType() == 21 ? 1 : 0) != 0, (String)("BEANSPEC expected, found: " + node.getToken()));
        node = DatabeneScriptParser.childAt(0, node);
        if (node.getType() == 19) {
            return new QNBeanSpecExpression(DatabeneScriptParser.convertQualifiedNameToStringArray(node)).resolve(context);
        }
        if (node.getType() == 4) {
            return new QNBeanSpecExpression(new String[]{node.getText()}).resolve(context);
        }
        if (node.getType() == 20) {
            return BeanSpec.createConstruction(DatabeneScriptParser.convertBean(node).evaluate(context));
        }
        if (node.getType() == 16) {
            return BeanSpec.createConstruction(DatabeneScriptParser.convertNode(node).evaluate(context));
        }
        return BeanSpec.createReference(DatabeneScriptParser.convertNode(node).evaluate(context));
    }

    private static Expression<?> convertNode(CommonTree node) throws SyntaxError {
        switch (node.getType()) {
            case 9: {
                return new ConstantExpression<Object>(null);
            }
            case 8: {
                return DatabeneScriptParser.convertBooleanLiteral(node);
            }
            case 5: {
                return DatabeneScriptParser.convertIntLiteral(node);
            }
            case 6: {
                return DatabeneScriptParser.convertDecimalLiteral(node);
            }
            case 7: {
                return DatabeneScriptParser.convertStringLiteral(node);
            }
            case 4: {
                return DatabeneScriptParser.convertIdentifier(node);
            }
            case 19: {
                return DatabeneScriptParser.convertQualifiedName(node);
            }
            case 10: {
                return DatabeneScriptParser.convertType(node);
            }
            case 16: {
                return DatabeneScriptParser.convertCreator(node);
            }
            case 20: {
                return DatabeneScriptParser.convertBean(node);
            }
            case 17: {
                return DatabeneScriptParser.convertInvocation(node);
            }
            case 18: {
                return DatabeneScriptParser.convertSubInvocation(node);
            }
            case 12: {
                return DatabeneScriptParser.convertIndex(node);
            }
            case 13: {
                return DatabeneScriptParser.convertField(node);
            }
            case 15: {
                return DatabeneScriptParser.convertCast(node);
            }
            case 11: {
                return DatabeneScriptParser.convertNegation(node);
            }
            case 39: {
                return DatabeneScriptParser.convertLogicalComplement(node);
            }
            case 40: {
                return DatabeneScriptParser.convertBitwiseComplement(node);
            }
            case 46: {
                return DatabeneScriptParser.convertPlus(node);
            }
            case 47: {
                return DatabeneScriptParser.convertMinus(node);
            }
            case 48: {
                return DatabeneScriptParser.convertStar(node);
            }
            case 49: {
                return DatabeneScriptParser.convertSlash(node);
            }
            case 53: {
                return DatabeneScriptParser.convertPercent(node);
            }
            case 50: {
                return DatabeneScriptParser.convertAnd(node);
            }
            case 51: {
                return DatabeneScriptParser.convertInclusiveOr(node);
            }
            case 52: {
                return DatabeneScriptParser.convertExclusiveOr(node);
            }
            case 43: {
                return DatabeneScriptParser.convertEquals(node);
            }
            case 55: {
                return DatabeneScriptParser.convertNotEquals(node);
            }
            case 61: {
                return DatabeneScriptParser.convertLess(node);
            }
            case 62: {
                return DatabeneScriptParser.convertLessOrEquals(node);
            }
            case 56: {
                return DatabeneScriptParser.convertGreater(node);
            }
            case 60: {
                return DatabeneScriptParser.convertGreaterOrEquals(node);
            }
            case 59: {
                return DatabeneScriptParser.convertShiftLeft(node);
            }
            case 57: {
                return DatabeneScriptParser.convertShiftRight(node);
            }
            case 58: {
                return DatabeneScriptParser.convertShiftRight2(node);
            }
            case 44: {
                return DatabeneScriptParser.convertConditionalAnd(node);
            }
            case 45: {
                return DatabeneScriptParser.convertConditionalOr(node);
            }
            case 41: {
                return DatabeneScriptParser.convertConditionalExpression(node);
            }
            case 38: {
                return DatabeneScriptParser.convertAssignment(node);
            }
        }
        throw new SyntaxError("Unknown token type", String.valueOf(node.getType()), node.getLine(), node.getCharPositionInLine());
    }

    private static Expression<Boolean> convertBooleanLiteral(CommonTree node) {
        return new ConstantExpression<Boolean>(Boolean.parseBoolean(node.getText()));
    }

    private static Expression<String> convertStringLiteral(CommonTree node) {
        String rawString = node.getText();
        String text = rawString.substring(1, rawString.length() - 1);
        text = StringUtil.unescape((String)text);
        return new ConstantExpression<String>(text);
    }

    private static Expression<String> convertIdentifier(CommonTree node) {
        return new ConstantExpression<String>(node.getText());
    }

    private static Expression<?> convertQualifiedName(CommonTree node) {
        return new QNExpression(DatabeneScriptParser.convertQualifiedNameToStringArray(node));
    }

    private static String[] convertQualifiedNameToStringArray(CommonTree node) {
        int childCount = node.getChildCount();
        String[] result = new String[childCount];
        List<CommonTree> childNodes = DatabeneScriptParser.getChildNodes(node);
        for (int i = 0; i < childCount; ++i) {
            result[i] = childNodes.get(i).getText();
        }
        return result;
    }

    private static Expression<Class<?>> convertType(CommonTree node) {
        Object[] classNameParts = DatabeneScriptParser.convertQualifiedNameToStringArray(DatabeneScriptParser.childAt(0, node));
        String className = ArrayFormat.format((String)".", (Object[])classNameParts);
        PrimitiveType primitiveType = PrimitiveType.getInstance(className);
        if (primitiveType != null) {
            return new ConstantExpression(primitiveType.getJavaType());
        }
        return new ForNameExpression(new ConstantExpression<String>(className));
    }

    private static Expression<? extends Number> convertIntLiteral(CommonTree node) {
        long l;
        String text = node.getText();
        Number number = null;
        number = text.length() > 10 ? (Number)Long.parseLong(text) : (Number)(text.length() == 10 ? (Number)((l = Long.parseLong(text)) <= Integer.MAX_VALUE ? (Number)((int)l) : (Number)l) : (Number)Integer.parseInt(text));
        return new ConstantExpression<Long>((Long)number);
    }

    private static Expression<Double> convertDecimalLiteral(CommonTree node) {
        return new ConstantExpression<Double>(Double.parseDouble(node.getText()));
    }

    private static Expression<?> convertCreator(CommonTree node) throws SyntaxError {
        List<CommonTree> childNodes = DatabeneScriptParser.getChildNodes(node);
        String className = DatabeneScriptParser.parseQualifiedNameOfClass(childNodes.get(0));
        Expression<?>[] params = DatabeneScriptParser.parseArguments(childNodes.get(1));
        return new ParameterizedConstruction(className, params);
    }

    private static Expression<?> convertBean(CommonTree node) throws SyntaxError {
        List<CommonTree> childNodes = DatabeneScriptParser.getChildNodes(node);
        String className = DatabeneScriptParser.parseQualifiedNameOfClass(childNodes.get(0));
        Assignment[] props = DatabeneScriptParser.parseFieldAssignments(childNodes, 1);
        return new BeanConstruction(className, props);
    }

    private static Assignment[] parseFieldAssignments(List<CommonTree> nodes, int firstIndex) throws SyntaxError {
        Assignment[] assignments = new Assignment[nodes.size() - firstIndex];
        for (int i = firstIndex; i < nodes.size(); ++i) {
            CommonTree assignmentNode = nodes.get(i);
            CommonTree nameNode = DatabeneScriptParser.childAt(0, assignmentNode);
            String name = nameNode.getType() == 19 ? DatabeneScriptParser.childAt(0, nameNode).getText() : nameNode.getText();
            CommonTree exNode = DatabeneScriptParser.childAt(1, assignmentNode);
            Expression<?> ex = DatabeneScriptParser.convertNode(exNode);
            assignments[i - firstIndex] = new Assignment(name, ex);
        }
        return assignments;
    }

    private static Expression<?> convertInvocation(CommonTree node) throws SyntaxError {
        String[] qn = DatabeneScriptParser.convertQualifiedNameToStringArray(DatabeneScriptParser.childAt(0, node));
        Expression<?>[] argExpressions = DatabeneScriptParser.parseArguments(DatabeneScriptParser.childAt(1, node));
        return new QNInvocationExpression(qn, argExpressions);
    }

    private static Expression<?> convertSubInvocation(CommonTree node) throws SyntaxError {
        Expression<?> object = DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node));
        String methodMame = (String)DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)).evaluate(null);
        Expression<?>[] argsExpressions = DatabeneScriptParser.parseArguments(DatabeneScriptParser.childAt(2, node));
        return new InvocationExpression(object, methodMame, argsExpressions);
    }

    private static Expression<?> convertIndex(CommonTree node) throws SyntaxError {
        return new IndexExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<?> convertField(CommonTree node) throws SyntaxError {
        return new FieldExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertIdentifier(DatabeneScriptParser.childAt(1, node)).evaluate(null));
    }

    private static Expression<?> convertCast(CommonTree node) throws SyntaxError {
        Class targetType = (Class)DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)).evaluate(null);
        Expression<?> sourceExpression = DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node));
        return new TypeConvertingExpression(sourceExpression, targetType);
    }

    private static Expression<?> convertNegation(CommonTree node) throws SyntaxError {
        return new UnaryMinusExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)));
    }

    private static Expression<?> convertLogicalComplement(CommonTree node) throws SyntaxError {
        return new LogicalComplementExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)));
    }

    private static Expression<?> convertBitwiseComplement(CommonTree node) throws SyntaxError {
        return new BitwiseComplementExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)));
    }

    private static String parseQualifiedNameOfClass(CommonTree node) {
        List<CommonTree> childNodes = DatabeneScriptParser.getChildNodes(node);
        StringBuffer className = new StringBuffer();
        for (CommonTree childNode : childNodes) {
            if (className.length() > 0) {
                className.append('.');
            }
            className.append(childNode.getText());
        }
        return className.toString();
    }

    private static Expression<?>[] parseArguments(CommonTree node) throws SyntaxError {
        List<CommonTree> childNodes = DatabeneScriptParser.getChildNodes(node);
        if (childNodes == null) {
            return EMPTY_ARGUMENT_LIST;
        }
        Expression[] result = new Expression[childNodes.size()];
        for (int i = 0; i < childNodes.size(); ++i) {
            CommonTree childNode = childNodes.get(i);
            result[i] = DatabeneScriptParser.convertNode(childNode);
        }
        return result;
    }

    private static Expression<?> convertPlus(CommonTree node) throws SyntaxError {
        SumExpression result = new SumExpression();
        for (CommonTree child : DatabeneScriptParser.getChildNodes(node)) {
            result.addTerm(DatabeneScriptParser.convertNode(child));
        }
        return result;
    }

    private static Expression<?> convertMinus(CommonTree node) throws SyntaxError {
        SubtractionExpression result = new SubtractionExpression();
        for (CommonTree child : DatabeneScriptParser.getChildNodes(node)) {
            result.addTerm(DatabeneScriptParser.convertNode(child));
        }
        return result;
    }

    private static Expression<?> convertStar(CommonTree node) throws SyntaxError {
        MultiplicationExpression result = new MultiplicationExpression();
        for (CommonTree child : DatabeneScriptParser.getChildNodes(node)) {
            result.addTerm(DatabeneScriptParser.convertNode(child));
        }
        return result;
    }

    private static Expression<?> convertSlash(CommonTree node) throws SyntaxError {
        DivisionExpression result = new DivisionExpression();
        for (CommonTree child : DatabeneScriptParser.getChildNodes(node)) {
            result.addTerm(DatabeneScriptParser.convertNode(child));
        }
        return result;
    }

    private static Expression<Object> convertPercent(CommonTree node) throws SyntaxError {
        return new ModuloExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Object> convertShiftLeft(CommonTree node) throws SyntaxError {
        return new LeftShiftExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Object> convertShiftRight(CommonTree node) throws SyntaxError {
        return new RightShiftExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Object> convertShiftRight2(CommonTree node) throws SyntaxError {
        return new UnsignedRightShiftExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Object> convertAnd(CommonTree node) throws SyntaxError {
        return new BitwiseAndExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Object> convertInclusiveOr(CommonTree node) throws SyntaxError {
        return new BitwiseOrExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Object> convertExclusiveOr(CommonTree node) throws SyntaxError {
        return new BitwiseExclusiveOrExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Boolean> convertEquals(CommonTree node) throws SyntaxError {
        return new EqualsExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Boolean> convertNotEquals(CommonTree node) throws SyntaxError {
        return new NotEqualsExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Boolean> convertLess(CommonTree node) throws SyntaxError {
        return new LessExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Boolean> convertLessOrEquals(CommonTree node) throws SyntaxError {
        return new LessOrEqualsExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Boolean> convertGreater(CommonTree node) throws SyntaxError {
        return new GreaterExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Boolean> convertGreaterOrEquals(CommonTree node) throws SyntaxError {
        return new GreaterOrEqualsExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static Expression<Boolean> convertConditionalOr(CommonTree node) throws SyntaxError {
        ConditionalOrExpression result = new ConditionalOrExpression("||", new Expression[0]);
        for (CommonTree child : DatabeneScriptParser.getChildNodes(node)) {
            result.addTerm(DatabeneScriptParser.convertNode(child));
        }
        return result;
    }

    private static Expression<Boolean> convertConditionalAnd(CommonTree node) throws SyntaxError {
        ConditionalAndExpression result = new ConditionalAndExpression("&&", new Expression[0]);
        for (CommonTree child : DatabeneScriptParser.getChildNodes(node)) {
            result.addTerm(DatabeneScriptParser.convertNode(child));
        }
        return result;
    }

    private static Expression<?> convertConditionalExpression(CommonTree node) throws SyntaxError {
        return new ConditionalExpression(DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(2, node)));
    }

    private static Expression<?> convertAssignment(CommonTree node) throws SyntaxError {
        return new AssignmentExpression(DatabeneScriptParser.convertQualifiedNameToStringArray(DatabeneScriptParser.childAt(0, node)), DatabeneScriptParser.convertNode(DatabeneScriptParser.childAt(1, node)));
    }

    private static CommonTree childAt(int index, CommonTree node) {
        return (CommonTree)node.getChild(index);
    }

    private static List<CommonTree> getChildNodes(CommonTree node) {
        return node.getChildren();
    }
}

