/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script;

import org.databene.commons.ArrayFormat;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.Context;
import org.databene.commons.ExceptionUtil;
import org.databene.commons.bean.DefaultClassProvider;
import org.databene.script.BeanSpec;
import org.databene.script.QNExpression;
import org.databene.script.expression.DynamicExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNBeanSpecExpression
extends DynamicExpression<Object> {
    String[] qn;

    public QNBeanSpecExpression(String[] qn) {
        this.qn = qn;
    }

    @Override
    public Object evaluate(Context context) {
        return this.resolve(context).getBean();
    }

    public BeanSpec resolve(Context context) {
        String objectOrClassName = ArrayFormat.format((String)".", (Object[])this.qn);
        try {
            if (context.contains(objectOrClassName)) {
                return BeanSpec.createReference(context.get(objectOrClassName));
            }
            String className = objectOrClassName;
            Class type = DefaultClassProvider.resolveByObjectOrDefaultInstance((String)className, (Object)context);
            return BeanSpec.createConstruction(BeanUtil.newInstance((Class)type, (Object[])new Object[0]));
        }
        catch (ConfigurationError e) {
            if (ExceptionUtil.getRootCause((Throwable)e) instanceof ClassNotFoundException) {
                return new QNExpression(this.qn).resolve(context);
            }
            throw new ConfigurationError("Cannot resolve " + objectOrClassName, (Throwable)e);
        }
    }
}

