/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.expression;

import org.databene.commons.ArrayUtil;
import org.databene.commons.Context;
import org.databene.script.Expression;
import org.databene.script.expression.CompositeExpression;
import org.databene.script.expression.ExpressionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayJoinExpression<E>
extends CompositeExpression<E[], E[]> {
    private Class<E> componentType;

    public ArrayJoinExpression(Class<E> componentType, Expression<E[]> ... terms) {
        super(terms);
        this.componentType = componentType;
    }

    @Override
    public E[] evaluate(Context context) {
        Object[][] arrays = (Object[][])ExpressionUtil.evaluateAll(this.terms, context);
        int totalLength = this.totalLength(arrays);
        Object[] result = ArrayUtil.newInstance(this.componentType(arrays), (int)totalLength);
        int resultIndex = 0;
        for (Object[] array : arrays) {
            for (int localIndex = 0; localIndex < array.length; ++localIndex) {
                result[resultIndex] = array[localIndex];
            }
        }
        return result;
    }

    private Class<E> componentType(E[][] arrays) {
        if (this.componentType == null) {
            for (E[] array : arrays) {
                if (array == null) continue;
                this.componentType = array.getClass().getComponentType();
                break;
            }
        }
        return this.componentType != null ? this.componentType : Object.class;
    }

    private int totalLength(E[][] arrays) {
        int totalLength = 0;
        for (E[] array : arrays) {
            totalLength += array.length;
        }
        return totalLength;
    }
}

