/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.expression;

import org.databene.commons.BeanUtil;
import org.databene.commons.Context;
import org.databene.commons.context.ContextAware;
import org.databene.script.Assignment;
import org.databene.script.Expression;
import org.databene.script.expression.DefaultConstruction;
import org.databene.script.expression.DynamicExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanConstruction<E>
extends DynamicExpression<E> {
    private Expression<E> instantiation;
    private Assignment[] assignments;

    public BeanConstruction(String beanClassName, Assignment[] assignments) {
        this(new DefaultConstruction(beanClassName), assignments);
    }

    public BeanConstruction(Expression<E> instantiation, Assignment[] assignments) {
        this.instantiation = instantiation;
        this.assignments = assignments;
    }

    @Override
    public E evaluate(Context context) {
        E bean = this.instantiation.evaluate(context);
        for (Assignment assignment : this.assignments) {
            String name = assignment.getName();
            Object value = assignment.getExpression().evaluate(context);
            if (BeanUtil.hasProperty(bean.getClass(), (String)name)) {
                BeanUtil.setPropertyValue(bean, (String)name, value, (boolean)false);
                continue;
            }
            BeanUtil.setAttributeValue(bean, (String)name, value);
        }
        if (bean instanceof ContextAware) {
            ((ContextAware)bean).setContext(context);
        }
        return bean;
    }
}

