/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.expression;

import java.util.ArrayList;
import java.util.List;
import org.databene.commons.Context;
import org.databene.script.Expression;
import org.databene.script.expression.ConstantExpression;
import org.databene.script.expression.UnescapeExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionUtil {
    public static Object[] evaluateAll(Expression<?>[] expressions, Context context) {
        Object[] result = new Object[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            result[i] = expressions[i].evaluate(context);
        }
        return result;
    }

    public static boolean isNull(Expression<?> ex) {
        if (ex == null) {
            return true;
        }
        return ex instanceof ConstantExpression && ((ConstantExpression)ex).getValue() == null;
    }

    public static List<Object> evaluateAll(List<Expression<?>> expressions, Context context) {
        ArrayList<Object> result = new ArrayList<Object>(expressions.size());
        for (Expression<?> expression : expressions) {
            result.add(expression.evaluate(context));
        }
        return result;
    }

    public static <T> T evaluate(Expression<T> expression, Context context) {
        return expression != null ? (T)expression.evaluate(context) : null;
    }

    public static <T> Expression<T> constant(T value) {
        return new ConstantExpression<T>(value);
    }

    public Expression<String> unescape(Expression<String> source) {
        return new UnescapeExpression(source);
    }

    public static <T> Expression<T> simplify(Expression<T> expression, Context context) {
        if (expression.isConstant() && !(expression instanceof ConstantExpression)) {
            return new ConstantExpression<T>(ExpressionUtil.evaluate(expression, context));
        }
        return expression;
    }
}

