/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.expression;

import java.util.Comparator;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ComparableComparator;
import org.databene.commons.Context;
import org.databene.script.Expression;
import org.databene.script.expression.CompositeExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxExpression<E>
extends CompositeExpression<E, E> {
    private Comparator<E> comparator;

    public MaxExpression(Expression<E> ... terms) {
        this((Comparator<E>)new ComparableComparator(), terms);
    }

    public MaxExpression(Comparator<E> comparator, Expression<E> ... terms) {
        super("", terms);
        this.comparator = comparator;
    }

    @Override
    public E evaluate(Context context) {
        Object max = this.terms[0].evaluate(context);
        for (int i = 1; i < this.terms.length; ++i) {
            Object tmp = this.terms[i].evaluate(context);
            if (this.comparator.compare(tmp, max) <= 0) continue;
            max = tmp;
        }
        return max;
    }

    @Override
    public String toString() {
        return "max(" + ArrayFormat.format((Object[])this.terms) + ')';
    }
}

