/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.expression;

import java.util.Comparator;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ComparableComparator;
import org.databene.commons.Context;
import org.databene.script.Expression;
import org.databene.script.expression.CompositeExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinExpression<E>
extends CompositeExpression<E, E> {
    private Comparator<E> comparator;

    public MinExpression(Expression<E> ... terms) {
        this((Comparator<E>)new ComparableComparator(), terms);
    }

    public MinExpression(Comparator<E> comparator, Expression<E> ... terms) {
        super("", terms);
        this.comparator = comparator;
    }

    @Override
    public E evaluate(Context context) {
        Object min = this.terms[0].evaluate(context);
        for (int i = 1; i < this.terms.length; ++i) {
            Object tmp = this.terms[i].evaluate(context);
            if (min == null) {
                min = tmp;
                continue;
            }
            if (tmp == null || this.comparator.compare(tmp, min) >= 0) continue;
            min = tmp;
        }
        return min;
    }

    @Override
    public String toString() {
        return "min(" + ArrayFormat.format((Object[])this.terms) + ')';
    }
}

