/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.databene.commons.BeanUtil;
import org.databene.commons.converter.AnyConverter;
import org.databene.script.math.DateArithmetic;
import org.databene.script.math.TimeArithmetic;
import org.databene.script.math.TimestampArithmetic;
import org.databene.script.math.TypeArithmetic;
import org.databene.script.math.TypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithmeticEngine {
    private static Map<Class<?>, TypeArithmetic<?>> typeArithmetics = new HashMap();
    private static ArithmeticEngine defaultInstance;

    private static void addTypeArithmetics(TypeArithmetic<?> ... arithmetics) {
        for (TypeArithmetic<?> arithmetic : arithmetics) {
            typeArithmetics.put(arithmetic.getBaseType(), arithmetic);
        }
    }

    public static ArithmeticEngine defaultInstance() {
        return defaultInstance;
    }

    public Object add(Object summand1, Object summand2) {
        if (summand1 == null) {
            return summand2;
        }
        if (summand2 == null) {
            return summand1;
        }
        Class<?> resultType = TypeManager.combinedType(summand1.getClass(), summand2.getClass());
        TypeArithmetic<?> typeArithmetic = typeArithmetics.get(resultType);
        if (typeArithmetic != null) {
            return typeArithmetic.add(summand1, summand2);
        }
        Object s1 = AnyConverter.convert((Object)summand1, resultType);
        Object s2 = AnyConverter.convert((Object)summand2, resultType);
        if (resultType == String.class) {
            return (String)s1 + s2;
        }
        if (resultType == Boolean.class) {
            return (Boolean)s1 != false || (Boolean)s2 != false;
        }
        if (resultType == Character.class) {
            return ((Character)s1).charValue() + ((Character)s2).charValue();
        }
        if (resultType == Byte.class) {
            return (Byte)s1 + (Byte)s2;
        }
        if (resultType == Short.class) {
            return (Short)s1 + (Short)s2;
        }
        if (resultType == Integer.class) {
            return (Integer)s1 + (Integer)s2;
        }
        if (resultType == Long.class) {
            return (Long)s1 + (Long)s2;
        }
        if (resultType == Float.class) {
            return Float.valueOf(((Float)s1).floatValue() + ((Float)s2).floatValue());
        }
        if (resultType == Double.class) {
            return (Double)s1 + (Double)s2;
        }
        if (resultType == BigInteger.class) {
            return ((BigInteger)s1).add((BigInteger)s2);
        }
        if (resultType == BigDecimal.class) {
            return ((BigDecimal)s1).add((BigDecimal)s2);
        }
        throw new UnsupportedOperationException("Addition of types " + BeanUtil.simpleClassName((Object)summand1) + " and " + BeanUtil.simpleClassName((Object)summand2) + " is not supported");
    }

    public Object subtract(Object minuend, Object subtrahend) {
        if (subtrahend == null) {
            return minuend;
        }
        if (minuend == null) {
            return this.negate(subtrahend);
        }
        Class<?> resultType = TypeManager.combinedType(minuend.getClass(), subtrahend.getClass());
        TypeArithmetic<?> typeArithmetic = typeArithmetics.get(resultType);
        if (typeArithmetic != null) {
            return typeArithmetic.subtract(minuend, subtrahend);
        }
        Object s1 = AnyConverter.convert((Object)minuend, resultType);
        Object s2 = AnyConverter.convert((Object)subtrahend, resultType);
        if (resultType == Character.class) {
            return ((Character)s1).charValue() - ((Character)s2).charValue();
        }
        if (resultType == Byte.class) {
            return (Byte)s1 - (Byte)s2;
        }
        if (resultType == Short.class) {
            return (Short)s1 - (Short)s2;
        }
        if (resultType == Integer.class) {
            return (Integer)s1 - (Integer)s2;
        }
        if (resultType == Long.class) {
            return (Long)s1 - (Long)s2;
        }
        if (resultType == Float.class) {
            return Float.valueOf(((Float)s1).floatValue() - ((Float)s2).floatValue());
        }
        if (resultType == Double.class) {
            return (Double)s1 - (Double)s2;
        }
        if (resultType == BigInteger.class) {
            return ((BigInteger)s1).subtract((BigInteger)s2);
        }
        if (resultType == BigDecimal.class) {
            return ((BigDecimal)s1).subtract((BigDecimal)s2);
        }
        throw new UnsupportedOperationException("Subtraction of type " + BeanUtil.simpleClassName((Object)subtrahend) + " from " + BeanUtil.simpleClassName((Object)minuend) + " is not supported");
    }

    public Object negate(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type == Byte.class) {
            return (int)(-((Byte)value).byteValue());
        }
        if (type == Short.class) {
            return (int)(-((Short)value).shortValue());
        }
        if (type == Integer.class) {
            return -((Integer)value).intValue();
        }
        if (type == Long.class) {
            return -((Long)value).longValue();
        }
        if (type == Float.class) {
            return Float.valueOf(-((Float)value).floatValue());
        }
        if (type == Double.class) {
            return -((Double)value).doubleValue();
        }
        if (type == BigInteger.class) {
            return ((BigInteger)value).negate();
        }
        if (type == BigDecimal.class) {
            return ((BigDecimal)value).negate();
        }
        throw new UnsupportedOperationException("Cannot negate " + BeanUtil.simpleClassName((Object)value));
    }

    public Object multiply(Object factor1, Object factor2) {
        if (factor1 == null || factor2 == null) {
            return null;
        }
        Class<?> resultType = TypeManager.combinedType(factor1.getClass(), factor2.getClass());
        TypeArithmetic<?> typeArithmetic = typeArithmetics.get(resultType);
        if (typeArithmetic != null) {
            return typeArithmetic.multiply(factor1, factor2);
        }
        Object s1 = AnyConverter.convert((Object)factor1, resultType);
        Object s2 = AnyConverter.convert((Object)factor2, resultType);
        if (resultType == Byte.class) {
            return (Byte)s1 * (Byte)s2;
        }
        if (resultType == Short.class) {
            return (Short)s1 * (Short)s2;
        }
        if (resultType == Integer.class) {
            return (Integer)s1 * (Integer)s2;
        }
        if (resultType == Long.class) {
            return (Long)s1 * (Long)s2;
        }
        if (resultType == Float.class) {
            return Float.valueOf(((Float)s1).floatValue() * ((Float)s2).floatValue());
        }
        if (resultType == Double.class) {
            return (Double)s1 * (Double)s2;
        }
        if (resultType == BigInteger.class) {
            return ((BigInteger)s1).multiply((BigInteger)s2);
        }
        if (resultType == BigDecimal.class) {
            return ((BigDecimal)s1).multiply((BigDecimal)s2);
        }
        throw new UnsupportedOperationException("Multiplication of type " + BeanUtil.simpleClassName((Object)factor1) + " with " + BeanUtil.simpleClassName((Object)factor2) + " is not supported");
    }

    public Object divide(Object dividend, Object divisor) {
        if (divisor == null) {
            throw new IllegalArgumentException("Division by null");
        }
        if (dividend == null) {
            return null;
        }
        Class<?> resultType = TypeManager.combinedType(dividend.getClass(), divisor.getClass());
        TypeArithmetic<?> typeArithmetic = typeArithmetics.get(resultType);
        if (typeArithmetic != null) {
            return typeArithmetic.multiply(dividend, divisor);
        }
        Object s1 = AnyConverter.convert((Object)dividend, resultType);
        Object s2 = AnyConverter.convert((Object)divisor, resultType);
        if (resultType == Byte.class) {
            return (Byte)s1 / (Byte)s2;
        }
        if (resultType == Short.class) {
            return (Short)s1 / (Short)s2;
        }
        if (resultType == Integer.class) {
            return (Integer)s1 / (Integer)s2;
        }
        if (resultType == Long.class) {
            return (Long)s1 / (Long)s2;
        }
        if (resultType == Float.class) {
            return Float.valueOf(((Float)s1).floatValue() / ((Float)s2).floatValue());
        }
        if (resultType == Double.class) {
            return (Double)s1 / (Double)s2;
        }
        if (resultType == BigInteger.class) {
            return ((BigInteger)s1).divide((BigInteger)s2);
        }
        if (resultType == BigDecimal.class) {
            return ((BigDecimal)s1).divide((BigDecimal)s2);
        }
        throw new UnsupportedOperationException("Multiplication of type " + BeanUtil.simpleClassName((Object)dividend) + " (" + dividend + ") with " + BeanUtil.simpleClassName((Object)divisor) + " (" + divisor + ") is not supported");
    }

    public boolean less(Object part1, Object part2) {
        if (part2 == null || part1 == null) {
            throw new IllegalArgumentException("Cannot compare null");
        }
        Class<?> resultType = TypeManager.combinedType(part1.getClass(), part2.getClass());
        Object s1 = AnyConverter.convert((Object)part1, resultType);
        Object s2 = AnyConverter.convert((Object)part2, resultType);
        if (Comparable.class.isAssignableFrom(resultType)) {
            return ((Comparable)s1).compareTo(s2) < 0;
        }
        throw new UnsupportedOperationException("Cannot compare type " + BeanUtil.simpleClassName((Object)part1) + " with " + BeanUtil.simpleClassName((Object)part2));
    }

    public boolean lessOrEquals(Object part1, Object part2) {
        if (part2 == null || part1 == null) {
            throw new IllegalArgumentException("Cannot compare null");
        }
        Class<?> resultType = TypeManager.combinedType(part1.getClass(), part2.getClass());
        Object s1 = AnyConverter.convert((Object)part1, resultType);
        Object s2 = AnyConverter.convert((Object)part2, resultType);
        if (Comparable.class.isAssignableFrom(resultType)) {
            return ((Comparable)s1).compareTo(s2) <= 0;
        }
        throw new UnsupportedOperationException("Cannot compare type " + BeanUtil.simpleClassName((Object)part1) + " with " + BeanUtil.simpleClassName((Object)part2));
    }

    public boolean equals(Object part1, Object part2) {
        if (part2 == null && part1 == null) {
            return true;
        }
        if (part2 == null || part1 == null) {
            return false;
        }
        Class<?> resultType = TypeManager.combinedType(part1.getClass(), part2.getClass());
        Object s1 = AnyConverter.convert((Object)part1, resultType);
        Object s2 = AnyConverter.convert((Object)part2, resultType);
        if (Comparable.class.isAssignableFrom(resultType)) {
            return ((Comparable)s1).compareTo(s2) == 0;
        }
        throw new UnsupportedOperationException("Cannot compare type " + BeanUtil.simpleClassName((Object)part1) + " with " + BeanUtil.simpleClassName((Object)part2));
    }

    public Boolean greater(Object o1, Object o2) {
        return this.less(o2, o1);
    }

    public Boolean greaterOrEquals(Object o1, Object o2) {
        return !this.less(o1, o2);
    }

    public Object bitwiseAnd(Object o1, Object o2) {
        Class<?> resultType = TypeManager.combinedType(o1.getClass(), o2.getClass());
        if (resultType == Boolean.class) {
            return (Boolean)o1 & (Boolean)o2;
        }
        if (!(o1 instanceof Number)) {
            throw new IllegalArgumentException("Not a number or boolean: " + o1);
        }
        if (!(o2 instanceof Number)) {
            throw new IllegalArgumentException("Not a number or boolean: " + o2);
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (resultType == Integer.class) {
            return n1.intValue() & n2.intValue();
        }
        if (resultType == Long.class) {
            return n1.longValue() & n2.longValue();
        }
        if (resultType == Short.class) {
            return n1.shortValue() & n2.shortValue();
        }
        if (resultType == Long.class) {
            return n1.byteValue() & n2.byteValue();
        }
        throw new IllegalStateException("Illegal state for " + resultType.getName());
    }

    public Object bitwiseOr(Object o1, Object o2) {
        Class<?> resultType = TypeManager.combinedType(o1.getClass(), o2.getClass());
        if (resultType == Boolean.class) {
            return (Boolean)o1 | (Boolean)o2;
        }
        if (!(o1 instanceof Number)) {
            throw new IllegalArgumentException("Not a number or boolean: " + o1);
        }
        if (!(o2 instanceof Number)) {
            throw new IllegalArgumentException("Not a number or boolean: " + o2);
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (resultType == Integer.class) {
            return n1.intValue() | n2.intValue();
        }
        if (resultType == Long.class) {
            return n1.longValue() | n2.longValue();
        }
        if (resultType == Short.class) {
            return n1.shortValue() | n2.shortValue();
        }
        if (resultType == Long.class) {
            return n1.byteValue() | n2.byteValue();
        }
        throw new IllegalStateException("Illegal state for " + resultType.getName());
    }

    public Object bitwiseExclusiveOr(Object o1, Object o2) {
        Class<?> resultType = TypeManager.combinedType(o1.getClass(), o2.getClass());
        if (resultType == Boolean.class) {
            return (Boolean)o1 ^ (Boolean)o2;
        }
        if (!(o1 instanceof Number)) {
            throw new IllegalArgumentException("Not a number or boolean: " + o1);
        }
        if (!(o2 instanceof Number)) {
            throw new IllegalArgumentException("Not a number or boolean: " + o2);
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (resultType == Integer.class) {
            return n1.intValue() ^ n2.intValue();
        }
        if (resultType == Long.class) {
            return n1.longValue() ^ n2.longValue();
        }
        if (resultType == Short.class) {
            return n1.shortValue() ^ n2.shortValue();
        }
        if (resultType == Long.class) {
            return n1.byteValue() ^ n2.byteValue();
        }
        throw new IllegalStateException("Illegal state for " + resultType.getName());
    }

    public Object shiftLeft(Object o1, Object o2) {
        if (!(o1 instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + o1);
        }
        if (!(o2 instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + o2);
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (n1 instanceof Integer) {
            return n1.intValue() << n2.intValue();
        }
        if (n1 instanceof Long) {
            return n1.longValue() << n2.intValue();
        }
        if (n1 instanceof Short) {
            return n1.shortValue() << n2.intValue();
        }
        if (n1 instanceof Byte) {
            return n1.byteValue() << n2.intValue();
        }
        throw new IllegalArgumentException("Cannot shift " + BeanUtil.simpleClassName((Object)o1));
    }

    public Object shiftRight(Object o1, Object o2) {
        if (!(o1 instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + o1);
        }
        if (!(o2 instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + o2);
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (n1 instanceof Integer) {
            return n1.intValue() >> n2.intValue();
        }
        if (n1 instanceof Long) {
            return n1.longValue() >> n2.intValue();
        }
        if (n1 instanceof Short) {
            return n1.shortValue() >> n2.intValue();
        }
        if (n1 instanceof Byte) {
            return n1.byteValue() >> n2.intValue();
        }
        throw new IllegalArgumentException("Cannot shift " + BeanUtil.simpleClassName((Object)o1));
    }

    public Object shiftRightUnsigned(Object o1, Object o2) {
        if (!(o1 instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + o1);
        }
        if (!(o2 instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + o2);
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (n1 instanceof Integer) {
            return n1.intValue() >>> n2.intValue();
        }
        if (n1 instanceof Long) {
            return n1.longValue() >>> n2.intValue();
        }
        if (n1 instanceof Short) {
            return n1.shortValue() >>> n2.intValue();
        }
        if (n1 instanceof Byte) {
            return n1.byteValue() >>> n2.intValue();
        }
        throw new IllegalArgumentException("Cannot shift " + BeanUtil.simpleClassName((Object)o1));
    }

    public Object mod(Object o1, Object o2) {
        if (!(o1 instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + o1);
        }
        if (!(o2 instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + o2);
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (n1 instanceof Integer) {
            return n1.intValue() % n2.intValue();
        }
        if (n1 instanceof Long) {
            return n1.longValue() % (long)n2.intValue();
        }
        if (n1 instanceof Short) {
            return n1.shortValue() % n2.intValue();
        }
        if (n1 instanceof Byte) {
            return n1.byteValue() % n2.intValue();
        }
        if (n1 instanceof BigInteger) {
            return ((BigInteger)n1).mod((BigInteger)n2);
        }
        throw new IllegalArgumentException("Cannot calculate the modulo of " + BeanUtil.simpleClassName((Object)o1));
    }

    public Object logicalComplement(Object value) {
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Not a boolean: " + value);
        }
        return (Boolean)value == false;
    }

    public Object bitwiseComplement(Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Not a number: " + value);
        }
        Number number = (Number)value;
        if (number instanceof Integer) {
            return ~number.intValue();
        }
        if (number instanceof Long) {
            return number.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (number instanceof Short) {
            return (int)(~number.shortValue());
        }
        if (number instanceof Byte) {
            return (int)(~number.byteValue());
        }
        throw new IllegalArgumentException("Cannot complement " + BeanUtil.simpleClassName((Object)value));
    }

    static {
        ArithmeticEngine.addTypeArithmetics(new DateArithmetic(), new TimeArithmetic(), new TimestampArithmetic());
        defaultInstance = new ArithmeticEngine();
    }
}

