/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.math;

import java.sql.Timestamp;
import java.util.Date;
import org.databene.commons.BeanUtil;
import org.databene.commons.TimeUtil;
import org.databene.script.math.TypeArithmetic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampArithmetic
extends TypeArithmetic<Timestamp> {
    public TimestampArithmetic() {
        super(Timestamp.class);
    }

    @Override
    public Timestamp add(Object summand1, Object summand2) {
        if (summand1 instanceof Timestamp) {
            return this.addToTimestamp((Timestamp)summand1, summand2);
        }
        if (summand2 instanceof Timestamp) {
            return this.addToTimestamp((Timestamp)summand2, summand1);
        }
        throw new IllegalArgumentException("No argument is of type " + this.baseType + ": " + summand1 + ", " + summand2);
    }

    @Override
    public Object subtract(Object minuend, Object subtrahend) {
        if (minuend instanceof Timestamp) {
            return this.subtractFromTimestamp((Timestamp)minuend, subtrahend);
        }
        throw new IllegalArgumentException("No argument is of type " + this.baseType + ": " + minuend + ", " + subtrahend);
    }

    @Override
    public Object multiply(Object factor1, Object factor2) {
        throw new UnsupportedOperationException("Cannot multiply timestamps");
    }

    @Override
    public Object divide(Object quotient, Object divisor) {
        throw new UnsupportedOperationException("Cannot divide timestamps");
    }

    private Timestamp addToTimestamp(Timestamp summand1, Object summand2) {
        if (summand2 instanceof Number) {
            return new Timestamp(summand1.getTime() + ((Number)summand2).longValue());
        }
        if (summand2 instanceof Timestamp) {
            return this.addTimestamps(summand1, (Timestamp)summand2);
        }
        if (summand2 instanceof Date) {
            return this.addTimestamps(summand1, new Timestamp(((Date)summand2).getTime()));
        }
        throw new IllegalArgumentException("Cannot add " + BeanUtil.simpleClassName((Object)summand2) + " to " + this.baseType.getName());
    }

    private Timestamp addTimestamps(Timestamp summand1, Timestamp summand2) {
        int nanoSum = summand1.getNanos() + summand2.getNanos();
        Timestamp result = new Timestamp(summand1.getTime() + TimeUtil.millisSinceOwnEpoch((Date)summand2) + (long)nanoSum / 1000000000L);
        result.setNanos(nanoSum % 1000000000);
        return result;
    }

    private Timestamp subtractFromTimestamp(Timestamp minuend, Object subtrahend) {
        if (subtrahend instanceof Number) {
            return new Timestamp(minuend.getTime() - ((Number)subtrahend).longValue());
        }
        if (subtrahend instanceof Timestamp) {
            return this.subtractTimestamps(minuend, (Timestamp)subtrahend);
        }
        if (subtrahend instanceof Date) {
            return this.subtractTimestamps(minuend, new Timestamp(((Date)subtrahend).getTime()));
        }
        throw new IllegalArgumentException("Cannot subtract " + BeanUtil.simpleClassName((Object)subtrahend) + " from " + minuend.getClass().getName());
    }

    private Timestamp subtractTimestamps(Timestamp minuend, Timestamp subtrahend) {
        int nanoDiff = minuend.getNanos() - subtrahend.getNanos();
        if (nanoDiff < 0) {
            nanoDiff += 1000000000;
        }
        Timestamp result = new Timestamp(minuend.getTime() - TimeUtil.millisSinceOwnEpoch((Date)subtrahend) - (long)(nanoDiff / 1000000));
        result.setNanos(nanoDiff % 1000000000);
        return result;
    }
}

