/*
 * Decompiled with CFR 0.152.
 */
package org.databene.script.expression;

import java.util.List;
import java.util.Map;
import org.databene.commons.BeanUtil;
import org.databene.commons.Context;
import org.databene.commons.converter.AnyConverter;
import org.databene.script.Expression;
import org.databene.script.expression.BinaryExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexExpression
extends BinaryExpression<Object> {
    public IndexExpression(Expression<?> term1, Expression<?> term2) {
        super(term1, term2);
    }

    @Override
    public Object evaluate(Context context) {
        Object container = this.term1.evaluate(context);
        Object indexObject = this.term2.evaluate(context);
        if (container instanceof List) {
            int index = (Integer)AnyConverter.convert(indexObject, Integer.class);
            return ((List)container).get(index);
        }
        if (container.getClass().isArray()) {
            int index = (Integer)AnyConverter.convert(indexObject, Integer.class);
            return ((Object[])container)[index];
        }
        if (container instanceof String) {
            int index = (Integer)AnyConverter.convert(indexObject, Integer.class);
            return Character.valueOf(((String)container).charAt(index));
        }
        if (container instanceof Map) {
            return ((Map)container).get(indexObject);
        }
        throw new IllegalArgumentException("Cannot do index-based access on " + BeanUtil.simpleClassName(container));
    }

    @Override
    public String toString() {
        return this.term1 + "[" + this.term2 + "]";
    }
}

