/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.authz;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    static final Logger LOG = LoggerFactory.getLogger(ConfigUtil.class);

    public static Stream<String> props() {
        return Stream.concat(System.getenv().keySet().stream(), System.getProperties().stringPropertyNames().stream()).map(ConfigUtil::toPropName);
    }

    public static Map<String, String> extract(Stream<String> props, String prefix) {
        return props.filter(key -> key.startsWith(ConfigUtil.toPropName(prefix))).filter(prop -> ConfigUtil.getValue(prop) != null).collect(Collectors.toMap(prop -> ConfigUtil.removePrefix(prefix, prop), prop -> ConfigUtil.getValue(prop)));
    }

    public static String getValue(String key) {
        return System.getProperty(key, System.getenv(ConfigUtil.toEnvName(key)));
    }

    static String removePrefix(String prefix, String key) {
        return key.replaceFirst("^" + prefix, "").replaceFirst(".", "");
    }

    public static String toPropName(String name) {
        return name.toLowerCase().replace('_', '.');
    }

    public static String toEnvName(String name) {
        return name.toUpperCase().replace('.', '_');
    }
}

