/*
 * Decompiled with CFR 0.152.
 */
package org.dataconservancy.pass.authz;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringLRUCache<K, V> {
    Logger LOG = LoggerFactory.getLogger(ExpiringLRUCache.class);
    ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    ExecutorService runner = Executors.newCachedThreadPool();
    final Duration expiry;
    private final Map<K, Future<V>> cache;
    private final String name = Thread.currentThread().getStackTrace()[2].getClassName();

    public ExpiringLRUCache(final int capacity, Duration expiry) {
        this.cache = new LinkedHashMap<K, Future<V>>(capacity){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Future<V>> eldest) {
                if (this.size() > capacity) {
                    ExpiringLRUCache.this.LOG.info("[{}] Cache full, removing oldest entry; {}", (Object)ExpiringLRUCache.this.name, eldest.getKey());
                    return true;
                }
                return false;
            }
        };
        this.expiry = expiry;
    }

    public V getOrDo(K key, Callable<V> generator) {
        return this.getOrDo(key, generator, false);
    }

    public V doAndCache(K key, Callable<V> generator) {
        return this.getOrDo(key, generator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getOrDo(K key, Callable<V> generator, boolean forceGenerate) {
        Future<Object> result;
        boolean cached = true;
        Map<K, Future<V>> map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(key) && !forceGenerate) {
                result = this.cache.get(key);
                cached = true;
            } else {
                cached = false;
                result = this.runner.submit(() -> {
                    Object value = generator.call();
                    this.LOG.debug("[{}] Calculated value for {} as {}", new Object[]{this.name, key, value});
                    return value;
                });
                this.cache.put(key, result);
                this.scheduler.schedule(() -> {
                    this.LOG.info("[{}] Expiring cached value for {}", (Object)this.name, key);
                    this.remove(key);
                }, this.expiry.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        V value = ExpiringLRUCache.doGet(result);
        if (value == null) {
            this.LOG.info("[{}] Value for key {} is null, refusing to cache it", (Object)this.name, key);
            this.remove(key);
        } else if (cached) {
            this.LOG.debug("[{}] Returning cached value for {}: {}", new Object[]{this.name, key, value});
        } else {
            this.LOG.debug("[{}] Return calculated value for {}: {}", new Object[]{this.name, key, value});
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(K key) {
        Map<K, Future<V>> map = this.cache;
        synchronized (map) {
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Map<K, Future<V>> map = this.cache;
        synchronized (map) {
            return Optional.ofNullable(this.cache.get(key)).map(ExpiringLRUCache::doGet).orElse(null);
        }
    }

    private static <V> V doGet(Future<V> value) {
        try {
            return value.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Read from cache was interrupted");
        }
    }
}

